/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.function;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javolution.context.ObjectFactory;
import javolution.text.Text;
import javolution.text.TextBuilder;
import javolution.util.FastMap;
import javolution.util.FastTable;
import org.jscience.mathematics.function.Constant;
import org.jscience.mathematics.function.Function;
import org.jscience.mathematics.function.FunctionException;
import org.jscience.mathematics.function.Term;
import org.jscience.mathematics.function.Variable;
import org.jscience.mathematics.structure.GroupAdditive;
import org.jscience.mathematics.structure.GroupMultiplicative;
import org.jscience.mathematics.structure.Ring;

public class Polynomial<R extends Ring<R>>
extends Function<R, R>
implements Ring<Polynomial<R>> {
    final FastMap<Term, R> _termToCoef = new FastMap();
    private static final ObjectFactory<Polynomial> FACTORY = new ObjectFactory<Polynomial>(){

        protected Polynomial create() {
            return new Polynomial();
        }
    };
    private static final long serialVersionUID = 1L;

    Polynomial() {
    }

    public static <R extends Ring<R>> Polynomial<R> valueOf(R coefficient, Variable<R> variable) {
        return Polynomial.valueOf(coefficient, Term.valueOf(variable, 1));
    }

    public static <R extends Ring<R>> Polynomial<R> valueOf(R coefficient, Term term) {
        if (term.equals(Term.ONE)) {
            return Constant.valueOf(coefficient);
        }
        if (Polynomial.isZero(coefficient)) {
            return Constant.valueOf(coefficient);
        }
        Polynomial<R> p = Polynomial.newInstance();
        p._termToCoef.put((Object)term, coefficient);
        return p;
    }

    private static boolean isZero(GroupAdditive<?> coefficient) {
        return coefficient.equals(coefficient.opposite());
    }

    public Set<Term> getTerms() {
        return this._termToCoef.unmodifiable().keySet();
    }

    public final R getCoefficient(Term term) {
        return (R)((Ring)this._termToCoef.get((Object)term));
    }

    public int getOrder(Variable<R> v) {
        int order = 0;
        for (Term term : this._termToCoef.keySet()) {
            int power = term.getPower(v);
            if (power <= order) continue;
            order = power;
        }
        return order;
    }

    @Override
    public Polynomial<R> plus(R constantValue) {
        return this.plus(Constant.valueOf(constantValue));
    }

    @Override
    public Polynomial<R> times(R constantValue) {
        return this.times(Constant.valueOf(constantValue));
    }

    @Override
    public Polynomial<R> plus(Polynomial<R> that) {
        Polynomial<R> result = Polynomial.newInstance();
        Ring zero = null;
        result._termToCoef.putAll(this._termToCoef);
        result._termToCoef.putAll(that._termToCoef);
        FastMap.Entry e = result._termToCoef.head();
        FastMap.Entry end = result._termToCoef.tail();
        while ((e = e.getNext()) != end) {
            Term term = (Term)e.getKey();
            Ring thisCoef = (Ring)this._termToCoef.get((Object)term);
            Ring thatCoef = (Ring)that._termToCoef.get((Object)term);
            if (thisCoef == null || thatCoef == null) continue;
            Ring sum = thisCoef.plus(thatCoef);
            if (Polynomial.isZero(sum)) {
                FastMap.Entry prev = e.getPrevious();
                result._termToCoef.remove((Object)term);
                e = prev;
                zero = sum;
                continue;
            }
            result._termToCoef.put((Object)term, (Object)sum);
        }
        if (result._termToCoef.size() == 0) {
            return Constant.valueOf(zero);
        }
        return result;
    }

    @Override
    public Polynomial<R> opposite() {
        Polynomial<R> result = Polynomial.newInstance();
        FastMap.Entry e = this._termToCoef.head();
        FastMap.Entry end = this._termToCoef.tail();
        while ((e = e.getNext()) != end) {
            result._termToCoef.put((Object)((Term)e.getKey()), (Object)((Ring)((Ring)e.getValue()).opposite()));
        }
        return result;
    }

    public Polynomial<R> minus(Polynomial<R> that) {
        return this.plus((Polynomial<R>)that.opposite());
    }

    @Override
    public Polynomial<R> times(Polynomial<R> that) {
        Polynomial<R> result = Polynomial.newInstance();
        Ring zero = null;
        for (Map.Entry entry1 : this._termToCoef.entrySet()) {
            Term t1 = (Term)entry1.getKey();
            Ring c1 = (Ring)entry1.getValue();
            for (Map.Entry entry2 : that._termToCoef.entrySet()) {
                Ring coef;
                Term t2 = (Term)entry2.getKey();
                Ring c2 = (Ring)entry2.getValue();
                Term t = t1.times(t2);
                Ring c = c1.times(c2);
                R prev = result.getCoefficient(t);
                Ring ring = coef = prev != null ? prev.plus((Ring)c) : c;
                if (Polynomial.isZero(coef)) {
                    zero = coef;
                    continue;
                }
                result._termToCoef.put((Object)t, (Object)coef);
            }
        }
        if (result._termToCoef.size() == 0) {
            return Constant.valueOf(zero);
        }
        return result;
    }

    public Polynomial<R> compose(Polynomial<R> that) {
        List<Variable<R>> variables = this.getVariables();
        if (this.getVariables().size() != 1) {
            throw new FunctionException("This polynomial is not monovariate");
        }
        Variable<R> v = variables.get(0);
        Polynomial result = null;
        for (Map.Entry entry : this._termToCoef.entrySet()) {
            Term term = (Term)entry.getKey();
            Constant<Ring> cst = Constant.valueOf((Ring)entry.getValue());
            int power = term.getPower(v);
            if (power > 0) {
                Function fn = that.pow(power);
                result = result != null ? result.plus(cst.times((Polynomial<Ring>)fn)) : cst.times((Polynomial<Ring>)fn);
                continue;
            }
            Polynomial polynomial = result = result != null ? result.plus(cst) : cst;
        }
        return result;
    }

    @Override
    public <Z> Function<Z, R> compose(Function<Z, R> that) {
        return that instanceof Polynomial ? this.compose((Polynomial)that) : super.compose(that);
    }

    public Polynomial<R> differentiate(Variable<R> v) {
        if (this.getOrder(v) > 0) {
            Polynomial<Ring> result = null;
            for (Map.Entry entry : this._termToCoef.entrySet()) {
                Term term = (Term)entry.getKey();
                Ring coef = (Ring)entry.getValue();
                int power = term.getPower(v);
                if (power <= 0) continue;
                Ring newCoef = Polynomial.multiply(coef, power);
                Term newTerm = term.divide(Term.valueOf(v, 1));
                Polynomial<Ring> p = Polynomial.valueOf(newCoef, newTerm);
                Polynomial<Ring> polynomial = result = result != null ? result.plus(p) : p;
            }
            return result;
        }
        Ring coef = (Ring)this._termToCoef.values().iterator().next();
        return Constant.valueOf(coef.plus((Ring)coef.opposite()));
    }

    private static <R extends Ring<R>> R multiply(R o, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n: " + n + " zero or negative values not allowed");
        }
        R shift2 = o;
        GroupAdditive result = null;
        while (n >= 1) {
            if ((n & 1) == 1) {
                result = result == null ? shift2 : result.plus(shift2);
            }
            shift2 = shift2.plus(shift2);
            n >>>= 1;
        }
        return (R)result;
    }

    public Polynomial<R> integrate(Variable<R> v) {
        Polynomial<Ring> result = null;
        for (Map.Entry entry : this._termToCoef.entrySet()) {
            Term term = (Term)entry.getKey();
            Ring coef = (Ring)entry.getValue();
            int power = term.getPower(v);
            Ring newCoef = (Ring)((GroupMultiplicative)((Object)Polynomial.multiply((Ring)((GroupMultiplicative)((Object)coef)).inverse(), power + 1))).inverse();
            Term newTerm = term.times(Term.valueOf(v, 1));
            Polynomial<Ring> p = Polynomial.valueOf(newCoef, newTerm);
            Polynomial<Ring> polynomial = result = result != null ? result.plus(p) : p;
        }
        return result;
    }

    @Override
    public Function<R, R> plus(Function<R, R> that) {
        return that instanceof Polynomial ? this.plus((Polynomial)that) : super.plus(that);
    }

    @Override
    public Function<R, R> minus(Function<R, R> that) {
        return that instanceof Polynomial ? this.minus((Polynomial)that) : super.minus(that);
    }

    @Override
    public Function<R, R> times(Function<R, R> that) {
        return that instanceof Polynomial ? this.times((Polynomial)that) : super.times(that);
    }

    public Polynomial<R> pow(int n) {
        return (Polynomial)super.pow(n);
    }

    @Override
    public List<Variable<R>> getVariables() {
        Term product = (Term)this._termToCoef.head().getNext().getKey();
        FastMap.Entry e = this._termToCoef.head().getNext();
        FastMap.Entry end = this._termToCoef.tail();
        while ((e = e.getNext()) != end) {
            product = product.times((Term)e.getKey());
        }
        FastTable vars = FastTable.newInstance();
        int i = 0;
        int n = product.size();
        while (i < n) {
            vars.add(product.getVariable(i));
            ++i;
        }
        return vars;
    }

    @Override
    public R evaluate() {
        Ring sum = null;
        for (Map.Entry entry : this._termToCoef.entrySet()) {
            Term term = (Term)entry.getKey();
            Ring coef = (Ring)entry.getValue();
            Ring termValue = term.evaluate();
            Ring value = termValue != null ? coef.times(termValue) : coef;
            Ring ring = sum = sum == null ? value : sum.plus(value);
        }
        return (R)sum;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Polynomial)) {
            return false;
        }
        Polynomial that = (Polynomial)obj;
        return this._termToCoef.equals(that._termToCoef);
    }

    @Override
    public int hashCode() {
        return this._termToCoef.hashCode();
    }

    @Override
    public Text toText() {
        FastTable terms = FastTable.newInstance();
        terms.addAll((Collection)this._termToCoef.keySet());
        terms.sort();
        TextBuilder tb = TextBuilder.newInstance();
        int i = 0;
        int n = terms.size();
        while (i < n) {
            if (i != 0) {
                tb.append(" + ");
            }
            tb.append('[').append(this._termToCoef.get(terms.get(i)));
            tb.append(']').append(terms.get(i));
            ++i;
        }
        return tb.toText();
    }

    public Polynomial<R> copy() {
        Polynomial<R> p = Polynomial.newInstance();
        for (Map.Entry entry : this._termToCoef.entrySet()) {
            p._termToCoef.put((Object)((Term)entry.getKey()).copy(), (Object)((Ring)entry.getValue()));
        }
        return p;
    }

    private static <R extends Ring<R>> Polynomial<R> newInstance() {
        Polynomial p = (Polynomial)FACTORY.object();
        p._termToCoef.clear();
        return p;
    }
}

