/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.vector;

import java.util.Map;
import javolution.context.ObjectFactory;
import javolution.util.FastComparator;
import javolution.util.FastMap;
import javolution.util.Index;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.jscience.mathematics.structure.Field;
import org.jscience.mathematics.vector.DimensionException;
import org.jscience.mathematics.vector.Vector;

public final class SparseVector<F extends Field<F>>
extends Vector<F> {
    protected static final XMLFormat<SparseVector> XML = new XMLFormat<SparseVector>(SparseVector.class){

        public SparseVector newInstance(Class<SparseVector> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return (SparseVector)FACTORY.object();
        }

        public void read(XMLFormat.InputElement xml, SparseVector V) throws XMLStreamException {
            V._dimension = xml.getAttribute("dimension", 0);
            V._zero = (Field)xml.get("Zero");
            V._elements.putAll((Map)xml.get("Elements", FastMap.class));
        }

        public void write(SparseVector V, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("dimension", V._dimension);
            xml.add(V._zero, "Zero");
            xml.add(V._elements, "Elements", FastMap.class);
        }
    };
    int _dimension;
    F _zero;
    final FastMap<Index, F> _elements = new FastMap();
    private static final ObjectFactory<SparseVector> FACTORY = new ObjectFactory<SparseVector>(){

        protected SparseVector create() {
            return new SparseVector();
        }

        protected void cleanup(SparseVector vector) {
            vector._elements.reset();
        }
    };
    private static final long serialVersionUID = 1L;

    public static <F extends Field<F>> SparseVector<F> valueOf(int dimension, F zero, int i, F element) {
        SparseVector<F> V = SparseVector.newInstance(dimension, zero);
        V._elements.put((Object)Index.valueOf((int)i), element);
        return V;
    }

    public static <F extends Field<F>> SparseVector<F> valueOf(int dimension, F zero, Map<Index, F> elements) {
        SparseVector<F> V = SparseVector.newInstance(dimension, zero);
        V._elements.putAll(elements);
        return V;
    }

    public static <F extends Field<F>> SparseVector<F> valueOf(Vector<F> that, F zero) {
        return SparseVector.valueOf(that, zero, FastComparator.DEFAULT);
    }

    public static <F extends Field<F>> SparseVector<F> valueOf(Vector<F> that, F zero, FastComparator<? super F> comparator) {
        if (that instanceof SparseVector) {
            return SparseVector.valueOf((SparseVector)that, zero, comparator);
        }
        int n = that.getDimension();
        SparseVector<F> V = SparseVector.newInstance(n, zero);
        int i = 0;
        while (i < n) {
            F element = that.get(i);
            if (!comparator.areEqual(zero, element)) {
                V._elements.put((Object)Index.valueOf((int)i), element);
            }
            ++i;
        }
        return V;
    }

    private static <F extends Field<F>> SparseVector<F> valueOf(SparseVector<F> that, F zero, FastComparator<? super F> comparator) {
        SparseVector<F> V = SparseVector.newInstance(that._dimension, zero);
        FastMap.Entry e = that._elements.head();
        FastMap.Entry n = that._elements.tail();
        while ((e = e.getNext()) != n) {
            if (comparator.areEqual(e.getValue(), zero)) continue;
            V._elements.put((Object)((Index)e.getKey()), (Object)((Field)e.getValue()));
        }
        return V;
    }

    public F getZero() {
        return this._zero;
    }

    @Override
    public int getDimension() {
        return this._dimension;
    }

    @Override
    public F get(int i) {
        if (i < 0 || i >= this._dimension) {
            throw new IndexOutOfBoundsException();
        }
        Field element = (Field)this._elements.get((Object)Index.valueOf((int)i));
        return (F)(element == null ? this._zero : element);
    }

    @Override
    public SparseVector<F> opposite() {
        SparseVector<F> V = SparseVector.newInstance(this._dimension, this._zero);
        FastMap.Entry e = this._elements.head();
        FastMap.Entry n = this._elements.tail();
        while ((e = e.getNext()) != n) {
            V._elements.put((Object)((Index)e.getKey()), (Object)((Field)((Field)e.getValue()).opposite()));
        }
        return V;
    }

    @Override
    public SparseVector<F> plus(Vector<F> that) {
        if (that instanceof SparseVector) {
            return this.plus((SparseVector)that);
        }
        return this.plus(SparseVector.valueOf(that, this._zero, FastComparator.DEFAULT));
    }

    @Override
    private SparseVector<F> plus(SparseVector<F> that) {
        if (this._dimension != that._dimension) {
            throw new DimensionException();
        }
        SparseVector<F> V = SparseVector.newInstance(this._dimension, this._zero);
        V._elements.putAll(this._elements);
        FastMap.Entry e = that._elements.head();
        FastMap.Entry n = that._elements.tail();
        while ((e = e.getNext()) != n) {
            Index index = (Index)e.getKey();
            FastMap.Entry entry = V._elements.getEntry((Object)index);
            if (entry == null) {
                V._elements.put((Object)index, (Object)((Field)e.getValue()));
                continue;
            }
            entry.setValue((Object)((Field)entry.getValue()).plus((Field)e.getValue()));
        }
        return V;
    }

    @Override
    public SparseVector<F> times(F k) {
        SparseVector<F> V = SparseVector.newInstance(this._dimension, this._zero);
        FastMap.Entry e = this._elements.head();
        FastMap.Entry n = this._elements.tail();
        while ((e = e.getNext()) != n) {
            V._elements.put((Object)((Index)e.getKey()), (Object)((Field)((Field)e.getValue()).times(k)));
        }
        return V;
    }

    @Override
    public F times(Vector<F> that) {
        if (that.getDimension() != this._dimension) {
            throw new DimensionException();
        }
        Field sum = null;
        FastMap.Entry e = this._elements.head();
        FastMap.Entry n = this._elements.tail();
        while ((e = e.getNext()) != n) {
            Field f = (Field)((Field)e.getValue()).times(that.get(((Index)e.getKey()).intValue()));
            Field field = sum = sum == null ? f : sum.plus(f);
        }
        return (F)(sum != null ? sum : (Field)this._zero);
    }

    @Override
    public SparseVector<F> copy() {
        SparseVector<Field> V = SparseVector.newInstance(this._dimension, (Field)this._zero.copy());
        for (Map.Entry e : this._elements.entrySet()) {
            V._elements.put((Object)((Index)e.getKey()), (Object)((Field)((Field)e.getValue()).copy()));
        }
        return V;
    }

    static <F extends Field<F>> SparseVector<F> newInstance(int dimension, F zero) {
        SparseVector V = (SparseVector)FACTORY.object();
        V._dimension = dimension;
        V._zero = zero;
        return V;
    }

    private SparseVector() {
    }
}

