/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.physics.amount;

import java.io.Serializable;
import javax.measure.Measurable;
import javax.measure.converter.ConversionException;
import javax.measure.converter.RationalConverter;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import javax.realtime.MemoryArea;
import javolution.context.ObjectFactory;
import javolution.lang.Immutable;
import javolution.lang.MathLib;
import javolution.text.Text;
import javolution.util.FastComparator;
import javolution.util.FastMap;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.jscience.mathematics.structure.Field;
import org.jscience.physics.amount.AmountException;
import org.jscience.physics.amount.AmountFormat;

public final class Amount<Q extends Quantity>
implements Measurable<Q>,
Field<Amount<?>>,
Serializable,
Immutable {
    public static final Amount<Dimensionless> ZERO = new Amount();
    public static final Amount<Dimensionless> ONE;
    protected static final XMLFormat<Amount> XML;
    private boolean _isExact;
    private long _exactValue;
    private double _minimum;
    private double _maximum;
    private Unit<Q> _unit;
    static final FastMap<Unit<?>, FastMap<Unit<?>, Unit<?>>> MULT_LOOKUP;
    static final FastMap<Unit<?>, Unit<?>> INV_LOOKUP;
    static final FastMap<Unit<?>, FastMap<Unit<?>, UnitConverter>> CVTR_LOOKUP;
    private static final ObjectFactory<Amount> FACTORY;
    static final double DOUBLE_RELATIVE_ERROR;
    static final double DECREMENT;
    static final double INCREMENT;
    private static final long serialVersionUID = 1L;

    static {
        Amount.ZERO._unit = Unit.ONE;
        Amount.ZERO._isExact = true;
        Amount.ZERO._exactValue = 0L;
        Amount.ZERO._minimum = 0.0;
        Amount.ZERO._maximum = 0.0;
        ONE = new Amount();
        Amount.ONE._unit = Unit.ONE;
        Amount.ONE._isExact = true;
        Amount.ONE._exactValue = 1L;
        Amount.ONE._minimum = 1.0;
        Amount.ONE._maximum = 1.0;
        XML = new XMLFormat<Amount>(Amount.class){

            public Amount newInstance(Class<Amount> cls, XMLFormat.InputElement xml) throws XMLStreamException {
                Unit<Quantity> unit = Unit.valueOf((CharSequence)xml.getAttribute("unit"));
                Amount m = Amount.newInstance(unit);
                if (xml.getAttribute("error") == null) {
                    return m.setExact(xml.getAttribute("value", 0L));
                }
                m._isExact = false;
                double estimatedValue = xml.getAttribute("value", 0.0);
                double error = xml.getAttribute("error", 0.0);
                m._minimum = estimatedValue - error;
                m._maximum = estimatedValue + error;
                return m;
            }

            public void read(XMLFormat.InputElement arg0, Amount arg1) throws XMLStreamException {
            }

            public void write(Amount m, XMLFormat.OutputElement xml) throws XMLStreamException {
                if (m._isExact) {
                    xml.setAttribute("value", m._exactValue);
                } else {
                    xml.setAttribute("value", m.getEstimatedValue());
                    xml.setAttribute("error", m.getAbsoluteError());
                }
                xml.setAttribute("unit", m._unit.toString());
            }
        };
        MULT_LOOKUP = new FastMap("UNITS_MULT_LOOKUP").setKeyComparator(FastComparator.DIRECT);
        INV_LOOKUP = new FastMap("UNITS_INV_LOOKUP").setKeyComparator(FastComparator.DIRECT);
        CVTR_LOOKUP = new FastMap("UNITS_CVTR_LOOKUP").setKeyComparator(FastComparator.DIRECT);
        FACTORY = new ObjectFactory<Amount>(){

            protected Amount create() {
                return new Amount();
            }
        };
        DOUBLE_RELATIVE_ERROR = MathLib.pow((double)2.0, (double)-53.0);
        DECREMENT = 1.0 - DOUBLE_RELATIVE_ERROR;
        INCREMENT = 1.0 + DOUBLE_RELATIVE_ERROR;
    }

    public static <Q extends Quantity> Amount<Q> valueOf(long value, Unit<Q> unit) {
        Amount<Q> m = Amount.newInstance(unit);
        return m.setExact(value);
    }

    public static <Q extends Quantity> Amount<Q> valueOf(double value, Unit<Q> unit) {
        Amount<Q> m = Amount.newInstance(unit);
        m._isExact = false;
        double valInc = value * INCREMENT;
        double valDec = value * DECREMENT;
        m._minimum = value < 0.0 ? valInc : valDec;
        m._maximum = value < 0.0 ? valDec : valInc;
        return m;
    }

    public static <Q extends Quantity> Amount<Q> valueOf(double value, double error, Unit<Q> unit) {
        if (error < 0.0) {
            throw new IllegalArgumentException("error: " + error + " is negative");
        }
        Amount<Q> m = Amount.newInstance(unit);
        double min = value - error;
        double max = value + error;
        m._isExact = false;
        m._minimum = min < 0.0 ? min * INCREMENT : min * DECREMENT;
        m._maximum = max < 0.0 ? max * DECREMENT : max * INCREMENT;
        return m;
    }

    public static <Q extends Quantity> Amount<Q> rangeOf(double minimum, double maximum, Unit<Q> unit) {
        if (minimum > maximum) {
            throw new IllegalArgumentException("minimum: " + minimum + " greater than maximum: " + maximum);
        }
        Amount<Q> m = Amount.newInstance(unit);
        m._isExact = false;
        m._minimum = minimum < 0.0 ? minimum * INCREMENT : minimum * DECREMENT;
        m._maximum = maximum < 0.0 ? maximum * DECREMENT : maximum * INCREMENT;
        return m;
    }

    public static Amount<?> valueOf(CharSequence csq) {
        return (Amount)AmountFormat.getInstance().parse(csq);
    }

    public boolean isExact() {
        return this._isExact;
    }

    public Unit<Q> getUnit() {
        return this._unit;
    }

    public long getExactValue() throws AmountException {
        if (!this._isExact) {
            throw new AmountException("Inexact measures don't have exact values");
        }
        return this._exactValue;
    }

    public double getEstimatedValue() {
        return this._isExact ? (double)this._exactValue : (this._minimum + this._maximum) * 0.5;
    }

    public double getMinimumValue() {
        return this._minimum;
    }

    public double getMaximumValue() {
        return this._maximum;
    }

    public double getAbsoluteError() {
        return MathLib.abs((double)(this._maximum - this._minimum)) * 0.5;
    }

    public double getRelativeError() {
        return this._isExact ? 0.0 : (this._maximum - this._minimum) / (this._minimum + this._maximum);
    }

    public <R extends Quantity> Amount<R> to(Unit<R> unit) {
        if (this._unit == unit || this._unit.equals(unit)) {
            return this;
        }
        UnitConverter cvtr = Amount.converterOf(this._unit, unit);
        if (cvtr == UnitConverter.IDENTITY) {
            Amount<Q> result = Amount.copyOf(this);
            result._unit = unit;
            return result;
        }
        if (cvtr instanceof RationalConverter) {
            RationalConverter rc = (RationalConverter)cvtr;
            Amount<Q> result = this.times(rc.getDividend()).divide(rc.getDivisor());
            result._unit = unit;
            return result;
        }
        Amount<Q> result = Amount.newInstance(unit);
        double min = cvtr.convert(this._minimum);
        double max = cvtr.convert(this._maximum);
        result._isExact = false;
        result._minimum = min < 0.0 ? min * INCREMENT : min * DECREMENT;
        result._maximum = max < 0.0 ? max * DECREMENT : max * INCREMENT;
        return result;
    }

    @Override
    public Amount<Q> opposite() {
        Amount<Q> m = Amount.newInstance(this._unit);
        if (this._isExact && this._exactValue != Long.MAX_VALUE) {
            return m.setExact(-this._exactValue);
        }
        m._isExact = false;
        m._minimum = -this._maximum;
        m._maximum = -this._minimum;
        return m;
    }

    @Override
    public Amount<Q> plus(Amount that) throws ConversionException {
        double sumDouble;
        long sumLong;
        Amount<Q> thatToUnit = that.to(this._unit);
        Amount<Q> m = Amount.newInstance(this._unit);
        if (this._isExact && thatToUnit._isExact && (double)(sumLong = this._exactValue + thatToUnit._exactValue) == (sumDouble = (double)this._exactValue + (double)thatToUnit._exactValue)) {
            return m.setExact(sumLong);
        }
        double min = this._minimum + thatToUnit._minimum;
        double max = this._maximum + thatToUnit._maximum;
        m._isExact = false;
        m._minimum = min < 0.0 ? min * INCREMENT : min * DECREMENT;
        m._maximum = max < 0.0 ? max * DECREMENT : max * INCREMENT;
        return m;
    }

    public Amount<Q> minus(Amount that) throws ConversionException {
        double diffDouble;
        long diffLong;
        Amount<Q> thatToUnit = that.to(this._unit);
        Amount<Q> m = Amount.newInstance(this._unit);
        if (this._isExact && thatToUnit._isExact && (double)(diffLong = this._exactValue - thatToUnit._exactValue) == (diffDouble = (double)this._exactValue - (double)thatToUnit._exactValue)) {
            return m.setExact(diffLong);
        }
        double min = this._minimum - thatToUnit._maximum;
        double max = this._maximum - thatToUnit._minimum;
        m._isExact = false;
        m._minimum = min < 0.0 ? min * INCREMENT : min * DECREMENT;
        m._maximum = max < 0.0 ? max * DECREMENT : max * INCREMENT;
        return m;
    }

    @Override
    public Amount<Q> times(long factor) {
        double productDouble;
        long productLong;
        Amount<Q> m = Amount.newInstance(this._unit);
        if (this._isExact && (double)(productLong = this._exactValue * factor) == (productDouble = (double)this._exactValue * (double)factor)) {
            return m.setExact(productLong);
        }
        m._isExact = false;
        m._minimum = factor > 0L ? this._minimum * (double)factor : this._maximum * (double)factor;
        m._maximum = factor > 0L ? this._maximum * (double)factor : this._minimum * (double)factor;
        return m;
    }

    @Override
    public Amount<Q> times(double factor) {
        Amount<Q> m = Amount.newInstance(this._unit);
        double min = factor > 0.0 ? this._minimum * factor : this._maximum * factor;
        double max = factor > 0.0 ? this._maximum * factor : this._minimum * factor;
        m._isExact = false;
        m._minimum = min < 0.0 ? min * INCREMENT : min * DECREMENT;
        m._maximum = max < 0.0 ? max * DECREMENT : max * INCREMENT;
        return m;
    }

    @Override
    public Amount<? extends Quantity> times(Amount that) {
        double max;
        double min;
        Unit<Q> unit = Amount.productOf(this._unit, that._unit);
        if (that._isExact) {
            Amount<Q> m = this.times(that._exactValue);
            m._unit = unit;
            return m;
        }
        Amount<Q> m = Amount.newInstance(unit);
        if (this._minimum >= 0.0) {
            if (that._minimum >= 0.0) {
                min = this._minimum * that._minimum;
                max = this._maximum * that._maximum;
            } else if (that._maximum < 0.0) {
                min = this._maximum * that._minimum;
                max = this._minimum * that._maximum;
            } else {
                min = this._maximum * that._minimum;
                max = this._maximum * that._maximum;
            }
        } else if (this._maximum < 0.0) {
            if (that._minimum >= 0.0) {
                min = this._minimum * that._maximum;
                max = this._maximum * that._minimum;
            } else if (that._maximum < 0.0) {
                min = this._maximum * that._maximum;
                max = this._minimum * that._minimum;
            } else {
                min = this._minimum * that._maximum;
                max = this._minimum * that._minimum;
            }
        } else if (that._minimum >= 0.0) {
            min = this._minimum * that._maximum;
            max = this._maximum * that._maximum;
        } else if (that._maximum < 0.0) {
            min = this._maximum * that._minimum;
            max = this._minimum * that._minimum;
        } else {
            min = MathLib.min((double)(this._minimum * that._maximum), (double)(this._maximum * that._minimum));
            max = MathLib.max((double)(this._minimum * that._minimum), (double)(this._maximum * that._maximum));
        }
        m._isExact = false;
        m._minimum = min < 0.0 ? min * INCREMENT : min * DECREMENT;
        m._maximum = max < 0.0 ? max * DECREMENT : max * INCREMENT;
        return m;
    }

    @Override
    public Amount<? extends Quantity> inverse() {
        Amount<Q> m = Amount.newInstance(Amount.inverseOf(this._unit));
        if (this._isExact && this._exactValue == 1L) {
            m.setExact(1L);
            return m;
        }
        m._isExact = false;
        if (this._minimum <= 0.0 && this._maximum >= 0.0) {
            m._minimum = Double.NEGATIVE_INFINITY;
            m._maximum = Double.POSITIVE_INFINITY;
            return m;
        }
        double min = 1.0 / this._maximum;
        double max = 1.0 / this._minimum;
        m._minimum = min < 0.0 ? min * INCREMENT : min * DECREMENT;
        m._maximum = max < 0.0 ? max * DECREMENT : max * INCREMENT;
        return m;
    }

    public Amount<Q> divide(long divisor) {
        double quotientDouble;
        long quotientLong;
        Amount<Q> m = Amount.newInstance(this._unit);
        if (this._isExact && (double)(quotientLong = this._exactValue / divisor) == (quotientDouble = (double)this._exactValue / (double)divisor)) {
            return m.setExact(quotientLong);
        }
        double min = divisor > 0L ? this._minimum / (double)divisor : this._maximum / (double)divisor;
        double max = divisor > 0L ? this._maximum / (double)divisor : this._minimum / (double)divisor;
        m._isExact = false;
        m._minimum = min < 0.0 ? min * INCREMENT : min * DECREMENT;
        m._maximum = max < 0.0 ? max * DECREMENT : max * INCREMENT;
        return m;
    }

    public Amount<Q> divide(double divisor) {
        Amount<Q> m = Amount.newInstance(this._unit);
        double min = divisor > 0.0 ? this._minimum / divisor : this._maximum / divisor;
        double max = divisor > 0.0 ? this._maximum / divisor : this._minimum / divisor;
        m._isExact = false;
        m._minimum = min < 0.0 ? min * INCREMENT : min * DECREMENT;
        m._maximum = max < 0.0 ? max * DECREMENT : max * INCREMENT;
        return m;
    }

    public Amount<? extends Quantity> divide(Amount that) {
        if (that._isExact) {
            Amount<Q> m = this.divide(that._exactValue);
            m._unit = Amount.productOf(this._unit, Amount.inverseOf(that._unit));
            return m;
        }
        return this.times((Amount)that.inverse());
    }

    public Amount<Q> abs() {
        return this._isExact ? (this._exactValue < 0L ? this.opposite() : this) : (this._minimum >= -this._maximum ? this : this.opposite());
    }

    public Amount<? extends Quantity> sqrt() {
        double sqrtDouble;
        long sqrtLong;
        Amount<Q> m = Amount.newInstance(this._unit.root(2));
        if (this._isExact && (sqrtLong = (long)(sqrtDouble = MathLib.sqrt((double)this._exactValue))) * sqrtLong == this._exactValue) {
            return m.setExact(sqrtLong);
        }
        double min = MathLib.sqrt((double)this._minimum);
        double max = MathLib.sqrt((double)this._maximum);
        m._isExact = false;
        m._minimum = min < 0.0 ? min * INCREMENT : min * DECREMENT;
        m._maximum = max < 0.0 ? max * DECREMENT : max * INCREMENT;
        return m;
    }

    public Amount<? extends Quantity> root(int n) {
        if (n == 0) {
            throw new ArithmeticException("Root's order of zero");
        }
        if (n < 0) {
            return this.root(-n).inverse();
        }
        if (n == 2) {
            return this.sqrt();
        }
        Amount<Q> m = Amount.newInstance(this._unit.root(n));
        if (this._isExact) {
            long rootLong;
            double rootDouble = MathLib.pow((double)this._exactValue, (double)(1.0 / (double)n));
            long thisLong = rootLong = (long)rootDouble;
            int i = 1;
            while (i < n) {
                thisLong *= rootLong;
                ++i;
            }
            if (thisLong == this._exactValue) {
                return m.setExact(rootLong);
            }
        }
        double min = MathLib.pow((double)this._minimum, (double)(1.0 / (double)n));
        double max = MathLib.pow((double)this._maximum, (double)(1.0 / (double)n));
        m._isExact = false;
        m._minimum = min < 0.0 ? min * INCREMENT : min * DECREMENT;
        m._maximum = max < 0.0 ? max * DECREMENT : max * INCREMENT;
        return m;
    }

    public Amount<? extends Quantity> pow(int exp) {
        if (exp < 0) {
            return this.pow(-exp).inverse();
        }
        if (exp == 0) {
            return ONE;
        }
        Amount<Quantity> pow2 = this;
        Amount<Quantity> result = null;
        while (exp >= 1) {
            if ((exp & 1) == 1) {
                result = result == null ? pow2 : result.times(pow2);
            }
            pow2 = pow2.times(pow2);
            exp >>>= 1;
        }
        return result;
    }

    @Override
    public int compareTo(Measurable<Q> that) {
        double thatValue = that.doubleValue(this._unit);
        return Double.compare(this.getEstimatedValue(), thatValue);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Amount)) {
            return false;
        }
        Amount m = (Amount)that;
        if (!this._unit.equals(m._unit)) {
            return false;
        }
        if (this._isExact != m._isExact) {
            return false;
        }
        if (this._isExact && this._exactValue == m._exactValue) {
            return true;
        }
        if (this._minimum != m._minimum) {
            return false;
        }
        return this._maximum == m._maximum;
    }

    public int hashCode() {
        int h = Float.floatToIntBits((float)this._minimum);
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        return h ^ h >>> 10;
    }

    public boolean approximates(Amount that) {
        Amount<Q> thatToUnit = that.to(this._unit);
        return this._maximum >= thatToUnit._minimum && thatToUnit._maximum >= this._minimum;
    }

    public boolean isLessThan(Amount<Q> that) {
        return this.compareTo(that) < 0;
    }

    public boolean isGreaterThan(Amount<Q> that) {
        return this.compareTo(that) > 0;
    }

    public boolean isLargerThan(Amount<Q> that) {
        return this.abs().isGreaterThan(that.abs());
    }

    public Text toText() {
        return AmountFormat.getInstance().format(this);
    }

    public final String toString() {
        return this.toText().toString();
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        return this._unit == unit || this._unit.equals(unit) ? this.getEstimatedValue() : this.to(unit).getEstimatedValue();
    }

    @Override
    public final long longValue(Unit<Q> unit) {
        if (!this._unit.equals(unit)) {
            return this.to(unit).longValue(unit);
        }
        if (this._isExact) {
            return this._exactValue;
        }
        double doubleValue = this.getEstimatedValue();
        if (doubleValue >= -9.223372036854776E18 && doubleValue <= 9.223372036854776E18) {
            return Math.round(doubleValue);
        }
        throw new ArithmeticException(String.valueOf(doubleValue) + " " + this._unit + " cannot be represented as long");
    }

    private static Unit<?> productOf(Unit<?> left, Unit<?> right) {
        FastMap leftTable = (FastMap)MULT_LOOKUP.get(left);
        if (leftTable == null) {
            return Amount.calculateProductOf(left, right);
        }
        Unit result = (Unit)leftTable.get(right);
        if (result == null) {
            return Amount.calculateProductOf(left, right);
        }
        return result;
    }

    private static synchronized Unit<?> calculateProductOf(final Unit<?> left, final Unit<?> right) {
        MemoryArea memoryArea = MemoryArea.getMemoryArea(MULT_LOOKUP);
        memoryArea.executeInArea(new Runnable(){

            @Override
            public void run() {
                Unit<Quantity> result;
                FastMap leftTable = (FastMap)MULT_LOOKUP.get((Object)left);
                if (leftTable == null) {
                    leftTable = new FastMap().setKeyComparator(FastComparator.DIRECT);
                    MULT_LOOKUP.put((Object)left, (Object)leftTable);
                }
                if ((result = (Unit<Quantity>)leftTable.get((Object)right)) == null) {
                    result = left.times(right);
                    leftTable.put((Object)right, result);
                }
            }
        });
        return (Unit)((FastMap)MULT_LOOKUP.get(left)).get(right);
    }

    private static Unit<?> inverseOf(Unit<?> unit) {
        Unit inverse = (Unit)INV_LOOKUP.get(unit);
        if (inverse == null) {
            return Amount.calculateInverseOf(unit);
        }
        return inverse;
    }

    private static synchronized Unit<?> calculateInverseOf(final Unit<?> unit) {
        MemoryArea memoryArea = MemoryArea.getMemoryArea(INV_LOOKUP);
        memoryArea.executeInArea(new Runnable(){

            @Override
            public void run() {
                Unit<Quantity> inverse = (Unit<Quantity>)INV_LOOKUP.get((Object)unit);
                if (inverse == null) {
                    inverse = unit.inverse();
                    INV_LOOKUP.put((Object)unit, inverse);
                }
            }
        });
        return (Unit)INV_LOOKUP.get(unit);
    }

    private static UnitConverter converterOf(Unit<?> left, Unit<?> right) {
        FastMap leftTable = (FastMap)CVTR_LOOKUP.get(left);
        if (leftTable == null) {
            return Amount.calculateConverterOf(left, right);
        }
        UnitConverter result = (UnitConverter)leftTable.get(right);
        if (result == null) {
            return Amount.calculateConverterOf(left, right);
        }
        return result;
    }

    private static synchronized UnitConverter calculateConverterOf(final Unit<?> left, final Unit<?> right) {
        MemoryArea memoryArea = MemoryArea.getMemoryArea(CVTR_LOOKUP);
        memoryArea.executeInArea(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                UnitConverter result;
                FastMap leftTable = (FastMap)CVTR_LOOKUP.get((Object)left);
                if (leftTable == null) {
                    leftTable = new FastMap().setKeyComparator(FastComparator.DIRECT);
                    FastMap<Unit<?>, FastMap<Unit<?>, UnitConverter>> fastMap = CVTR_LOOKUP;
                    synchronized (fastMap) {
                        CVTR_LOOKUP.put((Object)left, (Object)leftTable);
                    }
                }
                if ((result = (UnitConverter)leftTable.get((Object)right)) == null) {
                    result = left.getConverterTo(right);
                    FastMap fastMap = leftTable;
                    synchronized (fastMap) {
                        leftTable.put((Object)right, (Object)result);
                    }
                }
            }
        });
        return (UnitConverter)((FastMap)CVTR_LOOKUP.get(left)).get(right);
    }

    public Amount<Q> copy() {
        Amount<Q> estimate = Amount.newInstance(this._unit);
        estimate._isExact = this._isExact;
        estimate._exactValue = this._exactValue;
        estimate._minimum = this._minimum;
        estimate._maximum = this._maximum;
        return estimate;
    }

    private static <Q extends Quantity> Amount<Q> newInstance(Unit<?> unit) {
        Amount measure = (Amount)FACTORY.object();
        measure._unit = unit;
        return measure;
    }

    private static <Q extends Quantity> Amount<Q> copyOf(Amount original) {
        Amount measure = (Amount)FACTORY.object();
        measure._exactValue = original._exactValue;
        measure._isExact = original._isExact;
        measure._maximum = original._maximum;
        measure._minimum = original._minimum;
        measure._unit = original._unit;
        return measure;
    }

    private Amount() {
    }

    private Amount<Q> setExact(long exactValue) {
        this._isExact = true;
        this._exactValue = exactValue;
        double doubleValue = exactValue;
        if (doubleValue == (double)exactValue) {
            this._minimum = doubleValue;
            this._maximum = doubleValue;
        } else {
            double valInc = (double)exactValue * INCREMENT;
            double valDec = (double)exactValue * DECREMENT;
            this._minimum = this._exactValue < 0L ? valInc : valDec;
            this._maximum = this._exactValue < 0L ? valDec : valInc;
        }
        return this;
    }
}

