/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.physics.amount;

import java.io.IOException;
import java.text.ParseException;
import java.text.ParsePosition;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import javolution.context.LocalContext;
import javolution.lang.MathLib;
import javolution.text.Text;
import javolution.text.TextBuilder;
import javolution.text.TextFormat;
import javolution.text.TypeFormat;
import org.jscience.economics.money.Currency;
import org.jscience.economics.money.Money;
import org.jscience.physics.amount.Amount;

public abstract class AmountFormat
extends TextFormat<Amount<?>> {
    private static final LocalContext.Reference<AmountFormat> CURRENT = new LocalContext.Reference((Object)new PlusMinusError(2));

    protected AmountFormat() {
    }

    public static AmountFormat getInstance() {
        return (AmountFormat)((Object)CURRENT.get());
    }

    public static void setInstance(AmountFormat format) {
        CURRENT.set((Object)format);
    }

    public static AmountFormat getPlusMinusErrorInstance(int digitsInError) {
        return new PlusMinusError(digitsInError);
    }

    public static AmountFormat getBracketErrorInstance(int digitsInError) {
        return new BracketError(digitsInError);
    }

    public static AmountFormat getExactDigitsInstance() {
        return new ExactDigitsOnly();
    }

    private static Appendable formatMoney(Amount<Money> arg0, Appendable arg1) throws IOException {
        Currency currency = (Currency)arg0.getUnit();
        int fraction = currency.getDefaultFractionDigits();
        if (fraction == 0) {
            long amount = arg0.longValue(currency);
            TypeFormat.format((long)amount, (Appendable)arg1);
        } else if (fraction == 2) {
            long amount = MathLib.round((double)(arg0.doubleValue(arg0.getUnit()) * 100.0));
            TypeFormat.format((long)(amount / 100L), (Appendable)arg1);
            arg1.append('.');
            arg1.append((char)(48L + amount % 100L / 10L));
            arg1.append((char)(48L + amount % 10L));
        } else {
            throw new UnsupportedOperationException();
        }
        arg1.append(' ');
        return UnitFormat.getInstance().format(currency, arg1);
    }

    private static class BracketError
    extends AmountFormat {
        private int _errorDigits;

        private BracketError(int errorDigits) {
            this._errorDigits = errorDigits;
        }

        public Appendable format(Amount arg0, Appendable arg1) throws IOException {
            if (arg0.getUnit() instanceof Currency) {
                return AmountFormat.formatMoney(arg0, arg1);
            }
            if (arg0.isExact()) {
                TypeFormat.format((long)arg0.getExactValue(), (Appendable)arg1);
                arg1.append(' ');
                return UnitFormat.getInstance().format(arg0.getUnit(), arg1);
            }
            double value = arg0.getEstimatedValue();
            double error = arg0.getAbsoluteError();
            int log10Value = (int)MathLib.floor((double)MathLib.log10((double)MathLib.abs((double)value)));
            int log10Error = (int)MathLib.floor((double)MathLib.log10((double)error));
            int digits = log10Value - log10Error - 1;
            digits = MathLib.max((int)1, (int)(digits + this._errorDigits));
            boolean scientific = MathLib.abs((double)value) >= 1000000.0 || MathLib.abs((double)value) < 1.0E-6;
            boolean showZeros = true;
            TextBuilder tb = TextBuilder.newInstance();
            TypeFormat.format((double)value, (int)digits, (boolean)scientific, (boolean)showZeros, (Appendable)tb);
            int endMantissa = 0;
            while (endMantissa < tb.length()) {
                if (tb.charAt(endMantissa) == 'E') break;
                ++endMantissa;
            }
            int bracketError = (int)(error * MathLib.toDoublePow10((long)1L, (int)(-log10Error + this._errorDigits - 1)));
            tb.insert(endMantissa, (CharSequence)Text.valueOf((char)'[').plus((Object)Text.valueOf((int)bracketError)).plus((Object)Character.valueOf(']')));
            arg1.append((CharSequence)tb);
            arg1.append(' ');
            return UnitFormat.getInstance().format(arg0.getUnit(), arg1);
        }

        public Amount<?> parse(CharSequence arg0, TextFormat.Cursor arg1) {
            throw new UnsupportedOperationException("Not supported yet");
        }
    }

    private static class ExactDigitsOnly
    extends AmountFormat {
        private ExactDigitsOnly() {
        }

        public Appendable format(Amount arg0, Appendable arg1) throws IOException {
            if (arg0.getUnit() instanceof Currency) {
                return AmountFormat.formatMoney(arg0, arg1);
            }
            if (arg0.isExact()) {
                TypeFormat.format((long)arg0.getExactValue(), (Appendable)arg1);
                arg1.append(' ');
                return UnitFormat.getInstance().format(arg0.getUnit(), arg1);
            }
            double value = arg0.getEstimatedValue();
            double error = arg0.getAbsoluteError();
            int log10Value = (int)MathLib.floor((double)MathLib.log10((double)MathLib.abs((double)value)));
            int log10Error = (int)MathLib.floor((double)MathLib.log10((double)error));
            int digits = log10Value - log10Error - 1;
            boolean scientific = MathLib.abs((double)value) >= 1000000.0 || MathLib.abs((double)value) < 1.0E-6;
            boolean showZeros = true;
            TypeFormat.format((double)value, (int)digits, (boolean)scientific, (boolean)showZeros, (Appendable)arg1);
            arg1.append(' ');
            return UnitFormat.getInstance().format(arg0.getUnit(), arg1);
        }

        public Amount<?> parse(CharSequence arg0, TextFormat.Cursor arg1) {
            throw new UnsupportedOperationException("This format should not be used for parsing (not enough information on the error");
        }
    }

    private static class PlusMinusError
    extends AmountFormat {
        private int _errorDigits;

        private PlusMinusError(int errorDigits) {
            this._errorDigits = errorDigits;
        }

        public Appendable format(Amount arg0, Appendable arg1) throws IOException {
            if (arg0.getUnit() instanceof Currency) {
                return AmountFormat.formatMoney(arg0, arg1);
            }
            if (arg0.isExact()) {
                TypeFormat.format((long)arg0.getExactValue(), (Appendable)arg1);
                arg1.append(' ');
                return UnitFormat.getInstance().format(arg0.getUnit(), arg1);
            }
            double value = arg0.getEstimatedValue();
            double error = arg0.getAbsoluteError();
            int log10Value = (int)MathLib.floor((double)MathLib.log10((double)MathLib.abs((double)value)));
            int log10Error = (int)MathLib.floor((double)MathLib.log10((double)error));
            int digits = log10Value - log10Error - 1;
            digits = MathLib.max((int)1, (int)(digits + this._errorDigits));
            boolean scientific = MathLib.abs((double)value) >= 1000000.0 || MathLib.abs((double)value) < 1.0E-6;
            boolean showZeros = false;
            arg1.append('(');
            TypeFormat.format((double)value, (int)digits, (boolean)scientific, (boolean)showZeros, (Appendable)arg1);
            arg1.append(" \u00b1 ");
            scientific = MathLib.abs((double)error) >= 1000000.0 || MathLib.abs((double)error) < 1.0E-6;
            showZeros = true;
            TypeFormat.format((double)error, (int)this._errorDigits, (boolean)scientific, (boolean)showZeros, (Appendable)arg1);
            arg1.append(") ");
            return UnitFormat.getInstance().format(arg0.getUnit(), arg1);
        }

        public Amount<?> parse(CharSequence arg0, TextFormat.Cursor arg1) {
            int start = arg1.getIndex();
            try {
                arg1.skip('(', arg0);
                long value = TypeFormat.parseLong((CharSequence)arg0, (int)10, (TextFormat.Cursor)arg1);
                if (arg0.charAt(arg1.getIndex()) == ' ') {
                    arg1.skip(' ', arg0);
                    Unit<? extends Quantity> unit = UnitFormat.getInstance().parseProductUnit(arg0, (ParsePosition)arg1);
                    return Amount.valueOf(value, unit);
                }
                arg1.setIndex(start);
                double amount = TypeFormat.parseDouble((CharSequence)arg0, (TextFormat.Cursor)arg1);
                arg1.skip(' ', arg0);
                double error = 0.0;
                if (arg0.charAt(arg1.getIndex()) == '\u00b1') {
                    arg1.skip('\u00b1', arg0);
                    arg1.skip(' ', arg0);
                    error = TypeFormat.parseDouble((CharSequence)arg0, (TextFormat.Cursor)arg1);
                }
                arg1.skip(')', arg0);
                arg1.skip(' ', arg0);
                Unit<? extends Quantity> unit = UnitFormat.getInstance().parseProductUnit(arg0, (ParsePosition)arg1);
                return Amount.valueOf(amount, error, unit);
            }
            catch (ParseException e) {
                arg1.setIndex(start);
                arg1.setErrorIndex(e.getErrorOffset());
                return null;
            }
        }
    }
}

