/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.delegate;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicSettingDelegate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.EvaluationException;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.pivot.internal.delegate.SettingBehavior;
import org.eclipse.ocl.pivot.internal.helper.BasicQueryImpl;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.SemanticException;
import org.eclipse.ocl.pivot.utilities.ThreadLocalExecutor;

public class OCLSettingDelegate
extends BasicSettingDelegate.Stateless {
    protected final @NonNull OCLDelegateDomain delegateDomain;
    private Property property;
    private ExpressionInOCL query;

    public OCLSettingDelegate(@NonNull OCLDelegateDomain delegateDomain, @NonNull EStructuralFeature structuralFeature) {
        super(structuralFeature);
        this.delegateDomain = delegateDomain;
    }

    protected @Nullable Property basicGetProperty() {
        return this.property;
    }

    @Deprecated
    protected @Nullable Object evaluateEcore(@NonNull OCL ocl, @NonNull ExpressionInOCL query, @Nullable Object unboxedObject) {
        EnvironmentFactory environmentFactory = ocl.getEnvironmentFactory();
        ModelManager modelManager = ocl.getModelManager();
        if (modelManager == null) {
            modelManager = environmentFactory.createModelManager(unboxedObject);
        }
        BasicQueryImpl query2 = new BasicQueryImpl(environmentFactory, query);
        return query2.evaluateEcore(this.eStructuralFeature.getEType().getInstanceClass(), unboxedObject);
    }

    protected Object get(InternalEObject ecoreObject, boolean resolve, boolean coreType) {
        Object object;
        assert (ecoreObject != null);
        EnvironmentFactoryInternal environmentFactory = PivotUtilInternal.getEnvironmentFactory(ecoreObject);
        Executor executor = PivotUtil.getExecutor((EObject)ecoreObject);
        ModelManager modelManager = executor.getModelManager();
        ExpressionInOCL query = this.getQuery();
        Executor savedExecutor = ThreadLocalExecutor.basicGetExecutor();
        try {
            if (savedExecutor != null) {
                ThreadLocalExecutor.setExecutor(null);
            }
            VariableDeclaration contextVariable = PivotUtil.getOwnedContext(query);
            OCLExpression expression = PivotUtil.getOwnedBody(query);
            Class instanceClass = this.eStructuralFeature.getEType().getInstanceClass();
            IdResolver idResolver = environmentFactory.getIdResolver();
            Object boxedValue = idResolver.boxedValueOf(ecoreObject);
            EvaluationEnvironment evaluationEnvironment = environmentFactory.createEvaluationEnvironment(query, modelManager);
            evaluationEnvironment.add(contextVariable, boxedValue);
            EvaluationVisitor ev = environmentFactory.createEvaluationVisitor(evaluationEnvironment);
            Object boxedResult = expression.accept(ev);
            object = idResolver.ecoreValueOf(instanceClass, boxedResult);
        }
        catch (Throwable throwable) {
            try {
                ThreadLocalExecutor.setExecutor(savedExecutor);
                throw throwable;
            }
            catch (EvaluationException e) {
                throw new OCLDelegateException(new EvaluationException(e, PivotMessagesInternal.EvaluationResultIsInvalid_ERROR_, this.property));
            }
        }
        ThreadLocalExecutor.setExecutor(savedExecutor);
        return object;
    }

    public @NonNull Property getProperty() {
        Property property2 = this.property;
        if (property2 == null && (property2 = (this.property = this.delegateDomain.getPivot(Property.class, (EObject)ClassUtil.nonNullEMF(this.eStructuralFeature)))) == null) {
            throw new OCLDelegateException(new SemanticException("No pivot property for " + this.eStructuralFeature));
        }
        return property2;
    }

    protected @NonNull ExpressionInOCL getQuery() {
        ExpressionInOCL query2 = this.query;
        if (query2 == null) {
            EnvironmentFactoryInternal environmentFactory = PivotUtilInternal.getEnvironmentFactory(null);
            Property property2 = this.getProperty();
            query2 = this.query = SettingBehavior.INSTANCE.getQueryOrThrow(environmentFactory.getMetamodelManager(), property2);
            SettingBehavior.INSTANCE.validate(property2);
        }
        return query2;
    }

    protected boolean isSet(InternalEObject owner) {
        return false;
    }

    public String toString() {
        if (this.property != null) {
            return "<" + this.delegateDomain.getURI() + ":setting> " + this.property;
        }
        String name = String.valueOf(this.eStructuralFeature.getEContainingClass().getEPackage().getName()) + "::" + this.eStructuralFeature.getEContainingClass().getName() + "." + this.eStructuralFeature.getName();
        return "<" + this.delegateDomain.getURI() + ":setting> " + name;
    }

    public static class Changeable
    extends OCLSettingDelegate {
        private Map<InternalEObject, Object> valueMap = null;

        public Changeable(@NonNull OCLDelegateDomain delegateDomain, @NonNull EStructuralFeature structuralFeature) {
            super(delegateDomain, structuralFeature);
        }

        @Override
        protected Object get(InternalEObject owner, boolean resolve, boolean coreType) {
            if (this.valueMap != null && this.valueMap.containsKey(owner)) {
                return this.valueMap.get(owner);
            }
            return super.get(owner, resolve, coreType);
        }

        @Override
        protected boolean isSet(InternalEObject owner) {
            return this.valueMap != null && this.valueMap.containsKey(owner);
        }

        protected void set(InternalEObject owner, Object newValue) {
            if (owner != null) {
                if (this.valueMap == null) {
                    this.valueMap = new HashMap<InternalEObject, Object>();
                }
                this.valueMap.put(owner, newValue);
            }
        }

        protected void unset(InternalEObject owner) {
            if (this.valueMap != null) {
                this.valueMap.remove(owner);
            }
        }
    }
}

