/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.launchconfig;

import de.uka.ipd.sdq.workflow.Workflow;
import de.uka.ipd.sdq.workflow.WorkflowExceptionHandler;
import de.uka.ipd.sdq.workflow.configuration.InvalidWorkflowJobConfigurationException;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowBasedRunConfiguration;
import de.uka.ipd.sdq.workflow.logging.console.LoggerAppenderStruct;
import de.uka.ipd.sdq.workflow.logging.console.StreamsProxyAppender;
import de.uka.ipd.sdq.workflow.ui.UIBasedWorkflowExceptionHandler;
import de.uka.ipd.sdq.workflow.ui.WorkflowProcess;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;

public abstract class AbstractWorkflowBasedLaunchConfigurationDelegate<WorkflowConfigurationType extends AbstractWorkflowBasedRunConfiguration, WorkflowType extends Workflow>
implements ILaunchConfigurationDelegate {
    protected static final String SHORT_LOG_PATTERN = "[%-10t] %-5p: %m%n";
    protected static final String DETAILED_LOG_PATTERN = "%-8r [%-10t] %-5p: %m [%c]%n";
    private static final Logger LOGGER = Logger.getLogger(AbstractWorkflowBasedLaunchConfigurationDelegate.class);
    public static final String VERBOSE_LOGGING = "verboseLogging";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ClassLoader oldClassLoader = this.configureNewClassloader();
        List<LoggerAppenderStruct> loggerList = this.setupProcessAndLogger(configuration, launch);
        try {
            this.createAndRunWorkflow(configuration, mode, launch, monitor);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        this.tearDownProcessAndLogger(launch, loggerList);
    }

    private void tearDownProcessAndLogger(ILaunch launch, List<LoggerAppenderStruct> loggerList) throws DebugException {
        for (LoggerAppenderStruct l : loggerList) {
            l.getLogger().removeAppender((Appender)l.getAppender());
        }
        launch.getProcesses()[0].terminate();
    }

    private List<LoggerAppenderStruct> setupProcessAndLogger(ILaunchConfiguration configuration, ILaunch launch) throws CoreException {
        WorkflowProcess workflowProcess = this.getProcess(launch);
        List<LoggerAppenderStruct> loggerList = this.configureLogging(configuration);
        for (LoggerAppenderStruct currentLogger : loggerList) {
            workflowProcess.addAppender(currentLogger.getAppender());
        }
        launch.addProcess((IProcess)workflowProcess);
        return loggerList;
    }

    protected List<LoggerAppenderStruct> configureLogging(ILaunchConfiguration configuration) throws CoreException {
        Level logLevel = this.getLogLevel(configuration);
        return this.setupLogging(logLevel);
    }

    protected Level getLogLevel(ILaunchConfiguration configuration) {
        try {
            switch (configuration.getAttribute("de.uka.ipd.sdq.workflowengine.debuglevel", 0)) {
                case 0: {
                    return Level.TRACE;
                }
                case 1: {
                    return Level.DEBUG;
                }
                case 2: {
                    return Level.INFO;
                }
                case 3: {
                    return Level.WARN;
                }
                case 4: {
                    return Level.ERROR;
                }
                case 5: {
                    return Level.ALL;
                }
            }
            return Level.INFO;
        }
        catch (CoreException e) {
            return Level.INFO;
        }
    }

    private void createAndRunWorkflow(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        WorkflowConfigurationType workflowConfiguration;
        if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
            LOGGER.info((Object)"Create workflow configuration");
        }
        if ((workflowConfiguration = this.deriveConfiguration(configuration, mode)) == null) {
            if (LOGGER.isEnabledFor((Priority)Level.ERROR)) {
                LOGGER.error((Object)("No configuration instance has been created by the workflow [" + this.getClass().toString() + "]"), (Throwable)new NullPointerException());
            }
            return;
        }
        if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
            LOGGER.info((Object)"Validating workflow configuration");
        }
        try {
            workflowConfiguration.validateAndFreeze();
        }
        catch (InvalidWorkflowJobConfigurationException e) {
            if (LOGGER.isEnabledFor((Priority)Level.ERROR)) {
                LOGGER.error((Object)"Configuration invalid");
                LOGGER.error((Object)e.getMessage());
            }
            return;
        }
        if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
            LOGGER.info((Object)"Creating workflow engine");
        }
        WorkflowType workflow = this.createWorkflow(workflowConfiguration, monitor, launch);
        if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
            LOGGER.info((Object)"Executing workflow");
        }
        workflow.run();
    }

    protected WorkflowExceptionHandler createExceptionHandler(boolean interactive) {
        return new UIBasedWorkflowExceptionHandler(!interactive);
    }

    protected WorkflowType createWorkflow(WorkflowConfigurationType workflowConfiguration, IProgressMonitor monitor, ILaunch launch) throws CoreException {
        return (WorkflowType)new Workflow(this.createWorkflowJob(workflowConfiguration, launch), monitor, this.createExceptionHandler(((AbstractWorkflowBasedRunConfiguration)workflowConfiguration).isInteractive()));
    }

    private ClassLoader configureNewClassloader() {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader cl = new URLClassLoader(new URL[0], oldClassLoader);
        Thread.currentThread().setContextClassLoader(cl);
        return oldClassLoader;
    }

    protected ArrayList<LoggerAppenderStruct> setupLogging(Level logLevel) throws CoreException {
        ArrayList<LoggerAppenderStruct> loggerList = new ArrayList<LoggerAppenderStruct>();
        loggerList.add(this.setupLogger("de.uka.ipd.sdq.workflow", logLevel, Level.DEBUG == logLevel ? DETAILED_LOG_PATTERN : SHORT_LOG_PATTERN));
        return loggerList;
    }

    protected LoggerAppenderStruct setupLogger(String loggerName, Level logLevel, String layout) {
        Logger localLogger = Logger.getLogger((String)loggerName);
        StreamsProxyAppender appender = new StreamsProxyAppender();
        localLogger.setLevel(logLevel);
        appender.setLayout((Layout)new PatternLayout(layout));
        localLogger.setAdditivity(false);
        localLogger.addAppender((Appender)appender);
        return new LoggerAppenderStruct(localLogger, appender);
    }

    protected WorkflowProcess getProcess(ILaunch launch) {
        return new WorkflowProcess(launch);
    }

    protected abstract IJob createWorkflowJob(WorkflowConfigurationType var1, ILaunch var2) throws CoreException;

    protected abstract WorkflowConfigurationType deriveConfiguration(ILaunchConfiguration var1, String var2) throws CoreException;
}

