/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.launchconfig.tabs;

import de.uka.ipd.sdq.workflow.launchconfig.tabs.FileSelectionAdapter;
import java.io.File;
import java.util.StringTokenizer;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LocalFileSystemButtonSelectionAdapter
extends FileSelectionAdapter {
    public LocalFileSystemButtonSelectionAdapter(Text field, String[] fileExtension, String dialogTitle, Shell shell) {
        super(field, fileExtension, dialogTitle, shell);
    }

    public LocalFileSystemButtonSelectionAdapter(Text field, String[] fileExtension, String dialogTitle, Shell shell, boolean useFolder) {
        super(field, fileExtension, dialogTitle, shell, useFolder);
    }

    public LocalFileSystemButtonSelectionAdapter(Text field, String[] fileExtension, String dialogTitle, Shell shell, boolean useFolder, boolean useMultipleSelection) {
        super(field, fileExtension, dialogTitle, shell, useFolder, useMultipleSelection);
    }

    @Override
    public String openFileDialog(Text textField, String[] fileExtension) {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setFilterExtensions(fileExtension);
        dialog.setText(this.getDialogTitle());
        String filename = null;
        dialog.setFileName(textField.getText());
        if (dialog.open() != null) {
            String root = String.valueOf(dialog.getFilterPath()) + File.separatorChar;
            filename = String.valueOf(root) + dialog.getFileName();
        }
        return filename;
    }

    @Override
    public String openFileDialog(Text textField, String[] fileExtension, boolean multipleSelection) {
        FileDialog dialog = new FileDialog(this.getShell(), 2);
        dialog.setFilterExtensions(fileExtension);
        dialog.setText(this.getDialogTitle());
        String filename = "";
        String fileName = textField.getText();
        StringTokenizer tokenizer = new StringTokenizer(fileName, ";");
        if (tokenizer.countTokens() > 0) {
            dialog.setFileName(tokenizer.nextToken());
        } else {
            dialog.setFileName(fileName);
        }
        if (dialog.open() != null) {
            String root = String.valueOf(dialog.getFilterPath()) + File.separatorChar;
            if (multipleSelection) {
                int i = 0;
                while (i < dialog.getFileNames().length) {
                    if (i > 0) {
                        filename = String.valueOf(filename) + ";";
                    }
                    filename = String.valueOf(filename) + root + dialog.getFileNames()[i];
                    ++i;
                }
            } else {
                filename = String.valueOf(root) + dialog.getFileName();
            }
        }
        return filename;
    }

    @Override
    public String openFolderDialog(Text textField) {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4096);
        dialog.setText(this.getDialogTitle());
        String filename = dialog.open();
        if (filename != null) {
            filename = String.valueOf(filename) + File.separatorChar;
        }
        return filename;
    }
}

