/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.launchconfig.tabs;

import de.uka.ipd.sdq.workflow.launchconfig.tabs.DefaultFileSelectionAdapter;
import de.uka.ipd.sdq.workflow.launchconfig.tabs.LocalFileSystemButtonSelectionAdapter;
import de.uka.ipd.sdq.workflow.launchconfig.tabs.WorkspaceButtonSelectionListener;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TabHelper {
    public static CTabFolder createTabFolder(ILaunchConfigurationTabGroup tabGroup, ILaunchConfigurationDialog dialog, String mode, Composite parent, int style) {
        if (tabGroup.getTabs() == null) {
            tabGroup.createTabs(dialog, mode);
        }
        ILaunchConfigurationTab[] tabs = tabGroup.getTabs();
        CTabFolder tabFolder = new CTabFolder(parent, style);
        int i = 0;
        while (i < tabGroup.getTabs().length) {
            ILaunchConfigurationTab tab = tabs[i];
            tab.setLaunchConfigurationDialog(dialog);
            tab.createControl((Composite)tabFolder);
            CTabItem tabItem = new CTabItem(tabFolder, 0);
            tabItem.setText(tab.getName());
            tabItem.setControl(tab.getControl());
            ++i;
        }
        tabFolder.setSelection(0);
        return tabFolder;
    }

    public static void createFileInputSection(Composite parentContainer, ModifyListener modifyListener, String groupLabel, String[] fileExtensionRestrictions, Text textFileNameToLoad, Shell dialogShell, String defaultFileURI) {
        TabHelper.createFileInputSection(parentContainer, modifyListener, groupLabel, fileExtensionRestrictions, textFileNameToLoad, "Select " + groupLabel, dialogShell, defaultFileURI);
    }

    public static void createFileInputSection(Composite parentContainer, ModifyListener modifyListener, String groupLabel, String[] fileExtensionRestrictions, Text textFileNameToLoad, Shell dialogShell, String defaultFileURI, boolean useMultipleSelection) {
        TabHelper.createFileInputSection(parentContainer, modifyListener, groupLabel, fileExtensionRestrictions, textFileNameToLoad, "Select " + groupLabel, dialogShell, defaultFileURI, useMultipleSelection);
    }

    public static void createFileInputSection(Composite parentContainer, ModifyListener modifyListener, String groupLabel, String[] fileExtensionRestrictions, Text textFileNameToLoad, String dialogTitle, Shell dialogShell, String defaultFileURI) {
        TabHelper.createFileInputSection(parentContainer, modifyListener, groupLabel, fileExtensionRestrictions, textFileNameToLoad, dialogTitle, dialogShell, true, true, defaultFileURI);
    }

    public static void createFileInputSection(Composite parentContainer, ModifyListener modifyListener, String groupLabel, String[] fileExtensionRestrictions, Text textFileNameToLoad, String dialogTitle, Shell dialogShell, String defaultFileURI, boolean allowMultipleSelection) {
        TabHelper.createFileInputSection(parentContainer, modifyListener, groupLabel, fileExtensionRestrictions, textFileNameToLoad, dialogTitle, dialogShell, true, true, defaultFileURI, allowMultipleSelection);
    }

    public static void createFileInputSection(Composite parentContainer, ModifyListener modifyListener, String groupLabel, String[] fileExtensionRestrictions, Text textFileNameToLoad, String dialogTitle, Shell dialogShell, boolean showWorkspaceSelectionButton, boolean showFileSystemSelectionButton, String defaultFileURI) {
        TabHelper.createFileInputSection(parentContainer, modifyListener, groupLabel, fileExtensionRestrictions, textFileNameToLoad, dialogTitle, dialogShell, showWorkspaceSelectionButton, showFileSystemSelectionButton, defaultFileURI, false);
    }

    public static void createFileInputSection(Composite parentContainer, ModifyListener modifyListener, String groupLabel, String[] fileExtensionRestrictions, Text textFileNameToLoad, String dialogTitle, Shell dialogShell, boolean showWorkspaceSelectionButton, boolean showFileSystemSelectionButton, String defaultFileURI, boolean allowMultipleSelection) {
        TabHelper.createInputSection(parentContainer, modifyListener, groupLabel, fileExtensionRestrictions, textFileNameToLoad, dialogTitle, dialogShell, showWorkspaceSelectionButton, showFileSystemSelectionButton, defaultFileURI, allowMultipleSelection, false);
    }

    private static void createInputSection(Composite parentContainer, ModifyListener modifyListener, String groupLabel, String[] fileExtensionRestrictions, Text textFileNameToLoad, String dialogTitle, Shell dialogShell, boolean showWorkspaceSelectionButton, boolean showFileSystemSelectionButton, String defaultFileURI, boolean allowMultipleSelection, boolean useFolder) {
        Group fileInputGroup = new Group(parentContainer, 0);
        GridLayout glFileInputGroup = new GridLayout();
        int numColumns = 1;
        if (defaultFileURI != null) {
            ++numColumns;
        }
        if (showWorkspaceSelectionButton) {
            ++numColumns;
        }
        if (showFileSystemSelectionButton) {
            ++numColumns;
        }
        glFileInputGroup.numColumns = numColumns;
        fileInputGroup.setLayout((Layout)glFileInputGroup);
        fileInputGroup.setText(groupLabel);
        fileInputGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        textFileNameToLoad.setParent((Composite)fileInputGroup);
        GridData gridDataTextFileName = new GridData(4, 0x1000000, true, false);
        gridDataTextFileName.widthHint = 200;
        textFileNameToLoad.setLayoutData((Object)gridDataTextFileName);
        TabHelper.createInputParts((Composite)fileInputGroup, modifyListener, fileExtensionRestrictions, textFileNameToLoad, dialogTitle, showWorkspaceSelectionButton, showFileSystemSelectionButton, defaultFileURI, allowMultipleSelection, useFolder);
    }

    public static void createFileInputParts(Composite parent, ModifyListener modifyListener, String[] fileExtensionRestrictions, Text textFileNameToLoad, String dialogTitle, String defaultFileURI) {
        TabHelper.createInputParts(parent, modifyListener, fileExtensionRestrictions, textFileNameToLoad, dialogTitle, true, true, defaultFileURI, false, false);
    }

    public static void createInputParts(Composite parent, ModifyListener modifyListener, String[] fileExtensionRestrictions, Text textFileNameToLoad, String dialogTitle, boolean showWorkspaceSelectionButton, boolean showFileSystemSelectionButton, String defaultFileURI, boolean allowMultipleSelection, boolean useFolder) {
        textFileNameToLoad.addModifyListener(modifyListener);
        Shell shell = parent.getShell();
        if (showWorkspaceSelectionButton) {
            Button workspaceButton = new Button(parent, 0);
            workspaceButton.setText("Workspace...");
            workspaceButton.addSelectionListener((SelectionListener)new WorkspaceButtonSelectionListener(textFileNameToLoad, fileExtensionRestrictions, dialogTitle, shell, useFolder, allowMultipleSelection));
        }
        if (showFileSystemSelectionButton) {
            Button localFileSystemButton = new Button(parent, 0);
            localFileSystemButton.setText("File System...");
            localFileSystemButton.addSelectionListener((SelectionListener)new LocalFileSystemButtonSelectionAdapter(textFileNameToLoad, fileExtensionRestrictions, dialogTitle, shell, useFolder, allowMultipleSelection));
        }
        if (defaultFileURI != null) {
            Button defaultFileURIButton = new Button(parent, 0);
            defaultFileURIButton.setText("Default");
            defaultFileURIButton.addSelectionListener((SelectionListener)new DefaultFileSelectionAdapter(textFileNameToLoad, fileExtensionRestrictions, defaultFileURI));
        }
    }

    public static void createFolderInputSection(Composite parentContainer, ModifyListener modifyListener, String groupLabel, Text textFileNameToLoad, String dialogTitle, Shell dialogShell, String defaultFileURI) {
        TabHelper.createInputSection(parentContainer, modifyListener, groupLabel, new String[0], textFileNameToLoad, dialogTitle, dialogShell, true, true, defaultFileURI, false, true);
    }

    public static boolean validateFilenameExtension(String filePath, String[] extensions) {
        if (filePath == null) {
            return false;
        }
        if (filePath.equals("")) {
            return false;
        }
        boolean extensionValid = false;
        int position = 0;
        while (position < extensions.length) {
            String extension = extensions[position].replace("*", "");
            if (filePath.endsWith(extension)) {
                extensionValid = true;
            }
            ++position;
        }
        return extensionValid;
    }
}

