/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.pcm.repository;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ParameterModifier implements Enumerator
{
    NONE(0, "none", "none"),
    IN(1, "in", "in"),
    OUT(2, "out", "out"),
    INOUT(3, "inout", "inout");

    public static final String copyright = "Copyright 2005-2017 by palladiosimulator.org";
    public static final int NONE_VALUE = 0;
    public static final int IN_VALUE = 1;
    public static final int OUT_VALUE = 2;
    public static final int INOUT_VALUE = 3;
    private static final ParameterModifier[] VALUES_ARRAY;
    public static final List<ParameterModifier> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ParameterModifier[]{NONE, IN, OUT, INOUT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ParameterModifier get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParameterModifier result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParameterModifier getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParameterModifier result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParameterModifier get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return IN;
            }
            case 2: {
                return OUT;
            }
            case 3: {
                return INOUT;
            }
        }
        return null;
    }

    private ParameterModifier(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

