/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.pcm.repository.util;

import de.uka.ipd.sdq.identifier.Identifier;
import de.uka.ipd.sdq.identifier.util.IdentifierValidator;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.palladiosimulator.pcm.core.composition.util.CompositionValidator;
import org.palladiosimulator.pcm.core.entity.util.EntityValidator;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.CollectionDataType;
import org.palladiosimulator.pcm.repository.CompleteComponentType;
import org.palladiosimulator.pcm.repository.ComponentType;
import org.palladiosimulator.pcm.repository.CompositeComponent;
import org.palladiosimulator.pcm.repository.CompositeDataType;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.EventGroup;
import org.palladiosimulator.pcm.repository.EventType;
import org.palladiosimulator.pcm.repository.ExceptionType;
import org.palladiosimulator.pcm.repository.ImplementationComponentType;
import org.palladiosimulator.pcm.repository.InfrastructureInterface;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.InnerDeclaration;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.ParameterModifier;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.repository.PrimitiveDataType;
import org.palladiosimulator.pcm.repository.PrimitiveTypeEnum;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.ProvidesComponentType;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RepositoryPackage;
import org.palladiosimulator.pcm.repository.RequiredCharacterisation;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Role;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.repository.SinkRole;
import org.palladiosimulator.pcm.repository.SourceRole;

public class RepositoryValidator
extends EObjectValidator {
    public static final String copyright = "Copyright 2005-2017 by palladiosimulator.org";
    public static final RepositoryValidator INSTANCE = new RepositoryValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.palladiosimulator.pcm.repository";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected IdentifierValidator identifierValidator = IdentifierValidator.INSTANCE;
    protected EntityValidator entityValidator = EntityValidator.INSTANCE;
    protected CompositionValidator compositionValidator = CompositionValidator.INSTANCE;
    protected static final String BASIC_COMPONENT__NO_SEFF_TYPE_USED_TWICE__EEXPRESSION = "self.serviceEffectSpecifications__BasicComponent->forAll(p1, p2 |\r\n  p1 <> p2 implies (p1.describedService__SEFF = p2.describedService__SEFF implies p1.seffTypeID <> p2.seffTypeID))";
    protected static final String BASIC_COMPONENT__EVERY_OPERATION_INTERFACE_METHODS_NEEDS_SEFF__EEXPRESSION = "self.providedRoles_InterfaceProvidingEntity->selectByType(OperationProvidedRole).providedInterface__OperationProvidedRole.signatures__OperationInterface->forAll(s | self.serviceEffectSpecifications__BasicComponent->select(service | service.describedService__SEFF=s)->size()>0)";
    protected static final String BASIC_COMPONENT__EVERY_INFRASTRUCTURE_INTERFACE_METHODS_NEEDS_SEFF__EEXPRESSION = "self.providedRoles_InterfaceProvidingEntity->selectByType(InfrastructureProvidedRole).providedInterface__InfrastructureProvidedRole.infrastructureSignatures__InfrastructureInterface->forAll(s | self.serviceEffectSpecifications__BasicComponent->select(service | service.describedService__SEFF=s)->size()>0)";
    protected static final String IMPLEMENTATION_COMPONENT_TYPE__REQUIRED_INTERFACES_HAVE_TO_CONFORM_TO_COMPLETE_TYPE__EEXPRESSION = "-- ImplementationTypes required Interfaces have to be a subset\r\n-- of CompleteComponentType required Interfaces #\r\n--\r\n-- ACCx are used to accumulate Sets/Bags; usually only the very inner ACCx is used at all.\r\n--\r\n-- Recursive Query for parent Interface IDs\r\n-- see 'lpar2005.pdf' (Second-order principles in specification languages for Object-Oriented Programs; Beckert, Tretelman) pp. 11 #\r\n--let parentInterfaces : Bag(Interface) =\r\n--\tself.parentCompleteComponentTypes->iterate(pt : CompleteComponentType; acc1 : Bag(Interface) = Bag{} |\r\n--\t\tacc1->union(pt.requiredRoles->iterate(r : RequiredRole; acc2 : Bag(Interface) = Bag{} |\r\n--\t\t\tacc2->union(r.requiredInterface.parentInterface->asBag()) -- asBag required to allow Set operations #\r\n--\t\t))\r\n--\t) in\r\n--let anchestorInterfaces : Bag(Interface) =\r\n--\tself.parentCompleteComponentTypes->iterate(pt : CompleteComponentType; acc3 : Bag(Interface) = Bag{} |\r\n--\t\tacc3->union(pt.requiredRoles->iterate(r : RequiredRole; acc4 : Bag(Interface) = Bag{} |\r\n--\t\t\tacc4->union(r.requiredInterface.parentInterface->asBag()) -- asBag required to allow Set operations #\r\n--\t\t))\r\n--\t)->union( -- union with anchestors found in former recursion #\r\n--\t\tself.parentCompleteComponentTypes->iterate(pt : CompleteComponentType; acc5 : Bag(Interface) = Bag{} |\r\n--\t\t\tacc5->union(pt.requiredRoles->iterate(r : RequiredRole; acc6 : Bag(Interface) = Bag{} |\r\n--\t\t\t\tacc6->union(r.requiredInterface.parentInterface.anchestorInterfaces) --already Set/Bag\r\n--\t\t\t))\r\n--\t\t)\r\n--\t) in\r\n-- Directly required interfaces need to be a subset of required anchestorInterfaces of Supertype #\r\n--anchestorInterfaces.identifier.id->includesAll(\r\n--\tself.requiredRoles->iterate(p : RequiredRole; acc7 : Bag(String) = Bag{} |\r\n--\t\tacc7->union(p.requiredInterface.identifier.id->asBag())\r\n--\t)\t\r\n--)\r\ntrue";
    protected static final String IMPLEMENTATION_COMPONENT_TYPE__PROVIDED_INTERFACES_HAVE_TO_CONFORM_TO_COMPLETE_TYPE__EEXPRESSION = "-- ### EXACT COPY FROM ABOVE ###\r\n-- ImplementationComponentTypes provided Interfaces have to be a superset\r\n-- of CompleteComponentType provided Interfaces #\r\n--\r\n-- ACCx are used to accumulate Sets/Bags; usually only the very inner ACCx is used at all.\r\n--\r\n-- Recursive Query for parent Interface IDs\r\n-- see 'lpar2005.pdf' (Second-order principles in specification languages for Object-Oriented Programs; Beckert, Tretelman) pp. 11 #\r\n--let parentInterfaces : Bag(Interface) =\r\n--\tself.providedRoles->iterate(r : ProvidedRole; acc2 : Bag(Interface) = Bag{} |\r\n--\t\tacc2->union(r.providedInterface.parentInterface->asBag()) -- asBag required to allow Set operations #\r\n--\t) in\r\n--let anchestorInterfaces : Bag(Interface) =\r\n--\tself.providedRoles->iterate(r : ProvidedRole; acc4 : Bag(Interface) = Bag{} |\r\n--\t\tacc4->union(r.providedInterface.parentInterface->asBag()) -- asBag required to allow Set operations #\r\n--\t)->union( -- union with anchestors found in former recursion #\r\n--\t\tself.providedRoles->iterate(r : ProvidedRole; acc6 : Bag(Interface) = Bag{} |\r\n--\t\t\tacc6->union(r.providedInterface.parentInterface.anchestorInterfaces) --already Set/Bag\r\n--\t\t)\r\n--\t) in\r\n\t-- Directly provided anchestorInterfaces need to be a superset of provided interfaces of Supertype #\r\n--\tanchestorInterfaces.identifier.id->includesAll(\r\n--\t\tself.parentProvidesComponentTypes->iterate(pt : ProvidesComponentType; acc1 : Bag(String) = Bag{} |\r\n--\t\t\tpt.providedRoles->iterate(r : ProvidedRole; acc2 : Bag(String) = Bag{} |\r\n--\t\t\t\tacc2->union(r.providedInterface.identifier.id->asBag()) -- asBag required to allow Set operations #\r\n--\t\t\t)\r\n--\t\t)\r\n--\t)\r\ntrue";
    protected static final String IMPLEMENTATION_COMPONENT_TYPE__PROVIDED_INTERFACE_HAVE_TO_CONFORM_TO_COMPONENT_TYPE__EEXPRESSION = "-- assures that InfrastructureComponents only have InfrastructureInterfaces and that BusinessComponents only have OperationInterfaces or EventGroups\r\nif self.componentType = ComponentType::INFRASTRUCTURE_COMPONENT then\r\n\tself.providedRoles_InterfaceProvidingEntity->select(role | role.oclIsTypeOf(OperationInterface) or role.oclIsTypeOf(EventGroup))->size() = 0\r\nelse if self.componentType = ComponentType::BUSINESS_COMPONENT then\r\n\tself.providedRoles_InterfaceProvidingEntity->select(role | role.oclIsTypeOf(InfrastructureInterface))->size() = 0\r\nelse\r\n\t1 = 0\r\nendif\r\nendif";
    protected static final String IMPLEMENTATION_COMPONENT_TYPE__PROVIDE_SAME_OR_MORE_INTERFACES_AS_COMPLETE_COMPONENT_TYPE__EEXPRESSION = "-- ImplementationComponent has to provide the same or more interfaces like the CompleteComponentType (if set) #\r\n\tif\r\n\t\t -- apply constraint only for non-empty CompleteComponentTypes #\r\n\t\tself.parentCompleteComponentTypes->notEmpty()\r\n\tthen\r\n\t\tlet\r\n\t\t\t--own interfaces:\r\n\t\t\townInterfaces : Set(OperationInterface)\r\n\t\t\t  = self.providedRoles_InterfaceProvidingEntity->select(pr|pr.oclIsTypeOf(OperationProvidedRole))->collect(pr : ProvidedRole | pr.oclAsType (OperationProvidedRole).providedInterface__OperationProvidedRole)->asSet()\r\n    in    \r\n    \t--complete type interfaces:\r\n    \tself.parentCompleteComponentTypes->forAll\r\n      ( p : CompleteComponentType |\r\n        (\r\n        \tp.providedRoles_InterfaceProvidingEntity->select(pr|pr.oclIsTypeOf(OperationProvidedRole))->collect(pr : ProvidedRole | pr.oclAsType (OperationProvidedRole).providedInterface__OperationProvidedRole)->asSet()\r\n        \t-\r\n        \townInterfaces\r\n      \t)->isEmpty()\r\n    \t)\r\n\telse\r\n\t\ttrue\r\n\tendif";
    protected static final String IMPLEMENTATION_COMPONENT_TYPE__REQUIRE_SAME_OR_FEWER_INTERFACES_AS_COMPLETE_COMPONENT_TYPE__EEXPRESSION = "-- ImplementationComponent has to require the same or fewer interfaces like the CompleteComponentType (if set) #\r\n\tif\r\n\t\t-- apply constraint only for non-empty CompleteComponentTypes #\r\n\t\tself.parentCompleteComponentTypes->notEmpty()\r\n\tthen\r\n\t    let\r\n\t      --own interfaces:\r\n\t      ownInterfaces : Set(OperationInterface) \r\n\t        = self.requiredRoles_InterfaceRequiringEntity->select(rr|rr.oclIsTypeOf(OperationRequiredRole))->collect(rr : RequiredRole | rr.oclAsType (OperationRequiredRole).requiredInterface__OperationRequiredRole)->asSet()\r\n\t    in\r\n\t      --complete type interfaces:\r\n\t      self.parentCompleteComponentTypes->forAll\r\n\t      ( p : CompleteComponentType |\r\n\t      \t(\r\n\t\t      \townInterfaces\r\n\t\t        -\r\n\t\t        p.requiredRoles_InterfaceRequiringEntity->select(rr|rr.oclIsTypeOf(OperationRequiredRole))->collect(rr : RequiredRole | rr.oclAsType (OperationRequiredRole).requiredInterface__OperationRequiredRole)->asSet()\r\n\t      \t)->isEmpty()\r\n\t    \t)\r\n\telse\r\n\t\ttrue\r\n\tendif";
    protected static final String REPOSITORY__REPOSITORYNOTEMPTY__EEXPRESSION = "self.components__Repository->size()<>0 or self.dataTypes__Repository->size()<>0 or self.interfaces__Repository->size()<>0 or self.failureTypes__Repository->size()<>0";
    protected static final String INTERFACE__NO_PROTOCOL_TYPE_ID_USED_TWICE__EEXPRESSION = "self.protocols__Interface->forAll(p1, p2 |\r\np1.protocolTypeID <> p2.protocolTypeID)\r\n";
    protected static final String OPERATION_SIGNATURE__PARAMETER_NAMES_HAVE_TO_BE_UNIQUE_FOR_ASIGNATURE__EEXPRESSION = "self.parameters__OperationSignature->isUnique(p : Parameter |\r\n\tp.parameterName\r\n)";
    protected static final String OPERATION_INTERFACE__SIGNATURES_HAVE_TO_BE_UNIQUE_FOR_AN_INTERFACE__EEXPRESSION = "-- full signature has to be unique \r\n-- (use of ocl-tupels) #\r\nlet sigs : Bag(\r\n\t-- parameters: Sequence of DataType, NOT name #\r\n\t-- exceptions have not to be considered #\r\n\tTuple(returnType : DataType, serviceName : String, parameters : Sequence(DataType) ) \r\n) = \r\nself.signatures__OperationInterface->collect(sig : OperationSignature |\r\n\tTuple{\r\n\t\treturnType : DataType = sig.returnType__OperationSignature,\r\n\t\tserviceName : String = sig.entityName,\r\n\t\tparameters : Sequence(DataType) = sig.parameters__OperationSignature.dataType__Parameter\r\n\t}\r\n)\r\nin\r\nsigs->isUnique(s|s)";
    protected static final String COMPLETE_COMPONENT_TYPE__AT_LEAST_ONE_INTERFACE_HAS_TO_BE_PROVIDED_OR_REQUIRED_BY_AUSEFULL_COMPLETE_COMPONENT_TYPE__EEXPRESSION = "(\r\n\tself.oclIsTypeOf(CompleteComponentType)\r\n\tor\r\n\tself.oclIsTypeOf(ImplementationComponentType)\r\n\tor\r\n\tself.oclIsTypeOf(CompositeComponent)\r\n\tor\r\n\tself.oclIsTypeOf(BasicComponent)\r\n)\r\nimplies\r\n(\r\n\tself.providedRoles_InterfaceProvidingEntity->size() >= 1\r\n\tor\r\n\tself.requiredRoles_InterfaceRequiringEntity->size() >= 1\r\n)";
    protected static final String COMPLETE_COMPONENT_TYPE__PROVIDED_INTERFACES_HAVE_TO_CONFORM_TO_PROVIDED_TYPE2__EEXPRESSION = "-- CompleteTypes provided Interfaces have to be a superset\r\n-- of ProvidesComponentType provided Interfaces #\r\n--\r\n-- ACCx are used to accumulate Sets/Bags; usually only the very inner ACCx is used at all.\r\n--\r\n-- Recursive Query for parent Interface IDs\r\n-- see \"lpar2005.pdf\" (Second-order principles in specification languages for Object-Oriented Programs; Beckert, Tretelman) pp. 11 #\r\n--let parentInterfaces : Bag(Interface) =\r\n--\tself.providedRoles->iterate(r : ProvidedRole; acc2 : Bag(Interface) = Bag{} |\r\n--\t\tacc2->union(r.providedInterface.parentInterface->asBag()) -- asBag required to allow Set operations #\r\n--\t) in\r\n--let anchestorInterfaces : Bag(Interface) =\r\n--\tself.providedRoles->iterate(r : ProvidedRole; acc4 : Bag(Interface) = Bag{} |\r\n--\t\tacc4->union(r.providedInterface.parentInterface->asBag()) -- asBag required to allow Set operations #\r\n--\t)->union( -- union with anchestors found in former recursion #\r\n--\t\tself.providedRoles->iterate(r : ProvidedRole; acc6 : Bag(Interface) = Bag{} |\r\n--\t\t\tacc6->union(r.providedInterface.parentInterface.anchestorInterfaces) --already Set/Bag\r\n--\t\t)\r\n--\t) in\r\n--\t-- Directly provided anchestorInterfaces need to be a superset of provided interfaces of Supertype #\r\n--\tanchestorInterfaces.identifier.id->includesAll(\r\n--\t\tself.parentProvidesComponentTypes->iterate(pt : ProvidesComponentType; acc1 : Bag(String) = Bag{} |\r\n--\t\t\tpt.providedRoles->iterate(r : ProvidedRole; acc2 : Bag(String) = Bag{} |\r\n--\t\t\t\tacc2->union(r.providedInterface.identifier.id->asBag()) -- asBag required to allow Set operations #\r\n--\t\t\t)\r\n--\t\t)\r\n--\t)\r\ntrue";
    protected static final String PROVIDES_COMPONENT_TYPE__AT_LEAST_ONE_INTERFACE_HAS_TO_BE_PROVIDED_BY_AUSEFULL_PROVIDES_COMPONENT_TYPE__EEXPRESSION = "self.oclIsTypeOf(ProvidesComponentType)\r\nimplies\r\nself.providedRoles_InterfaceProvidingEntity->size() >= 1";

    protected EPackage getEPackage() {
        return RepositoryPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validatePassiveResource((PassiveResource)value, diagnostics, context);
            }
            case 1: {
                return this.validateBasicComponent((BasicComponent)value, diagnostics, context);
            }
            case 2: {
                return this.validateImplementationComponentType((ImplementationComponentType)value, diagnostics, context);
            }
            case 3: {
                return this.validateRepositoryComponent((RepositoryComponent)value, diagnostics, context);
            }
            case 4: {
                return this.validateProvidedRole((ProvidedRole)value, diagnostics, context);
            }
            case 5: {
                return this.validateParameter((Parameter)value, diagnostics, context);
            }
            case 6: {
                return this.validateDataType((DataType)value, diagnostics, context);
            }
            case 7: {
                return this.validateRepository((Repository)value, diagnostics, context);
            }
            case 8: {
                return this.validateInterface((Interface)value, diagnostics, context);
            }
            case 9: {
                return this.validateRequiredCharacterisation((RequiredCharacterisation)value, diagnostics, context);
            }
            case 10: {
                return this.validateEventGroup((EventGroup)value, diagnostics, context);
            }
            case 11: {
                return this.validateEventType((EventType)value, diagnostics, context);
            }
            case 12: {
                return this.validateSignature((Signature)value, diagnostics, context);
            }
            case 13: {
                return this.validateExceptionType((ExceptionType)value, diagnostics, context);
            }
            case 14: {
                return this.validateInfrastructureSignature((InfrastructureSignature)value, diagnostics, context);
            }
            case 15: {
                return this.validateInfrastructureInterface((InfrastructureInterface)value, diagnostics, context);
            }
            case 16: {
                return this.validateInfrastructureRequiredRole((InfrastructureRequiredRole)value, diagnostics, context);
            }
            case 17: {
                return this.validateRequiredRole((RequiredRole)value, diagnostics, context);
            }
            case 18: {
                return this.validateOperationSignature((OperationSignature)value, diagnostics, context);
            }
            case 19: {
                return this.validateOperationInterface((OperationInterface)value, diagnostics, context);
            }
            case 20: {
                return this.validateOperationRequiredRole((OperationRequiredRole)value, diagnostics, context);
            }
            case 21: {
                return this.validateSourceRole((SourceRole)value, diagnostics, context);
            }
            case 22: {
                return this.validateSinkRole((SinkRole)value, diagnostics, context);
            }
            case 23: {
                return this.validateOperationProvidedRole((OperationProvidedRole)value, diagnostics, context);
            }
            case 24: {
                return this.validateInfrastructureProvidedRole((InfrastructureProvidedRole)value, diagnostics, context);
            }
            case 25: {
                return this.validateCompleteComponentType((CompleteComponentType)value, diagnostics, context);
            }
            case 26: {
                return this.validateProvidesComponentType((ProvidesComponentType)value, diagnostics, context);
            }
            case 27: {
                return this.validateCompositeComponent((CompositeComponent)value, diagnostics, context);
            }
            case 28: {
                return this.validatePrimitiveDataType((PrimitiveDataType)value, diagnostics, context);
            }
            case 29: {
                return this.validateCollectionDataType((CollectionDataType)value, diagnostics, context);
            }
            case 30: {
                return this.validateCompositeDataType((CompositeDataType)value, diagnostics, context);
            }
            case 31: {
                return this.validateInnerDeclaration((InnerDeclaration)value, diagnostics, context);
            }
            case 32: {
                return this.validateRole((Role)value, diagnostics, context);
            }
            case 33: {
                return this.validateParameterModifier((ParameterModifier)((Object)value), diagnostics, context);
            }
            case 34: {
                return this.validateComponentType((ComponentType)((Object)value), diagnostics, context);
            }
            case 35: {
                return this.validatePrimitiveTypeEnum((PrimitiveTypeEnum)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validatePassiveResource(PassiveResource passiveResource, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(passiveResource, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(passiveResource, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(passiveResource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(passiveResource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(passiveResource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(passiveResource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(passiveResource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(passiveResource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(passiveResource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)passiveResource, diagnostics, context);
        }
        return result;
    }

    public boolean validateBasicComponent(BasicComponent basicComponent, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(basicComponent, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(basicComponent, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(basicComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(basicComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(basicComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(basicComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(basicComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(basicComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(basicComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)basicComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.entityValidator.validateInterfaceProvidingEntity_needID(basicComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateImplementationComponentType_requiredInterfacesHaveToConformToCompleteType(basicComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateImplementationComponentType_providedInterfacesHaveToConformToCompleteType(basicComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateImplementationComponentType_providedInterfaceHaveToConformToComponentType(basicComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateImplementationComponentType_provideSameOrMoreInterfacesAsCompleteComponentType(basicComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateImplementationComponentType_requireSameOrFewerInterfacesAsCompleteComponentType(basicComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBasicComponent_noSeffTypeUsedTwice(basicComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBasicComponent_everyOperationInterfaceMethodsNeedsSEFF(basicComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBasicComponent_everyInfrastructureInterfaceMethodsNeedsSEFF(basicComponent, diagnostics, context);
        }
        return result;
    }

    public boolean validateBasicComponent_noSeffTypeUsedTwice(BasicComponent basicComponent, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(RepositoryPackage.Literals.BASIC_COMPONENT, basicComponent, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "noSeffTypeUsedTwice", BASIC_COMPONENT__NO_SEFF_TYPE_USED_TWICE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateBasicComponent_everyOperationInterfaceMethodsNeedsSEFF(BasicComponent basicComponent, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(RepositoryPackage.Literals.BASIC_COMPONENT, basicComponent, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "everyOperationInterfaceMethodsNeedsSEFF", BASIC_COMPONENT__EVERY_OPERATION_INTERFACE_METHODS_NEEDS_SEFF__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateBasicComponent_everyInfrastructureInterfaceMethodsNeedsSEFF(BasicComponent basicComponent, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(RepositoryPackage.Literals.BASIC_COMPONENT, basicComponent, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "everyInfrastructureInterfaceMethodsNeedsSEFF", BASIC_COMPONENT__EVERY_INFRASTRUCTURE_INTERFACE_METHODS_NEEDS_SEFF__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateImplementationComponentType(ImplementationComponentType implementationComponentType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(implementationComponentType, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(implementationComponentType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(implementationComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(implementationComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(implementationComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(implementationComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(implementationComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(implementationComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(implementationComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)implementationComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.entityValidator.validateInterfaceProvidingEntity_needID(implementationComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateImplementationComponentType_requiredInterfacesHaveToConformToCompleteType(implementationComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateImplementationComponentType_providedInterfacesHaveToConformToCompleteType(implementationComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateImplementationComponentType_providedInterfaceHaveToConformToComponentType(implementationComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateImplementationComponentType_provideSameOrMoreInterfacesAsCompleteComponentType(implementationComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateImplementationComponentType_requireSameOrFewerInterfacesAsCompleteComponentType(implementationComponentType, diagnostics, context);
        }
        return result;
    }

    public boolean validateImplementationComponentType_requiredInterfacesHaveToConformToCompleteType(ImplementationComponentType implementationComponentType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(RepositoryPackage.Literals.IMPLEMENTATION_COMPONENT_TYPE, implementationComponentType, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "requiredInterfacesHaveToConformToCompleteType", IMPLEMENTATION_COMPONENT_TYPE__REQUIRED_INTERFACES_HAVE_TO_CONFORM_TO_COMPLETE_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateImplementationComponentType_providedInterfacesHaveToConformToCompleteType(ImplementationComponentType implementationComponentType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(RepositoryPackage.Literals.IMPLEMENTATION_COMPONENT_TYPE, implementationComponentType, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "providedInterfacesHaveToConformToCompleteType", IMPLEMENTATION_COMPONENT_TYPE__PROVIDED_INTERFACES_HAVE_TO_CONFORM_TO_COMPLETE_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateImplementationComponentType_providedInterfaceHaveToConformToComponentType(ImplementationComponentType implementationComponentType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(RepositoryPackage.Literals.IMPLEMENTATION_COMPONENT_TYPE, implementationComponentType, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "providedInterfaceHaveToConformToComponentType", IMPLEMENTATION_COMPONENT_TYPE__PROVIDED_INTERFACE_HAVE_TO_CONFORM_TO_COMPONENT_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateImplementationComponentType_provideSameOrMoreInterfacesAsCompleteComponentType(ImplementationComponentType implementationComponentType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(RepositoryPackage.Literals.IMPLEMENTATION_COMPONENT_TYPE, implementationComponentType, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "provideSameOrMoreInterfacesAsCompleteComponentType", IMPLEMENTATION_COMPONENT_TYPE__PROVIDE_SAME_OR_MORE_INTERFACES_AS_COMPLETE_COMPONENT_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateImplementationComponentType_requireSameOrFewerInterfacesAsCompleteComponentType(ImplementationComponentType implementationComponentType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(RepositoryPackage.Literals.IMPLEMENTATION_COMPONENT_TYPE, implementationComponentType, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "requireSameOrFewerInterfacesAsCompleteComponentType", IMPLEMENTATION_COMPONENT_TYPE__REQUIRE_SAME_OR_FEWER_INTERFACES_AS_COMPLETE_COMPONENT_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateRepositoryComponent(RepositoryComponent repositoryComponent, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(repositoryComponent, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(repositoryComponent, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(repositoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(repositoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(repositoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(repositoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(repositoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(repositoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(repositoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)repositoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.entityValidator.validateInterfaceProvidingEntity_needID(repositoryComponent, diagnostics, context);
        }
        return result;
    }

    public boolean validateProvidedRole(ProvidedRole providedRole, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(providedRole, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(providedRole, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(providedRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(providedRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(providedRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(providedRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(providedRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(providedRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(providedRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)providedRole, diagnostics, context);
        }
        return result;
    }

    public boolean validateParameter(Parameter parameter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(parameter, diagnostics, context);
    }

    public boolean validateDataType(DataType dataType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(dataType, diagnostics, context);
    }

    public boolean validateRepository(Repository repository, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(repository, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(repository, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(repository, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(repository, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(repository, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(repository, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(repository, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(repository, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(repository, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)repository, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRepository_repositorynotempty(repository, diagnostics, context);
        }
        return result;
    }

    public boolean validateRepository_repositorynotempty(Repository repository, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(RepositoryPackage.Literals.REPOSITORY, repository, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "repositorynotempty", REPOSITORY__REPOSITORYNOTEMPTY__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateInterface(Interface interface_, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(interface_, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(interface_, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(interface_, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(interface_, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(interface_, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(interface_, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(interface_, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(interface_, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(interface_, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)interface_, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInterface_noProtocolTypeIDUsedTwice(interface_, diagnostics, context);
        }
        return result;
    }

    public boolean validateInterface_noProtocolTypeIDUsedTwice(Interface interface_, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(RepositoryPackage.Literals.INTERFACE, interface_, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "noProtocolTypeIDUsedTwice", INTERFACE__NO_PROTOCOL_TYPE_ID_USED_TWICE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateRequiredCharacterisation(RequiredCharacterisation requiredCharacterisation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(requiredCharacterisation, diagnostics, context);
    }

    public boolean validateEventGroup(EventGroup eventGroup, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(eventGroup, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(eventGroup, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(eventGroup, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(eventGroup, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(eventGroup, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(eventGroup, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(eventGroup, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(eventGroup, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(eventGroup, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)eventGroup, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInterface_noProtocolTypeIDUsedTwice(eventGroup, diagnostics, context);
        }
        return result;
    }

    public boolean validateEventType(EventType eventType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(eventType, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(eventType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(eventType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(eventType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(eventType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(eventType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(eventType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(eventType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(eventType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)eventType, diagnostics, context);
        }
        return result;
    }

    public boolean validateSignature(Signature signature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(signature, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(signature, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(signature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(signature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(signature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(signature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(signature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(signature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(signature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)signature, diagnostics, context);
        }
        return result;
    }

    public boolean validateExceptionType(ExceptionType exceptionType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(exceptionType, diagnostics, context);
    }

    public boolean validateInfrastructureSignature(InfrastructureSignature infrastructureSignature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(infrastructureSignature, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(infrastructureSignature, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(infrastructureSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(infrastructureSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(infrastructureSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(infrastructureSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(infrastructureSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(infrastructureSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(infrastructureSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)infrastructureSignature, diagnostics, context);
        }
        return result;
    }

    public boolean validateInfrastructureInterface(InfrastructureInterface infrastructureInterface, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(infrastructureInterface, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(infrastructureInterface, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(infrastructureInterface, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(infrastructureInterface, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(infrastructureInterface, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(infrastructureInterface, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(infrastructureInterface, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(infrastructureInterface, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(infrastructureInterface, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)infrastructureInterface, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInterface_noProtocolTypeIDUsedTwice(infrastructureInterface, diagnostics, context);
        }
        return result;
    }

    public boolean validateInfrastructureRequiredRole(InfrastructureRequiredRole infrastructureRequiredRole, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(infrastructureRequiredRole, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(infrastructureRequiredRole, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(infrastructureRequiredRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(infrastructureRequiredRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(infrastructureRequiredRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(infrastructureRequiredRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(infrastructureRequiredRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(infrastructureRequiredRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(infrastructureRequiredRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)infrastructureRequiredRole, diagnostics, context);
        }
        return result;
    }

    public boolean validateRequiredRole(RequiredRole requiredRole, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(requiredRole, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(requiredRole, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(requiredRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(requiredRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(requiredRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(requiredRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(requiredRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(requiredRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(requiredRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)requiredRole, diagnostics, context);
        }
        return result;
    }

    public boolean validateOperationSignature(OperationSignature operationSignature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(operationSignature, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(operationSignature, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(operationSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(operationSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(operationSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(operationSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(operationSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(operationSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(operationSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)operationSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateOperationSignature_parameterNamesHaveToBeUniqueForASignature(operationSignature, diagnostics, context);
        }
        return result;
    }

    public boolean validateOperationSignature_parameterNamesHaveToBeUniqueForASignature(OperationSignature operationSignature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(RepositoryPackage.Literals.OPERATION_SIGNATURE, operationSignature, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "parameterNamesHaveToBeUniqueForASignature", OPERATION_SIGNATURE__PARAMETER_NAMES_HAVE_TO_BE_UNIQUE_FOR_ASIGNATURE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateOperationInterface(OperationInterface operationInterface, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(operationInterface, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(operationInterface, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(operationInterface, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(operationInterface, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(operationInterface, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(operationInterface, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(operationInterface, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(operationInterface, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(operationInterface, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)operationInterface, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInterface_noProtocolTypeIDUsedTwice(operationInterface, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateOperationInterface_signaturesHaveToBeUniqueForAnInterface(operationInterface, diagnostics, context);
        }
        return result;
    }

    public boolean validateOperationInterface_signaturesHaveToBeUniqueForAnInterface(OperationInterface operationInterface, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(RepositoryPackage.Literals.OPERATION_INTERFACE, operationInterface, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "signaturesHaveToBeUniqueForAnInterface", OPERATION_INTERFACE__SIGNATURES_HAVE_TO_BE_UNIQUE_FOR_AN_INTERFACE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateOperationRequiredRole(OperationRequiredRole operationRequiredRole, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(operationRequiredRole, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(operationRequiredRole, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(operationRequiredRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(operationRequiredRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(operationRequiredRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(operationRequiredRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(operationRequiredRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(operationRequiredRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(operationRequiredRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)operationRequiredRole, diagnostics, context);
        }
        return result;
    }

    public boolean validateSourceRole(SourceRole sourceRole, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(sourceRole, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(sourceRole, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(sourceRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(sourceRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(sourceRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(sourceRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(sourceRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(sourceRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(sourceRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)sourceRole, diagnostics, context);
        }
        return result;
    }

    public boolean validateSinkRole(SinkRole sinkRole, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(sinkRole, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(sinkRole, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(sinkRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(sinkRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(sinkRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(sinkRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(sinkRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(sinkRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(sinkRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)sinkRole, diagnostics, context);
        }
        return result;
    }

    public boolean validateOperationProvidedRole(OperationProvidedRole operationProvidedRole, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(operationProvidedRole, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(operationProvidedRole, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(operationProvidedRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(operationProvidedRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(operationProvidedRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(operationProvidedRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(operationProvidedRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(operationProvidedRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(operationProvidedRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)operationProvidedRole, diagnostics, context);
        }
        return result;
    }

    public boolean validateInfrastructureProvidedRole(InfrastructureProvidedRole infrastructureProvidedRole, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(infrastructureProvidedRole, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(infrastructureProvidedRole, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(infrastructureProvidedRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(infrastructureProvidedRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(infrastructureProvidedRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(infrastructureProvidedRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(infrastructureProvidedRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(infrastructureProvidedRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(infrastructureProvidedRole, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)infrastructureProvidedRole, diagnostics, context);
        }
        return result;
    }

    public boolean validateCompleteComponentType(CompleteComponentType completeComponentType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(completeComponentType, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(completeComponentType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(completeComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(completeComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(completeComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(completeComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(completeComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(completeComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(completeComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)completeComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.entityValidator.validateInterfaceProvidingEntity_needID(completeComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCompleteComponentType_atLeastOneInterfaceHasToBeProvidedOrRequiredByAUsefullCompleteComponentType(completeComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCompleteComponentType_providedInterfacesHaveToConformToProvidedType2(completeComponentType, diagnostics, context);
        }
        return result;
    }

    public boolean validateCompleteComponentType_atLeastOneInterfaceHasToBeProvidedOrRequiredByAUsefullCompleteComponentType(CompleteComponentType completeComponentType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(RepositoryPackage.Literals.COMPLETE_COMPONENT_TYPE, completeComponentType, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "atLeastOneInterfaceHasToBeProvidedOrRequiredByAUsefullCompleteComponentType", COMPLETE_COMPONENT_TYPE__AT_LEAST_ONE_INTERFACE_HAS_TO_BE_PROVIDED_OR_REQUIRED_BY_AUSEFULL_COMPLETE_COMPONENT_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateCompleteComponentType_providedInterfacesHaveToConformToProvidedType2(CompleteComponentType completeComponentType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(RepositoryPackage.Literals.COMPLETE_COMPONENT_TYPE, completeComponentType, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "providedInterfacesHaveToConformToProvidedType2", COMPLETE_COMPONENT_TYPE__PROVIDED_INTERFACES_HAVE_TO_CONFORM_TO_PROVIDED_TYPE2__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateProvidesComponentType(ProvidesComponentType providesComponentType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(providesComponentType, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(providesComponentType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(providesComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(providesComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(providesComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(providesComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(providesComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(providesComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(providesComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)providesComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.entityValidator.validateInterfaceProvidingEntity_needID(providesComponentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateProvidesComponentType_atLeastOneInterfaceHasToBeProvidedByAUsefullProvidesComponentType(providesComponentType, diagnostics, context);
        }
        return result;
    }

    public boolean validateProvidesComponentType_atLeastOneInterfaceHasToBeProvidedByAUsefullProvidesComponentType(ProvidesComponentType providesComponentType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(RepositoryPackage.Literals.PROVIDES_COMPONENT_TYPE, providesComponentType, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "atLeastOneInterfaceHasToBeProvidedByAUsefullProvidesComponentType", PROVIDES_COMPONENT_TYPE__AT_LEAST_ONE_INTERFACE_HAS_TO_BE_PROVIDED_BY_AUSEFULL_PROVIDES_COMPONENT_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateCompositeComponent(CompositeComponent compositeComponent, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(compositeComponent, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(compositeComponent, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.compositionValidator.validateComposedStructure_multipleConnectorsConstraint(compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.compositionValidator.validateComposedStructure_multipleConnectorsConstraintForAssemblyConnectors(compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.compositionValidator.validateComposedStructure_validateSameSubsystemMustNotBeInstantiatedMoreThanOnce(compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.entityValidator.validateInterfaceProvidingEntity_needID(compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.entityValidator.validateComposedProvidingRequiringEntity_operationProvidedRolesMustBeBound(compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateImplementationComponentType_requiredInterfacesHaveToConformToCompleteType(compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateImplementationComponentType_providedInterfacesHaveToConformToCompleteType(compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateImplementationComponentType_providedInterfaceHaveToConformToComponentType(compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateImplementationComponentType_provideSameOrMoreInterfacesAsCompleteComponentType(compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateImplementationComponentType_requireSameOrFewerInterfacesAsCompleteComponentType(compositeComponent, diagnostics, context);
        }
        return result;
    }

    public boolean validatePrimitiveDataType(PrimitiveDataType primitiveDataType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(primitiveDataType, diagnostics, context);
    }

    public boolean validateCollectionDataType(CollectionDataType collectionDataType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(collectionDataType, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(collectionDataType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(collectionDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(collectionDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(collectionDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(collectionDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(collectionDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(collectionDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(collectionDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)collectionDataType, diagnostics, context);
        }
        return result;
    }

    public boolean validateCompositeDataType(CompositeDataType compositeDataType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(compositeDataType, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(compositeDataType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(compositeDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(compositeDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(compositeDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(compositeDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(compositeDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(compositeDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(compositeDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)compositeDataType, diagnostics, context);
        }
        return result;
    }

    public boolean validateInnerDeclaration(InnerDeclaration innerDeclaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(innerDeclaration, diagnostics, context);
    }

    public boolean validateRole(Role role, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(role, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(role, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(role, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(role, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(role, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(role, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(role, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(role, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(role, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)role, diagnostics, context);
        }
        return result;
    }

    public boolean validateParameterModifier(ParameterModifier parameterModifier, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateComponentType(ComponentType componentType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validatePrimitiveTypeEnum(PrimitiveTypeEnum primitiveTypeEnum, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

