/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.pcm.seff.seff_performance.util;

import de.uka.ipd.sdq.identifier.Identifier;
import de.uka.ipd.sdq.identifier.util.IdentifierValidator;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.palladiosimulator.pcm.seff.seff_performance.InfrastructureCall;
import org.palladiosimulator.pcm.seff.seff_performance.ParametricResourceDemand;
import org.palladiosimulator.pcm.seff.seff_performance.ResourceCall;
import org.palladiosimulator.pcm.seff.seff_performance.SeffPerformancePackage;

public class SeffPerformanceValidator
extends EObjectValidator {
    public static final String copyright = "Copyright 2005-2017 by palladiosimulator.org";
    public static final SeffPerformanceValidator INSTANCE = new SeffPerformanceValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.palladiosimulator.pcm.seff.seff_performance";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected IdentifierValidator identifierValidator = IdentifierValidator.INSTANCE;
    protected static final String INFRASTRUCTURE_CALL__SIGNATURE_MUST_BELONG_TO_USED_REQUIRED_ROLE__EEXPRESSION = "signature__InfrastructureCall.infrastructureInterface__InfrastructureSignature = requiredRole__InfrastructureCall.requiredInterface__InfrastructureRequiredRole";
    protected static final String INFRASTRUCTURE_CALL__REFERENCED_REQUIRED_ROLE_MUST_BE_REQUIRED_BY_COMPONENT__EEXPRESSION = "self.oclAsType(ecore::EObject)->closure(eContainer())->select( entity | entity.oclIsKindOf(pcm::core::entity::InterfaceRequiringEntity)).oclAsType(pcm::core::entity::InterfaceRequiringEntity).requiredRoles_InterfaceRequiringEntity->includes(self.requiredRole__InfrastructureCall)";
    protected static final String INFRASTRUCTURE_CALL__SIGNATURE_ROLE_COMBINATION_MUST_BE_UNIQUE_WITHIN_ABSTRACT_INTERNAL_CONTROL_FLOW_ACTION__EEXPRESSION = "self.action__InfrastructureCall.infrastructureCall__Action->select(call | call.requiredRole__InfrastructureCall = self.requiredRole__InfrastructureCall and call.signature__InfrastructureCall=self.signature__InfrastructureCall)->size() = 1";
    protected static final String RESOURCE_CALL__RESOURCE_SIGNATURE_BELONGS_TO_RESOURCE_REQUIRED_ROLE__EEXPRESSION = "self.resourceRequiredRole__ResourceCall.requiredResourceInterface__ResourceRequiredRole.resourceSignatures__ResourceInterface->includes(self.signature__ResourceCall)";
    protected static final String RESOURCE_CALL__RESOURCE_REQUIRED_ROLE_MUST_BE_REFERENCED_BY_COMPONENT__EEXPRESSION = "self.oclAsType(ecore::EObject)->closure(eContainer())->select( entity | entity.oclIsKindOf(pcm::core::entity::ResourceInterfaceRequiringEntity)).oclAsType(pcm::core::entity::ResourceInterfaceRequiringEntity).resourceRequiredRoles__ResourceInterfaceRequiringEntity->includes(self.resourceRequiredRole__ResourceCall)";
    protected static final String RESOURCE_CALL__SIGNATURE_ROLE_COMBINATION_MUST_BE_UNIQUE_WITHIN_ABSTRACT_INTERNAL_CONTROL_FLOW_ACTION__EEXPRESSION = "self.action__ResourceCall.resourceCall__Action->select(call | call.resourceRequiredRole__ResourceCall=self.resourceRequiredRole__ResourceCall and call.signature__ResourceCall=self.signature__ResourceCall)->size() = 1";
    protected static final String PARAMETRIC_RESOURCE_DEMAND__DEMANDED_PROCESSING_RESOURCE_MUST_BE_UNIQUE_WITHIN_ABSTRACT_INTERNAL_CONTROL_FLOW_ACTION__EEXPRESSION = "self.action_ParametricResourceDemand.resourceDemand_Action->select(prd | prd.requiredResource_ParametricResourceDemand=self.requiredResource_ParametricResourceDemand)->size() = 1";

    protected EPackage getEPackage() {
        return SeffPerformancePackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateInfrastructureCall((InfrastructureCall)value, diagnostics, context);
            }
            case 1: {
                return this.validateResourceCall((ResourceCall)value, diagnostics, context);
            }
            case 2: {
                return this.validateParametricResourceDemand((ParametricResourceDemand)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateInfrastructureCall(InfrastructureCall infrastructureCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(infrastructureCall, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(infrastructureCall, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(infrastructureCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(infrastructureCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(infrastructureCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(infrastructureCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(infrastructureCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(infrastructureCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(infrastructureCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)infrastructureCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInfrastructureCall_signatureMustBelongToUsedRequiredRole(infrastructureCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInfrastructureCall_referencedRequiredRoleMustBeRequiredByComponent(infrastructureCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInfrastructureCall_signatureRoleCombinationMustBeUniqueWithinAbstractInternalControlFlowAction(infrastructureCall, diagnostics, context);
        }
        return result;
    }

    public boolean validateInfrastructureCall_signatureMustBelongToUsedRequiredRole(InfrastructureCall infrastructureCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(SeffPerformancePackage.Literals.INFRASTRUCTURE_CALL, infrastructureCall, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "signatureMustBelongToUsedRequiredRole", INFRASTRUCTURE_CALL__SIGNATURE_MUST_BELONG_TO_USED_REQUIRED_ROLE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateInfrastructureCall_referencedRequiredRoleMustBeRequiredByComponent(InfrastructureCall infrastructureCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(SeffPerformancePackage.Literals.INFRASTRUCTURE_CALL, infrastructureCall, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "referencedRequiredRoleMustBeRequiredByComponent", INFRASTRUCTURE_CALL__REFERENCED_REQUIRED_ROLE_MUST_BE_REQUIRED_BY_COMPONENT__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateInfrastructureCall_signatureRoleCombinationMustBeUniqueWithinAbstractInternalControlFlowAction(InfrastructureCall infrastructureCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(SeffPerformancePackage.Literals.INFRASTRUCTURE_CALL, infrastructureCall, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "signatureRoleCombinationMustBeUniqueWithinAbstractInternalControlFlowAction", INFRASTRUCTURE_CALL__SIGNATURE_ROLE_COMBINATION_MUST_BE_UNIQUE_WITHIN_ABSTRACT_INTERNAL_CONTROL_FLOW_ACTION__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateResourceCall(ResourceCall resourceCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(resourceCall, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(resourceCall, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(resourceCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(resourceCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(resourceCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(resourceCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(resourceCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(resourceCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(resourceCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)resourceCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateResourceCall_resourceSignatureBelongsToResourceRequiredRole(resourceCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateResourceCall_resourceRequiredRoleMustBeReferencedByComponent(resourceCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateResourceCall_signatureRoleCombinationMustBeUniqueWithinAbstractInternalControlFlowAction(resourceCall, diagnostics, context);
        }
        return result;
    }

    public boolean validateResourceCall_resourceSignatureBelongsToResourceRequiredRole(ResourceCall resourceCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(SeffPerformancePackage.Literals.RESOURCE_CALL, resourceCall, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "resourceSignatureBelongsToResourceRequiredRole", RESOURCE_CALL__RESOURCE_SIGNATURE_BELONGS_TO_RESOURCE_REQUIRED_ROLE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateResourceCall_resourceRequiredRoleMustBeReferencedByComponent(ResourceCall resourceCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(SeffPerformancePackage.Literals.RESOURCE_CALL, resourceCall, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "resourceRequiredRoleMustBeReferencedByComponent", RESOURCE_CALL__RESOURCE_REQUIRED_ROLE_MUST_BE_REFERENCED_BY_COMPONENT__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateResourceCall_signatureRoleCombinationMustBeUniqueWithinAbstractInternalControlFlowAction(ResourceCall resourceCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(SeffPerformancePackage.Literals.RESOURCE_CALL, resourceCall, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "signatureRoleCombinationMustBeUniqueWithinAbstractInternalControlFlowAction", RESOURCE_CALL__SIGNATURE_ROLE_COMBINATION_MUST_BE_UNIQUE_WITHIN_ABSTRACT_INTERNAL_CONTROL_FLOW_ACTION__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateParametricResourceDemand(ParametricResourceDemand parametricResourceDemand, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(parametricResourceDemand, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(parametricResourceDemand, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(parametricResourceDemand, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(parametricResourceDemand, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(parametricResourceDemand, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(parametricResourceDemand, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(parametricResourceDemand, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(parametricResourceDemand, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(parametricResourceDemand, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateParametricResourceDemand_demandedProcessingResourceMustBeUniqueWithinAbstractInternalControlFlowAction(parametricResourceDemand, diagnostics, context);
        }
        return result;
    }

    public boolean validateParametricResourceDemand_demandedProcessingResourceMustBeUniqueWithinAbstractInternalControlFlowAction(ParametricResourceDemand parametricResourceDemand, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(SeffPerformancePackage.Literals.PARAMETRIC_RESOURCE_DEMAND, parametricResourceDemand, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "demandedProcessingResourceMustBeUniqueWithinAbstractInternalControlFlowAction", PARAMETRIC_RESOURCE_DEMAND__DEMANDED_PROCESSING_RESOURCE_MUST_BE_UNIQUE_WITHIN_ABSTRACT_INTERNAL_CONTROL_FLOW_ACTION__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

