/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.junit5utils.extensions;

import com.google.common.collect.Streams;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Platform;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import tools.mdsd.junit5utils.annotations.InitializationTaskProvider;
import tools.mdsd.junit5utils.annotations.PluginTestOnly;
import tools.mdsd.library.standalone.initialization.InitializationTask;
import tools.mdsd.library.standalone.initialization.StandaloneInitializerBuilder;
import tools.mdsd.library.standalone.initialization.core.EclipseProjectByClassRegistration;

public class PlatformStandaloneExtension
implements BeforeAllCallback,
ExecutionCondition {
    public void beforeAll(ExtensionContext context) throws Exception {
        StandaloneInitializerBuilder builder = StandaloneInitializerBuilder.builder();
        List result = context.getElement().filter(Class.class::isInstance).map(Class.class::cast).map(ae -> {
            builder.addCustomTask((InitializationTask)new EclipseProjectByClassRegistration(ae));
            return this.collectInitializationProviders((Class<?>)ae).map(this::retrieveInitializationTask).collect(Collectors.toList());
        }).orElseGet(Collections::emptyList);
        result.forEach(arg_0 -> ((StandaloneInitializerBuilder)builder).addCustomTask(arg_0));
        builder.build().init();
    }

    Stream<Method> collectInitializationProviders(Class<?> clazz) {
        if (clazz == null) {
            return Stream.empty();
        }
        Stream<Method> selfs = Arrays.asList(clazz.getDeclaredMethods()).stream().filter(m -> m.getDeclaredAnnotation(InitializationTaskProvider.class) != null);
        Stream ifaces = Arrays.asList(clazz.getInterfaces()).stream().flatMap(this::collectInitializationProviders);
        Stream<Method> supers = this.collectInitializationProviders(clazz.getSuperclass());
        return Streams.concat((Stream[])new Stream[]{selfs, ifaces, supers});
    }

    InitializationTask retrieveInitializationTask(Method m) {
        InitializationTask result;
        if (!Modifier.isStatic(m.getModifiers())) {
            throw new Error("Only static methods may be annotation with @" + InitializationTaskProvider.class.getName());
        }
        if (!InitializationTask.class.isAssignableFrom(m.getReturnType())) {
            throw new Error("A static initialization provider method needs to return an instance of " + InitializationTask.class.getName());
        }
        if (m.getParameters().length > 0) {
            throw new Error("Currently no parameters are supported");
        }
        try {
            m.setAccessible(true);
            result = (InitializationTask)m.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new Error("Error invoking provider method.", e);
        }
        return result;
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        PluginTestOnly annotation;
        Optional element = context.getElement();
        if (element.isPresent() && (annotation = ((AnnotatedElement)element.get()).getAnnotation(PluginTestOnly.class)) != null && !Platform.isRunning()) {
            return ConditionEvaluationResult.disabled((String)"This test case is disabled in standalone-mode. It needs to be executed as plugin test.");
        }
        return ConditionEvaluationResult.enabled((String)"Test enabled by default");
    }
}

