/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.jobs;

import de.uka.ipd.sdq.workflow.jobs.AbstractJob;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.ICompositeJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractCompositeJob
extends AbstractJob
implements ICompositeJob,
List<IJob> {
    protected LinkedList<IJob> myJobs = new LinkedList();
    protected Stack<IJob> myExecutedJobs = new Stack();
    private String myName = null;

    @Override
    public void addJob(IJob job) {
        if (job == null) {
            throw new IllegalArgumentException("Job cannot be null");
        }
        this.myJobs.add(job);
    }

    @Override
    public abstract void execute(IProgressMonitor var1) throws JobFailedException, UserCanceledException;

    @Override
    public String getName() {
        if (this.myName != null) {
            return this.myName;
        }
        String compositeName = "CompositeJob <";
        for (IJob job : this.myJobs) {
            compositeName = String.valueOf(compositeName) + job.getName() + " ";
        }
        compositeName = String.valueOf(compositeName) + ">";
        return compositeName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    @Override
    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
        monitor.subTask("Cleanup of " + this.getName());
        while (!this.myExecutedJobs.empty()) {
            this.myExecutedJobs.pop().cleanup(monitor);
            monitor.worked(1);
        }
    }

    @Override
    public boolean add(IJob e) {
        return this.myJobs.add(e);
    }

    @Override
    public void add(int index, IJob element) {
        this.myJobs.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends IJob> c) {
        return this.myJobs.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends IJob> c) {
        return this.myJobs.addAll(index, c);
    }

    @Override
    public void addFirst(IJob e) {
        this.myJobs.addFirst(e);
    }

    @Override
    public void addLast(IJob e) {
        this.myJobs.addLast(e);
    }

    @Override
    public void clear() {
        this.myJobs.clear();
    }

    public Object clone() {
        return this.myJobs.clone();
    }

    @Override
    public boolean contains(Object o) {
        return this.myJobs.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.myJobs.containsAll(c);
    }

    public Iterator<IJob> descendingIterator() {
        return this.myJobs.descendingIterator();
    }

    public IJob element() {
        return this.myJobs.element();
    }

    @Override
    public boolean equals(Object o) {
        return this.myJobs.equals(o);
    }

    @Override
    public IJob get(int index) {
        return this.myJobs.get(index);
    }

    @Override
    public IJob getFirst() {
        return this.myJobs.getFirst();
    }

    @Override
    public IJob getLast() {
        return this.myJobs.getLast();
    }

    @Override
    public int hashCode() {
        return this.myJobs.hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.myJobs.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.myJobs.isEmpty();
    }

    @Override
    public Iterator<IJob> iterator() {
        return this.myJobs.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.myJobs.lastIndexOf(o);
    }

    @Override
    public ListIterator<IJob> listIterator() {
        return this.myJobs.listIterator();
    }

    @Override
    public ListIterator<IJob> listIterator(int index) {
        return this.myJobs.listIterator(index);
    }

    public boolean offer(IJob e) {
        return this.myJobs.offer(e);
    }

    public boolean offerFirst(IJob e) {
        return this.myJobs.offerFirst(e);
    }

    public boolean offerLast(IJob e) {
        return this.myJobs.offerLast(e);
    }

    public IJob peek() {
        return this.myJobs.peek();
    }

    public IJob peekFirst() {
        return this.myJobs.peekFirst();
    }

    public IJob peekLast() {
        return this.myJobs.peekLast();
    }

    public IJob poll() {
        return this.myJobs.poll();
    }

    public IJob pollFirst() {
        return this.myJobs.pollFirst();
    }

    public IJob pollLast() {
        return this.myJobs.pollLast();
    }

    public IJob pop() {
        return this.myJobs.pop();
    }

    public void push(IJob e) {
        this.myJobs.push(e);
    }

    public IJob remove() {
        return this.myJobs.remove();
    }

    @Override
    public IJob remove(int index) {
        return this.myJobs.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.myJobs.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.myJobs.removeAll(c);
    }

    @Override
    public IJob removeFirst() {
        return this.myJobs.removeFirst();
    }

    public boolean removeFirstOccurrence(Object o) {
        return this.myJobs.removeFirstOccurrence(o);
    }

    @Override
    public IJob removeLast() {
        return this.myJobs.removeLast();
    }

    public boolean removeLastOccurrence(Object o) {
        return this.myJobs.removeLastOccurrence(o);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.myJobs.retainAll(c);
    }

    @Override
    public IJob set(int index, IJob element) {
        return this.myJobs.set(index, element);
    }

    @Override
    public int size() {
        return this.myJobs.size();
    }

    @Override
    public List<IJob> subList(int fromIndex, int toIndex) {
        return this.myJobs.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.myJobs.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.myJobs.toArray(a);
    }

    public String toString() {
        return this.myJobs.toString();
    }
}

