/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.metricspec.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public final class DeserializationUtil {
    public static Object createFromString(String hexString, final ClassLoader loader) {
        if (hexString == null) {
            return null;
        }
        byte[] byteValue = DeserializationUtil.hexStringToBytes(hexString);
        ByteArrayInputStream bytes = new ByteArrayInputStream(byteValue);
        try {
            ObjectInputStream in = new ObjectInputStream(bytes){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    String name = desc.getName();
                    try {
                        return Class.forName(name, false, loader);
                    }
                    catch (ClassNotFoundException ex) {
                        ex.printStackTrace();
                        return null;
                    }
                }
            };
            return in.readObject();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        catch (ClassNotFoundException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static byte[] hexStringToBytes(String initialValue) {
        if (initialValue == null) {
            return null;
        }
        int size = initialValue.length();
        int limit = (size + 1) / 2;
        byte[] result = new byte[limit];
        if (size % 2 != 0) {
            result[--limit] = DeserializationUtil.hexCharToByte(initialValue.charAt(size - 1));
        }
        int i = 0;
        int j = 0;
        while (i < limit) {
            byte high = DeserializationUtil.hexCharToByte(initialValue.charAt(j++));
            byte low = DeserializationUtil.hexCharToByte(initialValue.charAt(j++));
            result[i] = (byte)(high << 4 | low);
            ++i;
        }
        return result;
    }

    private static byte hexCharToByte(char character) {
        switch (character) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return (byte)(character - 48);
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return (byte)(character - 97 + 10);
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return (byte)(character - 65 + 10);
            }
        }
        throw new NumberFormatException("Invalid hexadecimal");
    }
}

