/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework;

import de.uka.ipd.sdq.scheduler.IPassiveResource;
import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import de.uka.ipd.sdq.simucomframework.Context;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.resources.AbstractSimulatedResourceContainer;
import de.uka.ipd.sdq.simucomframework.resources.HashMapAssemblyAllocationLookup;
import de.uka.ipd.sdq.simucomframework.resources.IAssemblyAllocationLookup;
import de.uka.ipd.sdq.simucomframework.resources.SimulatedResourceContainer;
import java.util.HashMap;
import java.util.Map;
import org.palladiosimulator.commons.emfutils.EMFLoadHelper;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;

public abstract class SimuComContext
extends Context {
    private static final long serialVersionUID = 8628196416449895566L;
    private final HashMap<String, IPassiveResource> assemblyPassiveResourceHash = new HashMap();
    private Map<String, AbstractSimulatedResourceContainer> assemblyLinkMap = new HashMap<String, AbstractSimulatedResourceContainer>();
    private IAssemblyAllocationLookup<AbstractSimulatedResourceContainer> assemblyLinkLookup = new HashMapAssemblyAllocationLookup<AbstractSimulatedResourceContainer>(this.assemblyLinkMap);

    public SimuComContext(SimuComModel myModel, IResourceTableManager resourceTableManager) {
        super(myModel, resourceTableManager);
        this.initialiseAssemblyContextLookup();
    }

    protected void linkAssemblyContextAndResourceContainer(String assemblyContextID, String resourceContainerID) {
        assert (this.getSimulatedResourceContainerAccess().getSimulatedEntity((ResourceContainer)resourceContainerID) != null);
        AbstractSimulatedResourceContainer container = this.getSimulatedResourceContainerAccess().getSimulatedEntity((ResourceContainer)resourceContainerID);
        this.assemblyLinkMap.put(assemblyContextID, container);
    }

    public IPassiveResource getPassiveRessourceInContext(String resourceURI, AssemblyContext assemblyContext, AbstractSimulatedResourceContainer resourceContainer, long capacity) {
        PassiveResource resource = (PassiveResource)EMFLoadHelper.loadAndResolveEObject((String)resourceURI);
        IPassiveResource pr = this.assemblyPassiveResourceHash.get(String.valueOf(assemblyContext.getId()) + resource.getId());
        if (pr == null) {
            pr = ((SimulatedResourceContainer)resourceContainer).createPassiveResource(resource, assemblyContext, capacity);
            this.assemblyPassiveResourceHash.put(String.valueOf(assemblyContext.getId()) + resource.getId(), pr);
        }
        return pr;
    }

    protected abstract void initialiseAssemblyContextLookup();

    @Override
    public IAssemblyAllocationLookup<AbstractSimulatedResourceContainer> getAssemblyAllocationLookup() {
        return this.assemblyLinkLookup;
    }
}

