/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework;

import de.uka.ipd.sdq.scheduler.IActiveResource;
import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.LoggingWrapper;
import de.uka.ipd.sdq.scheduler.SchedulerModel;
import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import de.uka.ipd.sdq.scheduler.resources.active.SimDelayResource;
import de.uka.ipd.sdq.simucomframework.exceptions.FailureException;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.simucomstatus.Process;
import de.uka.ipd.sdq.simucomframework.simucomstatus.SimucomstatusFactory;
import de.uka.ipd.sdq.simulation.SimulationResult;
import de.uka.ipd.sdq.simulation.abstractsimengine.AbstractSimProcessDelegator;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimProcess;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimProcessListener;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.palladiosimulator.probeframework.measurement.RequestContext;

public abstract class SimuComSimProcess
extends AbstractSimProcessDelegator
implements ISchedulableProcess,
ISimProcessListener {
    private static AtomicLong sessionID = new AtomicLong(0L);
    protected static final Logger LOGGER = Logger.getLogger((String)SimuComSimProcess.class.getName());
    private Process processStatus = null;
    private SimDelayResource delayResource = null;
    private final boolean isDebug;
    private final List<IActiveResource> removedObservers = new ArrayList<IActiveResource>();
    private final RequestContext requestContext;
    private final ArrayList<IActiveResource> terminatedObservers = new ArrayList();
    protected long currentSessionId;
    private boolean isTimeoutFailure = false;
    private String timeoutFailureTypeId = null;
    private int priority = 0;

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    protected SimuComSimProcess(SimuComModel model, String name, IResourceTableManager resourceTableManager) {
        this(model, name, null, resourceTableManager);
    }

    protected SimuComSimProcess(SimuComModel model, String name, RequestContext parentRequestContext, IResourceTableManager resourceTableManager) {
        super((ISimulationModel)model, name);
        this.isDebug = model.getConfiguration().isDebug();
        this.delayResource = new SimDelayResource((SchedulerModel)model, String.valueOf(name) + "_thinktime", String.valueOf(name) + "_thinktime", resourceTableManager);
        this.requestContext = new RequestContext(Long.valueOf(this.getRawId()).toString(), parentRequestContext);
        this.addProcessListener(this);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Create SimuComSimProcess with id " + this.getRawId() + " [" + this.getId() + "]"));
        }
    }

    public void activate() {
        this.scheduleAt(0.0);
    }

    public void timeout(String timeoutFailureTypeId) {
        this.isTimeoutFailure = true;
        this.timeoutFailureTypeId = timeoutFailureTypeId;
        this.activate();
    }

    protected void addProcessToSimStatus() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Starting simulation process " + this.getId()));
        }
        if (this.isDebug) {
            this.processStatus = SimucomstatusFactory.eINSTANCE.createProcess();
            this.getModel().getSimulationStatus().getProcessStatus().getProcesses().add((Object)this.processStatus);
            this.processStatus.setId(this.getName());
            this.processStatus.setProcessStartTime(this.getModel().getSimulationControl().getCurrentSimulationTime());
        }
    }

    public void addTerminatedObserver(IActiveResource r) {
        if (!this.terminatedObservers.contains(r)) {
            this.terminatedObservers.add(r);
        }
    }

    public void fireTerminated() {
        LoggingWrapper.log((String)("Process " + this.getId() + " terminated."));
        for (IActiveResource activeResource : this.terminatedObservers) {
            activeResource.notifyTerminated((ISchedulableProcess)this);
        }
        this.terminatedObservers.removeAll(this.removedObservers);
        this.removedObservers.clear();
    }

    public long getCurrentSessionId() {
        return this.currentSessionId;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public ISchedulableProcess getRootProcess() {
        return null;
    }

    public Process getSimProcessStatus() {
        return this.processStatus;
    }

    public void hold(double d) {
        this.delayResource.process((ISchedulableProcess)this, 1, Collections.emptyMap(), d);
    }

    protected abstract void internalLifeCycle();

    public boolean isFinished() {
        return this.isTerminated();
    }

    public final void lifeCycle() {
        this.addProcessToSimStatus();
        try {
            this.internalLifeCycle();
        }
        catch (Exception e) {
            String message = e.getMessage();
            String string = message = message == null ? "" : message;
            if (e instanceof IllegalArgumentException && message.contains("Cannot schedule in the past")) {
                if (LOGGER.isEnabledFor((Priority)Level.WARN)) {
                    LOGGER.warn((Object)"Simulation caused an exception because it scheduled in the past. Check your models that you do not have any negative demands, arrival times, or similar", (Throwable)e);
                }
            } else if (LOGGER.isEnabledFor((Priority)Level.WARN)) {
                LOGGER.warn((Object)"Simulation caused an exception. Caught it in SimProcess Lifecycle Method", (Throwable)e);
            }
            this.getModel().setStatus(SimulationResult.ERROR, e);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Trying to stop simulation now...");
            }
            this.getModel().getSimulationControl().stop();
        }
        this.fireTerminated();
        this.removeProcessFromSimStatus();
    }

    protected void removeProcessFromSimStatus() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Terminating SimuComSimProcess " + this.getName()));
        }
        if (this.isDebug) {
            this.getModel().getSimulationStatus().getProcessStatus().getProcesses().remove((Object)this.processStatus);
        }
    }

    public void removeTerminatedObserver(IActiveResource r) {
        this.removedObservers.remove(r);
    }

    protected void updateNewSessionID() {
        this.currentSessionId = sessionID.incrementAndGet();
    }

    public void notifyResuming(ISimProcess process) {
        if (this.isTimeoutFailure) {
            this.isTimeoutFailure = false;
            FailureException.raise(this.getModel(), this.getModel().getFailureStatistics().getFailureType(this.timeoutFailureTypeId));
        }
    }

    public void notifySuspending(ISimProcess process) {
    }

    public void notifyTerminated(ISimProcess process) {
    }

    public SimuComModel getModel() {
        return (SimuComModel)super.getModel();
    }
}

