/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.calculator;

import java.util.HashMap;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.measurementframework.listener.IMeasurementSourceListener;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.probeframework.calculator.Calculator;
import org.palladiosimulator.probeframework.calculator.CalculatorProbeSet;
import org.palladiosimulator.probeframework.calculator.IGenericCalculatorFactory;
import org.palladiosimulator.recorderframework.IRecorder;
import org.palladiosimulator.recorderframework.config.IRecorderConfiguration;
import org.palladiosimulator.recorderframework.config.IRecorderConfigurationFactory;
import org.palladiosimulator.recorderframework.utils.RecorderExtensionHelper;

public class RecorderAttachingCalculatorFactoryDecorator
implements IGenericCalculatorFactory {
    private final IGenericCalculatorFactory decoratedCalculatorFactory;
    private final String recorderName;
    private final IRecorderConfigurationFactory configurationFactory;

    public RecorderAttachingCalculatorFactoryDecorator(IGenericCalculatorFactory decoratedCalculatorFactory, String recorderName, IRecorderConfigurationFactory configurationFactory) {
        this.decoratedCalculatorFactory = decoratedCalculatorFactory;
        this.recorderName = recorderName;
        this.configurationFactory = configurationFactory;
    }

    public Calculator buildCalculator(MetricDescription metric, MeasuringPoint measuringPoint, CalculatorProbeSet probeConfiguration) {
        return this.setupRecorder(this.decoratedCalculatorFactory.buildCalculator(metric, measuringPoint, probeConfiguration));
    }

    private Calculator setupRecorder(Calculator calculator) {
        HashMap<String, Object> recorderConfigurationMap = new HashMap<String, Object>();
        recorderConfigurationMap.put("recorderAcceptedMetric", calculator.getMetricDesciption());
        recorderConfigurationMap.put("measuringPoint", calculator.getMeasuringPoint());
        IRecorder recorder = RecorderExtensionHelper.instantiateRecorderImplementationForRecorder((String)this.recorderName);
        IRecorderConfiguration recorderConfiguration = this.configurationFactory.createRecorderConfiguration(recorderConfigurationMap);
        recorder.initialize(recorderConfiguration);
        calculator.addObserver((IMeasurementSourceListener)recorder);
        return calculator;
    }
}

