/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.fork;

import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import de.uka.ipd.sdq.simucomframework.Context;
import de.uka.ipd.sdq.simucomframework.SimuComContext;
import de.uka.ipd.sdq.simucomframework.SimuComSimProcess;
import de.uka.ipd.sdq.simucomframework.fork.ForkContext;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimProcess;
import org.apache.log4j.Logger;

public abstract class ForkedBehaviourProcess
extends SimuComSimProcess {
    private static final Logger LOGGER = Logger.getLogger((String)ForkedBehaviourProcess.class.getName());
    protected final SimuComContext forkContext;
    protected final String assemblyContextID;
    private final ISimProcess parentProcess;
    private final boolean isAsync;
    private boolean isTerminated = false;

    public ForkedBehaviourProcess(Context context, String assemblyContextID, boolean isAsync, IResourceTableManager resourceTableManager) {
        super(context.getModel(), "Forked Behaviour", context.getThread().getRequestContext(), resourceTableManager);
        this.currentSessionId = context.getThread().getCurrentSessionId();
        this.forkContext = this.createForkContext(context);
        this.parentProcess = context.getThread();
        this.assemblyContextID = assemblyContextID;
        this.isAsync = isAsync;
    }

    protected SimuComContext createForkContext(Context context) {
        return new ForkContext(context, this);
    }

    public ForkedBehaviourProcess(Context context, String assemblyContextID, boolean isAsync, int priority, IResourceTableManager resourceTableManager) {
        this(context, assemblyContextID, isAsync, resourceTableManager);
        this.setPriority(priority);
    }

    @Override
    protected void internalLifeCycle() {
        this.executeBehaviour();
        this.isTerminated = true;
        if (!this.isAsync && !this.parentProcess.isTerminated() && this.simulationIsRunning()) {
            this.parentProcess.scheduleAt(0.0);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Asynch behaviour finished at simtime " + this.getModel().getSimulationControl().getCurrentSimulationTime()));
        }
    }

    private boolean simulationIsRunning() {
        return this.forkContext.getModel().getSimulationControl().isRunning();
    }

    protected abstract void executeBehaviour();

    public boolean isAsync() {
        return this.isAsync;
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }
}

