/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.model;

import de.uka.ipd.sdq.errorhandling.SeverityAndIssue;
import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import de.uka.ipd.sdq.probfunction.math.impl.ProbabilityFunctionFactoryImpl;
import de.uka.ipd.sdq.scheduler.ISchedulingFactory;
import de.uka.ipd.sdq.scheduler.SchedulerModel;
import de.uka.ipd.sdq.scheduler.factory.SchedulingFactory;
import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import de.uka.ipd.sdq.simucomframework.ResourceRegistry;
import de.uka.ipd.sdq.simucomframework.SimuComConfig;
import de.uka.ipd.sdq.simucomframework.calculator.RecorderAttachingCalculatorFactoryDecorator;
import de.uka.ipd.sdq.simucomframework.resources.AbstractSimulatedResourceContainer;
import de.uka.ipd.sdq.simucomframework.resources.IResourceContainerFactory;
import de.uka.ipd.sdq.simucomframework.resources.SimulatedLinkingResourceContainer;
import de.uka.ipd.sdq.simucomframework.resources.SimulatedResourceContainer;
import de.uka.ipd.sdq.simucomframework.simucomstatus.Action;
import de.uka.ipd.sdq.simucomframework.simucomstatus.Process;
import de.uka.ipd.sdq.simucomframework.simucomstatus.SimuComStatus;
import de.uka.ipd.sdq.simucomframework.simucomstatus.SimucomstatusPackage;
import de.uka.ipd.sdq.simucomframework.usage.IWorkloadDriver;
import de.uka.ipd.sdq.simucomframework.variables.cache.StoExCache;
import de.uka.ipd.sdq.simulation.ISimulationListener;
import de.uka.ipd.sdq.simulation.SimulationResult;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimEngineFactory;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationControl;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.palladiosimulator.probeframework.ProbeFrameworkContext;
import org.palladiosimulator.probeframework.calculator.ExtensibleCalculatorFactoryDelegatingFactory;
import org.palladiosimulator.probeframework.calculator.IGenericCalculatorFactory;
import org.palladiosimulator.reliability.FailureStatistics;

public class SimuComModel
extends SchedulerModel {
    protected static final Logger LOGGER = Logger.getLogger(SimuComModel.class);
    protected ResourceRegistry resourceRegistry;
    private Collection<IWorkloadDriver> workloadDrivers;
    private SimulationResult status = SimulationResult.OK;
    private Throwable errorMessage;
    private final SimuComConfig config;
    private long mainMeasurementsCount;
    private ISimEngineFactory simulationEngineFactory;
    private ISimulationControl simControl;
    private final SimuComStatus simulationStatus;
    private List<SeverityAndIssue> issues;
    private final ProbeFrameworkContext probeFrameworkContext;
    private final ISchedulingFactory schedulingFactory;
    private final FailureStatistics failureStatistics = new FailureStatistics();

    @Deprecated
    public SimuComModel(SimuComConfig config, SimuComStatus status, ISimEngineFactory factory, boolean isRemoteRun, IResourceTableManager resourceTableManager) {
        this(config, status, factory, isRemoteRun, null, resourceTableManager);
    }

    @Deprecated
    public SimuComModel(SimuComConfig config, SimuComStatus status, ISimEngineFactory factory, boolean isRemoteRun, ProbeFrameworkContext probeFrameworkContext, IResourceTableManager resourceTableManager) {
        this(config, status, factory, isRemoteRun, probeFrameworkContext, resourceTableManager, null);
    }

    public SimuComModel(SimuComConfig config, SimuComStatus status, ISimEngineFactory factory, boolean isRemoteRun, ProbeFrameworkContext probeFrameworkContext, IResourceTableManager resourceTableManager, ResourceRegistry resourceRegistry) {
        this.config = config;
        this.simulationEngineFactory = factory;
        factory.setModel((ISimulationModel)this);
        this.simControl = factory.createSimulationControl();
        this.resourceRegistry = resourceRegistry == null ? new ResourceRegistry(this) : resourceRegistry;
        this.simulationStatus = status;
        this.issues = new ArrayList<SeverityAndIssue>();
        this.workloadDrivers = new ArrayList<IWorkloadDriver>();
        ProbabilityFunctionFactoryImpl probFunctionFactory = ProbabilityFunctionFactoryImpl.getInstance();
        probFunctionFactory.setRandomGenerator(config.getRandomGenerator());
        StoExCache.initialiseStoExCache((IProbabilityFunctionFactory)probFunctionFactory);
        this.schedulingFactory = new SchedulingFactory((SchedulerModel)this, resourceTableManager);
        this.probeFrameworkContext = probeFrameworkContext == null ? this.initialiseProbeFramework() : probeFrameworkContext;
        this.initialiseSimStatus();
    }

    private ProbeFrameworkContext initialiseProbeFramework() {
        ProbeFrameworkContext result = new ProbeFrameworkContext((IGenericCalculatorFactory)new RecorderAttachingCalculatorFactoryDecorator((IGenericCalculatorFactory)new ExtensibleCalculatorFactoryDelegatingFactory(), this.config.getRecorderName(), this.config.getRecorderConfigurationFactory()));
        return result;
    }

    public List<SeverityAndIssue> getIssues() {
        return this.issues;
    }

    public void setIssues(List<SeverityAndIssue> issues) {
        if (issues == null) {
            throw new IllegalArgumentException("issues must not be null. Create and provide an empty list if the list should be reset.");
        }
        this.issues = issues;
    }

    public void addIssue(SeverityAndIssue issue) {
        this.issues.add(issue);
    }

    private void initialiseSimStatus() {
        if (this.config.getVerboseLogging()) {
            EContentAdapter contentAdapter = new EContentAdapter(){

                public void notifyChanged(Notification notification) {
                    super.notifyChanged(notification);
                    if (notification.getEventType() == 1) {
                        if (notification.getFeature() == SimucomstatusPackage.eINSTANCE.getProcess_CurrentAction()) {
                            Process p = (Process)notification.getNotifier();
                            Action a = (Action)notification.getNewValue();
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug((Object)("Process " + p.getId() + " changed currentAction to " + a.getClass().getName()));
                            }
                        }
                    } else if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"Simulation Status Updated");
                    }
                }
            };
            this.simulationStatus.eAdapters().add((Object)contentAdapter);
        }
    }

    public void init() {
        this.notifyStartListeners();
        for (IWorkloadDriver w : this.workloadDrivers) {
            w.run();
        }
    }

    public Collection<IWorkloadDriver> getUsageScenarios() {
        return this.workloadDrivers;
    }

    public void setUsageScenarios(IWorkloadDriver[] workload) {
        this.workloadDrivers.addAll(Arrays.asList(workload));
    }

    public ResourceRegistry getResourceRegistry() {
        return this.resourceRegistry;
    }

    public void initialiseResourceContainer(IResourceContainerFactory resourceContainerFactory) {
        AbstractSimulatedResourceContainer rc;
        String id;
        String[] stringArray = resourceContainerFactory.getResourceContainerIDList();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            id = stringArray[n2];
            rc = (SimulatedResourceContainer)this.resourceRegistry.createResourceContainer(id);
            resourceContainerFactory.fillResourceContainerWithResources((SimulatedResourceContainer)rc);
            ++n2;
        }
        stringArray = resourceContainerFactory.getResourceContainerIDList();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            id = stringArray[n2];
            rc = (SimulatedResourceContainer)this.resourceRegistry.getResourceContainer(id);
            resourceContainerFactory.fillResourceContainerWithNestedResourceContainers((SimulatedResourceContainer)rc);
            ++n2;
        }
        stringArray = resourceContainerFactory.getLinkingResourceContainerIDList();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            id = stringArray[n2];
            rc = (SimulatedLinkingResourceContainer)this.resourceRegistry.createLinkingResourceContainer(id);
            resourceContainerFactory.fillLinkingResourceContainer((SimulatedLinkingResourceContainer)rc);
            ++n2;
        }
        this.resourceRegistry.activateAllActiveResources();
    }

    public void setStatus(SimulationResult error, Throwable t) {
        this.status = error;
        this.errorMessage = t;
    }

    public SimulationResult getErrorStatus() {
        return this.status;
    }

    public Throwable getErrorThrowable() {
        return this.errorMessage;
    }

    public SimuComConfig getConfig() {
        return this.config;
    }

    public void increaseMainMeasurementsCount() {
        ++this.mainMeasurementsCount;
    }

    public long getMainMeasurementsCount() {
        return this.mainMeasurementsCount;
    }

    public ISimulationControl getSimulationControl() {
        return this.simControl;
    }

    public void setSimulationControl(ISimulationControl control) {
        this.simControl = control;
    }

    public void setSimulationEngineFactory(ISimEngineFactory factory) {
        this.simulationEngineFactory = factory;
    }

    public ISimEngineFactory getSimEngineFactory() {
        return this.simulationEngineFactory;
    }

    public SimuComStatus getSimulationStatus() {
        return this.simulationStatus;
    }

    public ProbeFrameworkContext getProbeFrameworkContext() {
        return this.probeFrameworkContext;
    }

    public ISchedulingFactory getSchedulingFactory() {
        return this.schedulingFactory;
    }

    public void finalise() {
        this.notifyStopListeners();
        this.getResourceRegistry().deactivateAllActiveResources();
        this.getResourceRegistry().deactivateAllPassiveResources();
        if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
            LOGGER.info((Object)("Simulation took " + this.getSimulationControl().getCurrentSimulationTime() + " simulated time units"));
        }
        this.schedulingFactory.cleanActiveResources();
        if (this.getConfiguration().getSimulateFailures()) {
            this.getFailureStatistics().printFailureStatistics(LOGGER, this.getSimulationControl().getCurrentSimulationTime());
        }
    }

    public SimuComConfig getConfiguration() {
        return this.config;
    }

    private void notifyStartListeners() {
        for (ISimulationListener l : this.config.getListeners()) {
            l.simulationStart();
        }
    }

    private void notifyStopListeners() {
        for (ISimulationListener l : this.config.getListeners()) {
            l.simulationStop();
        }
    }

    public FailureStatistics getFailureStatistics() {
        return this.failureStatistics;
    }
}

