/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.resources;

import de.uka.ipd.sdq.simucomframework.Context;
import de.uka.ipd.sdq.simucomframework.SimuComSimProcess;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.resources.ScheduledResource;
import java.io.Serializable;
import java.util.Map;
import org.apache.log4j.Logger;
import org.palladiosimulator.pcm.resourceenvironment.HDDProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;

public class HDDResource
extends ScheduledResource {
    private final int READ_SERVICE_ID = 1;
    private final int WRITE_SERVICE_ID = 2;
    private final HDDProcessingResourceSpecification hddResource;
    private static final Logger LOGGER = Logger.getLogger(HDDResource.class);

    public HDDResource(HDDProcessingResourceSpecification activeResource, SimuComModel myModel, String resourceContainerID, String schedulingStrategyID) {
        super((ProcessingResourceSpecification)activeResource, myModel, resourceContainerID, schedulingStrategyID);
        this.hddResource = activeResource;
    }

    @Override
    public void consumeResource(SimuComSimProcess process, int resourceServiceID, Map<String, Serializable> parameterMap, double abstractDemand) {
        double currentDemand = -1.0;
        switch (resourceServiceID) {
            case 1: {
                currentDemand = abstractDemand / (Double)Context.evaluateStatic((String)this.hddResource.getReadProcessingRate().getSpecification(), Double.class);
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug((Object)("CALCULATED READ DEMAND: " + currentDemand + " FROM BYTES: " + abstractDemand));
                break;
            }
            case 2: {
                currentDemand = abstractDemand / (Double)Context.evaluateStatic((String)this.hddResource.getWriteProcessingRate().getSpecification(), Double.class);
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug((Object)("CALCULATED WRITE DEMAND: " + currentDemand + " FROM BYTES: " + abstractDemand));
                break;
            }
            default: {
                throw new RuntimeException("HDD Resource called without explicit read/write call");
            }
        }
        super.consumeResource(process, resourceServiceID, parameterMap, currentDemand);
    }
}

