/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.resources;

import de.uka.ipd.sdq.scheduler.IActiveResource;
import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.simucomframework.Context;
import de.uka.ipd.sdq.simucomframework.SimuComSimProcess;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.resources.AbstractScheduledResource;
import de.uka.ipd.sdq.simucomframework.resources.ResourceFailedEvent;
import de.uka.ipd.sdq.simucomframework.resources.ResourceRepairedEvent;
import de.uka.ipd.sdq.simucomframework.resources.SimuComExtensionResource;
import de.uka.ipd.sdq.simulation.abstractsimengine.IEntity;
import org.apache.log4j.Logger;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;

public class ScheduledResource
extends AbstractScheduledResource {
    private static final Logger LOGGER = Logger.getLogger((String)ScheduledResource.class.getName());
    private final ProcessingResourceSpecification activeResource;
    private static long resourceId = 1L;
    private String processingRate;
    private final double mttf;
    private final double mttr;
    protected final boolean canBeUnavailable;
    private ResourceFailedEvent failedEvent;
    private ResourceRepairedEvent repairedEvent;

    public ScheduledResource(ProcessingResourceSpecification activeResource, SimuComModel myModel, String resourceContainerID, String schedulingStrategyID) {
        super(myModel, activeResource.getId(), resourceContainerID, activeResource.getActiveResourceType_ActiveResourceSpecification().getId(), String.valueOf(activeResource.getResourceContainer_ProcessingResourceSpecification().getEntityName()) + " [" + activeResource.getActiveResourceType_ActiveResourceSpecification().getEntityName() + "] <" + activeResource.getResourceContainer_ProcessingResourceSpecification().getId() + ">", schedulingStrategyID, activeResource.getNumberOfReplicas(), activeResource.isRequiredByContainer());
        this.activeResource = activeResource;
        this.processingRate = activeResource.getProcessingRate_ProcessingResourceSpecification().getSpecification();
        this.mttf = activeResource.getMTTF();
        this.mttr = activeResource.getMTTR();
        boolean bl = this.canBeUnavailable = myModel.getConfiguration().getSimulateFailures() && this.mttf > 0.0 && this.mttr > 0.0;
        if (this.canBeUnavailable) {
            this.createAvailabilityEvents(myModel);
        }
    }

    private void createAvailabilityEvents(SimuComModel model) {
        this.failedEvent = new ResourceFailedEvent(model, "ResourceFailed");
        this.repairedEvent = new ResourceRepairedEvent(model, "ResourceRepaired");
        this.failedEvent.setRepairedEvent(this.repairedEvent);
        this.repairedEvent.setFailedEvent(this.failedEvent);
    }

    @Override
    protected IActiveResource createActiveResource(SimuComModel myModel) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Creating scheduled resource with strategy " + this.getSchedulingStrategyID() + " and " + this.getNumberOfInstances() + " replicas!"));
        }
        IActiveResource aResource = this.getScheduledResource(myModel, "Utilisation of " + this.getName() + " " + this.getDescription());
        return aResource;
    }

    private IActiveResource getScheduledResource(SimuComModel simuComModel, String sensorDescription) {
        IActiveResource scheduledResource = null;
        scheduledResource = this.getSchedulingStrategyID().equals("FCFS") ? this.getModel().getSchedulingFactory().createSimFCFSResource("FCFS", ScheduledResource.getNextResourceId()) : (this.getSchedulingStrategyID().equals("PROCESSOR_SHARING") ? this.getModel().getSchedulingFactory().createSimProcessorSharingResource("PROCESSOR_SHARING", ScheduledResource.getNextResourceId(), (long)this.getNumberOfInstances()) : (this.getSchedulingStrategyID().equals("DELAY") ? this.getModel().getSchedulingFactory().createSimDelayResource("DELAY", ScheduledResource.getNextResourceId()) : this.getModel().getSchedulingFactory().createResourceFromExtension(this.getSchedulingStrategyID(), ScheduledResource.getNextResourceId(), (long)this.getNumberOfInstances())));
        if (scheduledResource instanceof SimuComExtensionResource) {
            ((SimuComExtensionResource)scheduledResource).initialize(simuComModel);
        }
        return scheduledResource;
    }

    @Override
    protected double calculateDemand(double demand) {
        return demand / (Double)Context.evaluateStatic((String)this.processingRate, Double.class);
    }

    @Override
    public void activateResource() {
        this.getUnderlyingResource().start();
        super.activateResource();
        if (this.canBeUnavailable) {
            double t = this.getFailureTime();
            this.failedEvent.schedule((IEntity)this, t);
        }
    }

    @Override
    public double getRemainingDemandForProcess(SimuComSimProcess thread) {
        return this.getUnderlyingResource().getRemainingDemand((ISchedulableProcess)thread);
    }

    @Override
    public void updateDemand(SimuComSimProcess thread, double demand) {
        this.getUnderlyingResource().updateDemand((ISchedulableProcess)thread, demand);
    }

    @Override
    public void deactivateResource() {
        super.deactivateResource();
        if (this.canBeUnavailable) {
            this.failedEvent.removeEvent();
            this.repairedEvent.removeEvent();
        }
        this.fireOverallUtilization(0.0, 0.0);
        this.getUnderlyingResource().stop();
    }

    public static String getNextResourceId() {
        return Long.toString(resourceId++);
    }

    @Override
    public IActiveResource getScheduledResource() {
        return this.getUnderlyingResource();
    }

    public void setProcessingRate(String newProcessingRate) {
        this.processingRate = newProcessingRate;
    }

    public ProcessingResourceSpecification getActiveResource() {
        return this.activeResource;
    }

    public double getFailureTime() {
        if (!this.canBeUnavailable) {
            throw new RuntimeException("getFailureTime() should not be invoked as resource cannot fail");
        }
        double failureTimeSample = (Double)Context.evaluateStatic((String)("Exp(1 / (" + this.mttf + ")" + ")"), Double.class);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Resource " + this.getDescription() + " will fail at sim time +" + failureTimeSample));
        }
        return failureTimeSample;
    }

    public double getRepairTime() {
        if (!this.canBeUnavailable) {
            throw new RuntimeException("getRepairTime() should not be invoked as resource cannot fail");
        }
        double repairTimeSample = (Double)Context.evaluateStatic((String)("Exp(1/" + this.mttr + ")"), Double.class);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Resource " + this.getDescription() + " will be repaired at sim time +" + repairTimeSample));
        }
        return repairTimeSample;
    }

    @Override
    public void update(long state, int instanceId) {
        super.update(state, instanceId);
        this.fireOverallUtilization(0.0, 0.0);
    }
}

