/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.usage;

import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.probes.TakeCurrentSimulationTimeProbe;
import de.uka.ipd.sdq.simucomframework.usage.IUserFactory;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationTimeProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.commons.emfutils.EMFLoadHelper;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPointRepository;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringpointFactory;
import org.palladiosimulator.edp2.models.measuringpoint.ResourceURIMeasuringPoint;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.pcmmeasuringpoint.PcmmeasuringpointFactory;
import org.palladiosimulator.pcmmeasuringpoint.UsageScenarioMeasuringPoint;
import org.palladiosimulator.probeframework.calculator.Calculator;
import org.palladiosimulator.probeframework.calculator.ICalculatorFactory;
import org.palladiosimulator.probeframework.probes.Probe;

public abstract class AbstractWorkloadUserFactory
implements IUserFactory {
    protected final List<Probe> usageStartStopProbes;
    private final UsageScenario usageScenario;
    protected final SimuComModel model;
    private final ICalculatorFactory calculatorFactory;
    private static final MeasuringpointFactory MEASURINGPOINT_FACTORY = MeasuringpointFactory.eINSTANCE;
    private static final PcmmeasuringpointFactory PCM_MEASURINGPOINT_FACTORY = PcmmeasuringpointFactory.eINSTANCE;

    public AbstractWorkloadUserFactory(SimuComModel model, UsageScenario usageScenario) {
        this.model = model;
        this.calculatorFactory = model.getProbeFrameworkContext().getCalculatorFactory();
        this.usageScenario = usageScenario;
        this.usageStartStopProbes = Collections.unmodifiableList(Arrays.asList(new Probe[]{new TakeCurrentSimulationTimeProbe((ISimulationTimeProvider)model.getSimulationControl()), new TakeCurrentSimulationTimeProbe((ISimulationTimeProvider)model.getSimulationControl())}));
    }

    @Override
    public Calculator attachResponseTimeCalculator() {
        UsageScenarioMeasuringPoint mp = PCM_MEASURINGPOINT_FACTORY.createUsageScenarioMeasuringPoint();
        mp.setUsageScenario(this.usageScenario);
        ResourceURIMeasuringPoint measuringPoint = MEASURINGPOINT_FACTORY.createResourceURIMeasuringPoint();
        measuringPoint.setResourceURI(EMFLoadHelper.getResourceURI((EObject)this.usageScenario));
        measuringPoint.setMeasuringPoint(mp.getStringRepresentation());
        MeasuringPointRepository myMeasurementPointRepository = MEASURINGPOINT_FACTORY.createMeasuringPointRepository();
        myMeasurementPointRepository.getMeasuringPoints().add((Object)mp);
        myMeasurementPointRepository.getMeasuringPoints().add((Object)measuringPoint);
        mp.setMeasuringPointRepository(myMeasurementPointRepository);
        measuringPoint.setMeasuringPointRepository(myMeasurementPointRepository);
        return this.calculatorFactory.buildResponseTimeCalculator((MeasuringPoint)measuringPoint, this.usageStartStopProbes);
    }
}

