/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.usage;

import de.uka.ipd.sdq.simucomframework.usage.ClosedWorkloadUser;
import de.uka.ipd.sdq.simucomframework.usage.ICancellableWorkloadDriver;
import de.uka.ipd.sdq.simucomframework.usage.IClosedWorkloadUserFactory;
import de.uka.ipd.sdq.simucomframework.usage.IUserFactory;
import java.util.LinkedList;
import java.util.Queue;

public class ClosedWorkload
implements ICancellableWorkloadDriver {
    private final int population;
    private final IClosedWorkloadUserFactory userFactory;
    private final Queue<ClosedWorkloadUser> users;
    private String newThinkTime = null;

    public ClosedWorkload(IClosedWorkloadUserFactory userFactory, int population) {
        this.userFactory = userFactory;
        this.population = population;
        this.users = new LinkedList<ClosedWorkloadUser>();
    }

    @Override
    public void run() {
        this.startUsers(this.population);
    }

    @Override
    public void cancel() {
        this.setPopulation(0);
    }

    @Override
    public IUserFactory getUserFactory() {
        return this.userFactory;
    }

    public void setPopulation(int newPopulation) {
        if (this.users.size() > newPopulation) {
            this.stopUsers(this.users.size() - newPopulation);
        } else if (this.users.size() < newPopulation) {
            this.startUsers(newPopulation - this.users.size());
        }
    }

    private void stopUsers(int count) {
        int i = 0;
        while (i < count) {
            ClosedWorkloadUser user = this.users.poll();
            user.requestStop();
            ++i;
        }
    }

    private void startUsers(int count) {
        int i = 0;
        while (i < count) {
            ClosedWorkloadUser user = this.userFactory.createUser();
            user.startUserLife();
            this.users.add(user);
            ++i;
        }
    }

    public void setThinkTime(String newThinkTime) {
        this.userFactory.setThinkTimeSpec(newThinkTime);
        for (ClosedWorkloadUser user : this.users) {
            user.setThinkTime(newThinkTime);
        }
    }
}

