/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.usage;

import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import de.uka.ipd.sdq.simucomframework.Context;
import de.uka.ipd.sdq.simucomframework.SimuComSimProcess;
import de.uka.ipd.sdq.simucomframework.exceptions.FailureException;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.usage.IScenarioRunner;
import de.uka.ipd.sdq.simucomframework.usage.IUser;
import java.util.List;
import org.apache.log4j.Logger;
import org.palladiosimulator.probeframework.measurement.RequestContext;
import org.palladiosimulator.probeframework.probes.Probe;
import org.palladiosimulator.probeframework.probes.TriggeredProbe;

public class ClosedWorkloadUser
extends SimuComSimProcess
implements IUser {
    private static final Logger LOGGER = Logger.getLogger((String)ClosedWorkloadUser.class.getName());
    private final IScenarioRunner scenarioRunner;
    private String thinkTime;
    private int runCount = 0;
    private final List<Probe> usageStartStopProbes;
    protected long sessionId;
    private boolean requestStop = false;

    public ClosedWorkloadUser(SimuComModel owner, String name, IScenarioRunner scenarioRunner, String thinkTimeSpec, List<Probe> usageStartStopProbes, IResourceTableManager resourceTableManager) {
        super(owner, name, resourceTableManager);
        this.scenarioRunner = scenarioRunner;
        this.thinkTime = thinkTimeSpec;
        this.usageStartStopProbes = usageStartStopProbes;
    }

    @Override
    protected void internalLifeCycle() {
        while (!this.requestStop && this.getModel().getSimulationControl().isRunning()) {
            this.updateNewSessionID();
            try {
                try {
                    if (this.getModel().getConfiguration().getSimulateFailures()) {
                        this.getModel().getFailureStatistics().increaseRunCount();
                        if (this.getModel().getConfiguration().isDebug()) {
                            this.getModel().getFailureStatistics().printRunCount(LOGGER, this.getModel().getSimulationControl().getCurrentSimulationTime());
                        }
                    }
                    this.scenarioRunner(this);
                    if (this.getModel().getConfiguration().getSimulateFailures()) {
                        this.getModel().getFailureStatistics().recordSuccess();
                    }
                }
                catch (FailureException exception) {
                    if (this.getModel().getConfiguration().getSimulateFailures()) {
                        this.getModel().getFailureStatistics().increaseUnhandledFailureCounter(exception.getFailureType(), Long.valueOf(this.currentSessionId));
                    }
                    this.getModel().increaseMainMeasurementsCount();
                    ++this.runCount;
                    continue;
                }
            }
            catch (Throwable throwable) {
                this.getModel().increaseMainMeasurementsCount();
                ++this.runCount;
                throw throwable;
            }
            this.getModel().increaseMainMeasurementsCount();
            ++this.runCount;
        }
    }

    @Override
    public void scenarioRunner(SimuComSimProcess thread) {
        ((TriggeredProbe)this.usageStartStopProbes.get(0)).takeMeasurement(this.getRequestContext());
        this.scenarioRunner.scenarioRunner(thread);
        ((TriggeredProbe)this.usageStartStopProbes.get(1)).takeMeasurement(this.getRequestContext());
        double thinkTimeEvaluation = (Double)Context.evaluateStatic((String)this.thinkTime, Double.class, null);
        this.hold(thinkTimeEvaluation);
    }

    @Override
    public void startUserLife() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(String.valueOf(this.getName()) + " started! I'm alive!!!"));
        }
        this.scheduleAt(0.0);
    }

    @Override
    public RequestContext getRequestContext() {
        return super.getRequestContext().append("." + this.runCount);
    }

    public void requestStop() {
        this.requestStop = true;
    }

    public void setThinkTime(String newThinkTimeSpec) {
        this.thinkTime = newThinkTimeSpec;
    }
}

