/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.usage;

import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import de.uka.ipd.sdq.simucomframework.SimuComSimProcess;
import de.uka.ipd.sdq.simucomframework.exceptions.FailureException;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.usage.IScenarioRunner;
import de.uka.ipd.sdq.simucomframework.usage.IUser;
import java.util.List;
import org.palladiosimulator.probeframework.probes.Probe;
import org.palladiosimulator.probeframework.probes.TriggeredProbe;

public class OpenWorkloadUser
extends SimuComSimProcess
implements IUser {
    private final IScenarioRunner scenarioRunner;
    private final List<Probe> usageStartStopProbes;

    public OpenWorkloadUser(SimuComModel owner, String name, IScenarioRunner scenarioRunner, List<Probe> usageStartStopProbes, IResourceTableManager resourceTableManager) {
        super(owner, name, resourceTableManager);
        this.scenarioRunner = scenarioRunner;
        this.usageStartStopProbes = usageStartStopProbes;
    }

    @Override
    protected void internalLifeCycle() {
        block9: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(String.valueOf(this.getName()) + " started! I'm alive!!!"));
            }
            this.updateNewSessionID();
            try {
                try {
                    ((TriggeredProbe)this.usageStartStopProbes.get(0)).takeMeasurement(this.getRequestContext());
                    this.scenarioRunner(this);
                    ((TriggeredProbe)this.usageStartStopProbes.get(1)).takeMeasurement(this.getRequestContext());
                    if (this.getModel().getConfiguration().getSimulateFailures()) {
                        this.getModel().getFailureStatistics().recordSuccess();
                    }
                }
                catch (FailureException exception) {
                    if (this.getModel().getConfiguration().getSimulateFailures()) {
                        this.getModel().getFailureStatistics().increaseUnhandledFailureCounter(exception.getFailureType(), Long.valueOf(this.currentSessionId));
                    }
                    this.getModel().increaseMainMeasurementsCount();
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.getModel().increaseMainMeasurementsCount();
                throw throwable;
            }
            this.getModel().increaseMainMeasurementsCount();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(String.valueOf(this.getName()) + " done! I'm dying!!!"));
        }
    }

    @Override
    public void scenarioRunner(SimuComSimProcess thread) {
        this.scenarioRunner.scenarioRunner(thread);
    }

    @Override
    public void startUserLife() {
        this.scheduleAt(0.0);
    }
}

