/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.ecoreworkflow.mwe2lib.component;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent2;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import tools.mdsd.ecoreworkflow.mwe2lib.component.GapPatternFolderSet;

public class GapPatternPostProcessor
extends AbstractWorkflowComponent2 {
    private static final String JAVAFILE_MATCHER_PATTERN = "([^\\n\\s]*).java$";
    private static final Log LOG = LogFactory.getLog(GapPatternPostProcessor.class);
    private final Collection<GapPatternFolderSet> folders = new LinkedList<GapPatternFolderSet>();
    private String searchPattern = "(?<!\\bnew\\W)\\b(%s)(?=[^a-zA-Z\\d_$])(?!\\W+eINSTANCE\\b)";
    private String replacementPattern = "$1Gen";
    protected URIConverter uriConverter = new ExtensibleURIConverterImpl();
    private Charset charset = StandardCharsets.UTF_8;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void addFolders(GapPatternFolderSet folders) {
        this.folders.add(folders);
    }

    public void setSearchPattern(String searchPattern) {
        this.searchPattern = searchPattern;
    }

    public void setReplacementPattern(String replacementPattern) {
        this.replacementPattern = replacementPattern;
    }

    protected void invokeInternal(WorkflowContext arg0, ProgressMonitor arg1, Issues arg2) {
        arg1.beginTask("Starting Gap-Pattern post processing", this.folders.size());
        for (GapPatternFolderSet set : this.folders) {
            try {
                List manualFolders = set.getManualSourceFolders().stream().map(URI::createURI).map(this::convertUri).map(string -> Paths.get(string, new String[0])).collect(Collectors.toList());
                List generatedFolders = set.getGeneratedSourceFolders().stream().map(URI::createURI).map(this::convertUri).map(string -> Paths.get(string, new String[0])).collect(Collectors.toList());
                final LinkedList relativePathsToCheck = new LinkedList();
                for (final java.nio.file.Path manFolder : manualFolders) {
                    Files.walkFileTree(manFolder, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                        @Override
                        public FileVisitResult visitFile(java.nio.file.Path arg0, BasicFileAttributes arg1) throws IOException {
                            relativePathsToCheck.add(manFolder.relativize(arg0));
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                final LinkedList filesToPostProcess = new LinkedList();
                for (final java.nio.file.Path genFolder : generatedFolders) {
                    Files.walkFileTree(genFolder, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                        @Override
                        public FileVisitResult visitFile(java.nio.file.Path arg0, BasicFileAttributes arg1) throws IOException {
                            java.nio.file.Path relPath = genFolder.relativize(arg0);
                            if (relativePathsToCheck.contains(relPath)) {
                                filesToPostProcess.add(genFolder.resolve(relPath));
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                for (java.nio.file.Path processFile : filesToPostProcess) {
                    String oldClassName = processFile.getFileName().toString().replaceAll(".java", "");
                    String className = processFile.getFileName().toString().replaceAll(JAVAFILE_MATCHER_PATTERN, this.replacementPattern);
                    java.nio.file.Path targetPath = processFile.getParent().resolve(Paths.get(String.valueOf(className) + ".java", new String[0]));
                    LOG.info((Object)String.format("Renaming %s to %s", processFile.toString(), targetPath.toString()));
                    Files.move(processFile, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    String content = new String(Files.readAllBytes(targetPath), this.charset);
                    content = content.replaceAll(String.format(this.searchPattern, oldClassName), this.replacementPattern);
                    Files.write(targetPath, content.getBytes(this.charset), new OpenOption[0]);
                }
                arg1.worked(1);
            }
            catch (IOException e) {
                arg2.addError("Replacement failed.", (Object)e);
                return;
            }
        }
        arg1.done();
    }

    protected String convertUri(URI uri) {
        if (uri.isPlatform()) {
            if (Platform.isRunning()) {
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true))).getLocation().toString();
            }
            return EcorePlugin.resolvePlatformResourcePath((String)uri.toPlatformString(true)).toFileString();
        }
        return this.uriConverter.normalize(uri).toFileString();
    }
}

