/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.ecoreworkflow.mwe2lib.component;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent2;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.utils.Mapping;
import tools.mdsd.ecoreworkflow.mwe2lib.component.Replacement;

public class RegexComponent
extends AbstractWorkflowComponent2 {
    private static final Log LOG = LogFactory.getLog(RegexComponent.class);
    private final Collection<Replacement> replacements = new ArrayList<Replacement>();
    protected URIConverter uriConverter = new ExtensibleURIConverterImpl();
    private Charset charset = StandardCharsets.UTF_8;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void addReplacement(Replacement replacement) {
        this.replacements.add(replacement);
    }

    protected void invokeInternal(WorkflowContext arg0, ProgressMonitor arg1, Issues arg2) {
        arg1.beginTask("Replacing patterns for files", this.replacements.size());
        for (Replacement replacement : this.replacements) {
            try {
                this.replace(this.determineFilesToReplace(replacement), replacement.getMappings());
                arg1.worked(1);
            }
            catch (IOException e) {
                arg2.addError("Replacement failed.", (Object)e);
                return;
            }
        }
        arg1.done();
    }

    private void replace(List<URI> uris, Collection<Mapping> replacements) throws IOException {
        for (URI uri : uris) {
            String content = this.readFile(uri);
            for (Mapping replacement : replacements) {
                content = content.replaceAll(replacement.getFrom(), replacement.getTo());
            }
            this.writeFile(uri, content);
            LOG.info((Object)("Regex Replacement for:" + uri.toString()));
        }
    }

    protected String readFile(URI fileUri) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream stream = this.uriConverter.createInputStream(fileUri);){
            return new String(stream.readAllBytes(), this.charset);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void writeFile(URI fileUri, String content) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream stream = this.uriConverter.createOutputStream(fileUri);){
            stream.write(content.getBytes(this.charset));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected List<URI> determineFilesToReplace(Replacement replacement) throws IOException {
        Optional<URI> directory = Optional.ofNullable(replacement.getDirectory()).map(this::fromFilename).map(this::ensureURIHasScheme).map(this::ensureEmptyLastSegment);
        final List<URI> filesToProcess = replacement.getFilenames().stream().map(this::fromFilename).map(uri -> directory.map(arg_0 -> ((URI)uri).resolve(arg_0)).orElse((URI)uri)).map(this::ensureURIHasScheme).collect(Collectors.toList());
        if (replacement.getWildcard() != null) {
            if (directory.isEmpty()) {
                throw new IllegalArgumentException("Cannot scan for files based on a wildcard without a base directory.");
            }
            final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + replacement.getWildcard());
            final java.nio.file.Path dirPath = this.getPathOfDirectoryOnFilesystem(directory.get());
            Files.walkFileTree(dirPath, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                @Override
                public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                    java.nio.file.Path relativeMatch = dirPath.relativize(file);
                    if (matcher.matches(relativeMatch)) {
                        filesToProcess.add(RegexComponent.this.ensureURIHasScheme(URI.createURI((String)file.toUri().toString())));
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(java.nio.file.Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return filesToProcess;
    }

    protected URI fromFilename(String filename) {
        Optional<URI> uri = this.parseURI(filename);
        return uri.orElseGet(() -> URI.createURI((String)java.nio.file.Path.of(filename, new String[0]).toUri().toString()));
    }

    protected Optional<URI> parseURI(String uri) {
        try {
            java.net.URI jUri = new java.net.URI(uri);
            return Optional.of(URI.createURI((String)jUri.toString()));
        }
        catch (URISyntaxException e) {
            return Optional.empty();
        }
    }

    protected java.nio.file.Path getPathOfDirectoryOnFilesystem(URI uri) {
        if (uri.isPlatform()) {
            String platformString = uri.toPlatformString(true);
            if (Platform.isRunning()) {
                Path path = new Path(platformString);
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path).getLocation().toFile().toPath();
            }
            URI resolvedUri = EcorePlugin.resolvePlatformResourcePath((String)platformString);
            return this.getPathOfFileURI(resolvedUri);
        }
        if (uri.isFile() || uri.isRelative()) {
            return this.getPathOfFileURI(uri);
        }
        throw new IllegalArgumentException("Could not resolve the URI of the base directory to a file path: " + uri.toString());
    }

    protected java.nio.file.Path getPathOfFileURI(URI uri) {
        java.net.URI jUri = java.net.URI.create(this.ensureURIHasScheme(uri).toString());
        return Paths.get(jUri);
    }

    protected URI ensureURIHasScheme(URI uri) {
        java.net.URI jUri = java.net.URI.create(uri.toString());
        if (!jUri.isAbsolute()) {
            try {
                jUri = Paths.get(new java.net.URI("file", jUri.getHost(), jUri.getPath(), jUri.getFragment())).toAbsolutePath().toUri();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return URI.createURI((String)jUri.toString());
    }

    protected URI ensureEmptyLastSegment(URI uri) {
        String lastSegment = uri.segment(uri.segmentCount() - 1);
        if (lastSegment != null && !lastSegment.isBlank()) {
            uri = uri.appendSegment("");
        }
        return uri;
    }
}

