/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.statistics;

import java.util.ArrayList;

public class CrossingMeanWarmUpFilter {
    private static final int MEAN_CROSSINGS_STATIONARY = 5;
    private ArrayList<Double> buffer = new ArrayList();
    private double samplesSum;

    public void offerSample(Double sample) {
        this.buffer.add(sample);
        this.samplesSum += sample.doubleValue();
    }

    public boolean isStationary() {
        return this.computeMeanCrossings(this.computeCurrentMean()) >= 5;
    }

    private int computeMeanCrossings(double mean) {
        int crossings = 0;
        Double prevSample = null;
        for (Double currSample : this.buffer) {
            if (prevSample == null) {
                prevSample = currSample;
                continue;
            }
            if (prevSample < currSample) {
                if (prevSample < mean && currSample > mean) {
                    ++crossings;
                }
            } else if (prevSample > mean && currSample < mean) {
                ++crossings;
            }
            prevSample = currSample;
        }
        return crossings;
    }

    private double computeCurrentMean() {
        return this.samplesSum / (double)this.buffer.size();
    }
}

