/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementframework.listener;

import java.util.Collection;
import org.palladiosimulator.commons.designpatterns.AbstractObservable;
import org.palladiosimulator.commons.designpatterns.IAbstractObservable;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.listener.IMeasurementSourceListener;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.metricentity.IMetricEntity;
import org.palladiosimulator.metricspec.metricentity.MetricEntity;

public abstract class MeasurementSource
extends MetricEntity
implements IAbstractObservable<IMeasurementSourceListener> {
    private final AbstractObservable<IMeasurementSourceListener> observableDelegate = new AbstractObservable<IMeasurementSourceListener>(){};

    public MeasurementSource(MetricDescription metricDesciption) {
        super(metricDesciption);
    }

    public void addObserver(IMeasurementSourceListener observer) {
        this.observableDelegate.addObserver((Object)observer);
    }

    public void removeObserver(IMeasurementSourceListener observer) {
        this.observableDelegate.removeObserver((Object)observer);
    }

    protected final Collection<IMeasurementSourceListener> getMeasurementSourceListeners() {
        return this.observableDelegate.getObservers();
    }

    protected final void notifyMeasurementSourceListener(MeasuringValue newMeasurement) {
        if (!this.isCompatibleMeasurement(newMeasurement)) {
            throw new IllegalArgumentException("Taken measurement has an incompatible metric");
        }
        ((IMeasurementSourceListener)this.observableDelegate.getEventDispatcher()).newMeasurementAvailable(newMeasurement);
    }

    private boolean isCompatibleMeasurement(IMetricEntity measurement) {
        return this.isCompatibleWith(measurement.getMetricDesciption());
    }
}

