/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.errorhandling;

import de.uka.ipd.sdq.errorhandling.SeverityEnum;
import org.eclipse.emf.ecore.EObject;

public class SeverityAndIssue
implements Comparable<SeverityAndIssue> {
    private static final String DEFAULT_RESOURCE_NAME = "";
    private final SeverityEnum severity;
    private final String message;
    private final Object element;
    private final String objectResourceName;

    public SeverityAndIssue(SeverityEnum error, String message, EObject element) {
        this(error, message, element, null);
    }

    public SeverityAndIssue(SeverityEnum error, String message, Object element, String objectResourceName) {
        this.severity = error;
        this.message = message;
        this.element = element;
        this.objectResourceName = objectResourceName;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetails() {
        String text = "Severity: " + (this.severity == SeverityEnum.ERROR ? "ERROR" : "WARNING") + "\n\n";
        text = String.valueOf(text) + "Message: " + this.message + "\n\n";
        if (this.element != null) {
            text = String.valueOf(text) + "Element: " + this.element + "\n\n";
        }
        if (this.objectResourceName != null) {
            text = String.valueOf(text) + "Resource location: " + this.objectResourceName + "\n\n";
        }
        return text;
    }

    public Object getElement() {
        return this.element;
    }

    public String getResourceName() {
        if (this.element != null) {
            if (this.element instanceof EObject) {
                return ((EObject)this.element).eResource().getURI().toFileString();
            }
            return this.objectResourceName == null ? DEFAULT_RESOURCE_NAME : this.objectResourceName;
        }
        return DEFAULT_RESOURCE_NAME;
    }

    public SeverityEnum getError() {
        return this.severity;
    }

    @Override
    public int compareTo(SeverityAndIssue o) {
        if (this.severity == o.getError()) {
            return 0;
        }
        if (this.severity == SeverityEnum.ERROR && o.getError() == SeverityEnum.WARNING) {
            return -1;
        }
        return 1;
    }
}

