/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.ui.configuration.extensions;

import java.util.Map;
import org.palladiosimulator.commons.datastructureutils.MapHelper;
import org.palladiosimulator.simulizar.ui.configuration.extensions.ExtensionInputType;

public class ExtensionFileInputConfiguration {
    private final Map<String, Object> properties;

    public ExtensionFileInputConfiguration(Map<String, Object> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Given properties map must not be null.");
        }
        this.properties = properties;
    }

    public <T> T getPropertyByKey(String key, Class<T> expectedDataType) {
        return (T)MapHelper.getValue(this.properties, (String)key, expectedDataType);
    }

    public boolean isPropertySet(String propertyKey) {
        return this.properties.containsKey(propertyKey);
    }

    public static class DefaultPropertyKeys {
        public static final String FILE_RESTRICTIONS_KEY = "fileRestrictions";
        public static final String DEFAULT_URI_KEY = "defaultUri";
        public static final String DIALOG_TITLE_KEY = "dialogTitle";
        public static final String GROUP_LABEL_KEY = "groupLabel";
        public static final String INPUT_TYPE_KEY = "inputType";
        public static final String CONFIG_ATTRIBUTE_NAME_KEY = "configAttribute";
        public static final Class<String[]> EXPECTED_FILE_RESTRICTIONS_DATA_TYPE = String[].class;
        public static final Class<ExtensionInputType> EXPECTED_INPUT_TYPE_DATA_TYPE = ExtensionInputType.class;

        private DefaultPropertyKeys() {
        }
    }
}

