/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.library.standalone.initialization;

import java.util.ArrayList;
import java.util.List;
import tools.mdsd.library.standalone.initialization.InitializationTask;
import tools.mdsd.library.standalone.initialization.StandaloneInitializer;
import tools.mdsd.library.standalone.initialization.core.MetaModelRegistrationTask;
import tools.mdsd.library.standalone.initialization.impl.EcoreClassPathDetection;
import tools.mdsd.library.standalone.initialization.impl.ProjectURIByClasspathRegistration;
import tools.mdsd.library.standalone.initialization.impl.StandaloneInitializerImpl;

public class StandaloneInitializerBuilder {
    private boolean ecoreClasspathDetection = true;
    private final List<InitializationTask> initializationTasks = new ArrayList<InitializationTask>();

    private StandaloneInitializerBuilder() {
    }

    public static StandaloneInitializerBuilder builder() {
        return new StandaloneInitializerBuilder();
    }

    public StandaloneInitializerBuilder useEcoreClasspathDetection(boolean use) {
        this.ecoreClasspathDetection = use;
        return this;
    }

    public StandaloneInitializerBuilder registerProjectURI(Class<?> classOfProject, String projectName) {
        return this.registerProjectURI(classOfProject, projectName, projectName);
    }

    public StandaloneInitializerBuilder registerProjectURI(Class<?> classOfProject, String projectName, String rootFolderName) {
        ProjectURIByClasspathRegistration task = new ProjectURIByClasspathRegistration(classOfProject, projectName, rootFolderName);
        this.initializationTasks.add(task);
        return this;
    }

    public StandaloneInitializerBuilder registerMetaModel(String projectName, String relativePath) {
        this.initializationTasks.add(new MetaModelRegistrationTask(projectName, relativePath));
        return this;
    }

    public StandaloneInitializerBuilder addCustomTask(InitializationTask task) {
        this.initializationTasks.add(task);
        return this;
    }

    public StandaloneInitializer build() {
        ArrayList<InitializationTask> tasks = new ArrayList<InitializationTask>();
        if (this.ecoreClasspathDetection) {
            tasks.add(new EcoreClassPathDetection());
        }
        tasks.addAll(this.initializationTasks);
        return new StandaloneInitializerImpl(tasks);
    }
}

