/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.library.standalone.initialization.core;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import tools.mdsd.library.standalone.initialization.InitializationTask;
import tools.mdsd.library.standalone.initialization.StandaloneInitializationException;
import tools.mdsd.library.standalone.initialization.core.EclipseProjectScanner;
import tools.mdsd.library.standalone.initialization.impl.ProjectURIByLocationRegistration;

public class EclipseProjectByClassRegistration
implements InitializationTask {
    private final Class<?> clazz;

    public EclipseProjectByClassRegistration(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public void initilizationWithoutPlatform() throws StandaloneInitializationException {
        for (Map.Entry<String, File> project : EclipseProjectByClassRegistration.tryFindProjectContaining(this.clazz).entrySet()) {
            new ProjectURIByLocationRegistration(project.getValue(), project.getKey()).init();
        }
    }

    protected static Map<String, File> tryFindProjectContaining(Class<?> clz) throws StandaloneInitializationException {
        Map<String, File> result = Collections.emptyMap();
        try {
            Path classLocation = Paths.get(clz.getProtectionDomain().getCodeSource().getLocation().toURI());
            while (classLocation != null && result.isEmpty()) {
                result = EclipseProjectScanner.findProjects(classLocation);
                classLocation = classLocation.getParent();
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new StandaloneInitializationException("Error locating the class in the file system", e);
        }
        if (result.isEmpty()) {
            throw new StandaloneInitializationException("Error locating a eclipse project artifact in the file system hierarchy");
        }
        return result;
    }
}

