/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.library.standalone.initialization.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import tools.mdsd.library.standalone.initialization.InitializationTask;
import tools.mdsd.library.standalone.initialization.StandaloneInitializationException;
import tools.mdsd.library.standalone.initialization.impl.ProjectURIByLocationRegistration;

public class EclipseProjectScanner
implements InitializationTask {
    public static final int DEFAULT_MAX_DEPTH = 3;
    public static final String PROJECT_FILE_NAME = ".project";
    private final Path basePath;

    public EclipseProjectScanner(Path basePath) {
        this.basePath = basePath;
    }

    @Override
    public void initilizationWithoutPlatform() throws StandaloneInitializationException {
        Map<Object, Object> projects = Collections.emptyMap();
        try {
            projects = EclipseProjectScanner.findProjects(this.basePath);
        }
        catch (IOException e) {
            throw new StandaloneInitializationException("Errors reading project artifacts", e);
        }
        if (projects.isEmpty()) {
            throw new StandaloneInitializationException("Could not find the eclipse project artifacts in " + this.basePath.toString() + ".");
        }
        for (Map.Entry<Object, Object> project : projects.entrySet()) {
            new ProjectURIByLocationRegistration((File)project.getValue(), (String)project.getKey()).init();
        }
    }

    protected static Map<String, File> findProjects(Path basePath) throws IOException {
        Path projectFilePath = Paths.get(PROJECT_FILE_NAME, new String[0]);
        Map<String, File> res = Files.find(basePath, 3 + projectFilePath.getNameCount(), (path2, attr) -> path2.endsWith(projectFilePath), new FileVisitOption[0]).collect(Collectors.toMap(EclipseProjectScanner::readProjectNameFromProjectFile, path2 -> {
            Path result = path2;
            int i = 0;
            while (i < projectFilePath.getNameCount()) {
                result = result.getParent();
                ++i;
            }
            return result.toFile();
        }));
        Path manifestPath = Paths.get("META-INF/MANIFEST.MF", new String[0]);
        res.putAll(Files.find(basePath, 3 + manifestPath.getNameCount(), (path2, attr) -> path2.endsWith(manifestPath), new FileVisitOption[0]).collect(Collectors.toMap(EclipseProjectScanner::readProjectNameFromManifestFile, path2 -> {
            Path result = path2;
            int i = 0;
            while (i < manifestPath.getNameCount()) {
                result = result.getParent();
                ++i;
            }
            return result.toFile();
        }, (a, b) -> b)));
        return res;
    }

    protected static String readProjectNameFromProjectFile(Path path) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(Files.newInputStream(path, StandardOpenOption.READ));
            return document.getDocumentElement().getElementsByTagName("name").item(0).getTextContent();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException("Error reading the project file " + path.toString(), e);
        }
    }

    protected static String readProjectNameFromManifestFile(Path path) {
        try {
            Manifest manifest = new Manifest(Files.newInputStream(path, StandardOpenOption.READ));
            String bundleName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
            if (bundleName.indexOf(59) > 0) {
                bundleName = bundleName.substring(0, bundleName.indexOf(59));
            }
            return bundleName;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading the project file " + path.toString(), e);
        }
    }
}

