/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.library.standalone.initialization.impl;

import java.io.File;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.eclipse.emf.common.util.URI;
import tools.mdsd.library.standalone.initialization.InitializationTask;
import tools.mdsd.library.standalone.initialization.impl.InitializationTaskWrapper;
import tools.mdsd.library.standalone.initialization.impl.ProjectURIByURIRegistration;

public class ProjectURIByClasspathRegistration
extends InitializationTaskWrapper {
    public ProjectURIByClasspathRegistration(Class<?> classOfProject, String projectName, String projectRootFolderName) {
        super(ProjectURIByClasspathRegistration.createDelegate(classOfProject, projectName, projectRootFolderName));
    }

    protected static InitializationTask createDelegate(Class<?> classOfProject, String projectName, String projectRootFolderName) {
        Optional<URI> projectUri = ProjectURIByClasspathRegistration.getRealProjectURI(classOfProject, projectRootFolderName);
        return new ProjectURIByURIRegistration(projectUri.orElse(null), projectName);
    }

    protected static Optional<URI> getRealProjectURI(Class<?> clz, String projectRootFolderName) {
        String classLocation = clz.getProtectionDomain().getCodeSource().getLocation().getPath();
        String plainLocation = URLDecoder.decode(classLocation, StandardCharsets.UTF_8);
        if (plainLocation.endsWith(".jar")) {
            File plainFile = new File(plainLocation);
            URI fileURI = URI.createFileURI((String)plainFile.getAbsolutePath());
            String authority = String.valueOf(fileURI.toString()) + "!";
            URI jarUri = URI.createHierarchicalURI((String)"jar", (String)authority, null, (String[])new String[]{""}, null, null);
            return Optional.of(jarUri);
        }
        int projectNameIndex = plainLocation.indexOf(projectRootFolderName);
        int projectNameLength = projectRootFolderName.length();
        if (projectNameIndex < 0) {
            return Optional.empty();
        }
        String projectLocation = plainLocation.substring(0, projectNameIndex + projectNameLength);
        File projectLocationFile = new File(projectLocation);
        URI fileUri = URI.createFileURI((String)projectLocationFile.getAbsolutePath()).appendSegment("");
        return Optional.of(fileUri);
    }
}

