/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.library.standalone.initialization.impl;

import java.util.Optional;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.impl.URIMappingRegistryImpl;
import tools.mdsd.library.standalone.initialization.InitializationTask;
import tools.mdsd.library.standalone.initialization.StandaloneInitializationException;

public class ProjectURIByURIRegistration
implements InitializationTask {
    private final Optional<URI> realProjectURI;
    private final String projectName;

    public ProjectURIByURIRegistration(URI realProjectURI, String projectName) {
        this.realProjectURI = Optional.ofNullable(realProjectURI);
        this.projectName = projectName;
    }

    @Override
    public void initilizationWithoutPlatform() throws StandaloneInitializationException {
        URI projectURI = this.realProjectURI.orElseThrow(() -> new StandaloneInitializationException("Could not register project " + this.projectName + " because of missing URI."));
        if (!projectURI.hasTrailingPathSeparator()) {
            projectURI = projectURI.appendSegment("");
        }
        EcorePlugin.getPlatformResourceMap().put(this.projectName, projectURI);
        URI pluginURI = URI.createPlatformPluginURI((String)("/" + this.projectName + "/"), (boolean)false);
        URI platformURI = URI.createPlatformResourceURI((String)("/" + this.projectName + "/"), (boolean)false);
        URIMappingRegistryImpl.INSTANCE.put((Object)pluginURI, (Object)platformURI);
    }
}

