/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.visualization.jfreechart.input.xyplot;

import java.util.Collections;
import java.util.Set;
import javax.measure.Measure;
import javax.measure.unit.Unit;
import org.eclipse.emf.common.util.EList;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.IDataStream;
import org.palladiosimulator.edp2.datastream.configurable.PropertyConfigurable;
import org.palladiosimulator.edp2.visualization.jfreechart.input.AbstractXYVisualizationInput;
import org.palladiosimulator.edp2.visualization.jfreechart.input.JFreeChartVisualizationSingleDatastreamInput;
import org.palladiosimulator.edp2.visualization.jfreechart.input.xyplot.XYPlotVisualizationInputConfiguration;
import org.palladiosimulator.edp2.visualization.jfreechart.input.xyplot.XYPlotVisualizationInputFactory;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;

public class XYPlotVisualizationInput
extends AbstractXYVisualizationInput {
    public String getFactoryId() {
        return XYPlotVisualizationInputFactory.FACTORY_ID;
    }

    @Override
    protected PropertyConfigurable createConfiguration() {
        return new XYPlotVisualizationInputConfiguration();
    }

    @Override
    protected AbstractDataset generateDataset() {
        DefaultXYDataset dataset = new DefaultXYDataset();
        int i = 1;
        for (JFreeChartVisualizationSingleDatastreamInput childInput : this.getInputs()) {
            dataset.addSeries((Comparable)((Object)(String.valueOf(i) + ": " + childInput.getInputName())), this.getXYData(childInput.getDataSource()));
            ++i;
        }
        return dataset;
    }

    @Override
    protected Plot generatePlot(PropertyConfigurable config, AbstractDataset dataset) {
        XYPlotVisualizationInputConfiguration configuration = (XYPlotVisualizationInputConfiguration)config;
        XYPlot plot = new XYPlot();
        XYDataset xyDataset = (XYDataset)dataset;
        NumberAxis domainAxis = new NumberAxis(configuration.isShowDomainAxisLabel() ? configuration.getDomainAxisLabel() : null);
        NumberAxis rangeAxis = new NumberAxis(configuration.isShowRangeAxisLabel() ? configuration.getRangeAxisLabel() : null);
        plot.setRangeAxis((ValueAxis)rangeAxis);
        plot.setDomainAxis((ValueAxis)domainAxis);
        plot.setDataset(xyDataset);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        boolean isShowSeriesLine = configuration.isShowSeriesLine();
        boolean isShowSeriesShape = configuration.isShowSeriesShapes();
        int i = 0;
        while (i < xyDataset.getSeriesCount()) {
            renderer.setSeriesLinesVisible(i, isShowSeriesLine);
            renderer.setSeriesShapesVisible(i, isShowSeriesShape);
            ++i;
        }
        plot.setRenderer((XYItemRenderer)renderer);
        this.configureSeriesColors((AbstractRenderer)renderer);
        return plot;
    }

    private double[][] getXYData(IDataSource dataSource) {
        if (!this.canAccept(dataSource)) {
            throw new IllegalArgumentException("XYData has to be a two-dimensional metric set description.");
        }
        IDataStream inputStream = dataSource.getDataStream();
        EList subsumedMetrics = ((MetricSetDescription)inputStream.getMetricDesciption()).getSubsumedMetrics();
        Unit domainUnit = ((NumericalBaseMetricDescription)subsumedMetrics.get(this.getXPos())).getDefaultUnit();
        Unit rangeUnit = ((NumericalBaseMetricDescription)subsumedMetrics.get(this.getYPos())).getDefaultUnit();
        try {
            double[][] result = new double[2][inputStream.size()];
            int i = 0;
            for (TupleMeasurement tuple : inputStream) {
                Measure[] measurement = tuple.asArray();
                result[0][i] = measurement[this.getXPos()].doubleValue(domainUnit);
                result[1][i] = measurement[this.getYPos()].doubleValue(rangeUnit);
                ++i;
            }
            double[][] dArray = result;
            return dArray;
        }
        finally {
            inputStream.close();
        }
    }

    protected Set<String> getPropertyKeysTriggeringUpdate() {
        return Collections.emptySet();
    }
}

