/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.QueryTimeout;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.util.Bits;

final class TimeLimitingBulkScorer
extends BulkScorer {
    static final int INTERVAL = 100;
    private final BulkScorer in;
    private final QueryTimeout queryTimeout;

    public TimeLimitingBulkScorer(BulkScorer bulkScorer, QueryTimeout queryTimeout) {
        this.in = bulkScorer;
        this.queryTimeout = queryTimeout;
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
        while (min < max) {
            int newMax = (int)Math.min((long)min + 100L, (long)max);
            if (this.queryTimeout.shouldExit()) {
                throw new TimeExceededException();
            }
            min = this.in.score(collector, acceptDocs, min, newMax);
        }
        return min;
    }

    @Override
    public long cost() {
        return this.in.cost();
    }

    static class TimeExceededException
    extends RuntimeException {
        private TimeExceededException() {
            super("TimeLimit Exceeded");
        }
    }
}

