/*
 * Decompiled with CFR 0.152.
 */
package de.mdelab.sdm.interpreter.core.eclipse;

import de.mdelab.sdm.interpreter.core.SDMException;
import de.mdelab.sdm.interpreter.core.expressions.ExpressionInterpreter;
import de.mdelab.sdm.interpreter.core.expressions.ExpressionInterpreterManager;
import de.mdelab.sdm.interpreter.core.facade.MetamodelFacadeFactory;
import de.mdelab.sdm.interpreter.core.notifications.NotificationEmitter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class EclipseExpressionInterpreterManager<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression>
extends ExpressionInterpreterManager<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> {
    public static final String EXPRESSION_INTERPRETERS_EXTENSION_POINT_ID = "de.mdelab.sdm.interpreter.core.eclipse.expressionInterpreterExtension";
    public static final String EXPRESSION_LANGUAGE_ATTRIBUTE_NAME = "expressionLanguage";
    public static final String EXPRESSION_LANGUAGE_VERSION_ATTRIBUTE_NAME = "expressionLanguageVersion";
    public static final String EXPRESSION_INTERPRETER_CLASS_ATTRIBUTE_NAME = "expressionInterpreterClass";

    public EclipseExpressionInterpreterManager(MetamodelFacadeFactory<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> facadeFactory, ClassLoader classLoader, NotificationEmitter<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> notificationEmitter) throws SDMException {
        super(facadeFactory, classLoader, notificationEmitter);
        IConfigurationElement[] configurationElements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = registry.getConfigurationElementsFor(EXPRESSION_INTERPRETERS_EXTENSION_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            String expressionLanguage = configElement.getAttribute(EXPRESSION_LANGUAGE_ATTRIBUTE_NAME);
            String expressionLanguageVersion = configElement.getAttribute(EXPRESSION_LANGUAGE_VERSION_ATTRIBUTE_NAME);
            try {
                ExpressionInterpreter expressionInterpreter = (ExpressionInterpreter)configElement.createExecutableExtension(EXPRESSION_INTERPRETER_CLASS_ATTRIBUTE_NAME);
                this.registerExpressionInterpreter(expressionInterpreter, expressionLanguage, expressionLanguageVersion);
            }
            catch (CoreException e) {
                e.printStackTrace();
                throw new SDMException("Could not instantiate expression interpreter for language '" + expressionLanguage + "' version '" + expressionLanguageVersion + "'.", (Exception)((Object)e));
            }
            ++n2;
        }
    }
}

