/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simulation;

import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.simulation.ISimulationListener;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.palladiosimulator.analyzer.workflow.runconfig.ExperimentRunDescriptor;
import org.palladiosimulator.recorderframework.config.IRecorderConfigurationFactory;
import org.palladiosimulator.recorderframework.utils.RecorderExtensionHelper;

public abstract class AbstractSimulationConfig
implements Serializable,
ISimulationConfig {
    private static final Logger LOGGER = Logger.getLogger(AbstractSimulationConfig.class);
    private static final long serialVersionUID = 891323270372759718L;
    public static final String VARIATION_ID = "variationId";
    public static final String SIMULATOR_ID = "simulatorId";
    public static final String PERSISTENCE_RECORDER_NAME = "persistenceFramework";
    public static final String USE_FIXED_SEED = "useFixedSeed";
    public static final String FIXED_SEED_PREFIX = "fixedSeed";
    public static final String MAXIMUM_MEASUREMENT_COUNT = "maximumMeasurementCount";
    public static final String DEFAULT_SIMULATOR_ID = "de.uka.ipd.sdq.codegen.simucontroller.simucom";
    public static final String DEFAULT_EXPERIMENT_RUN = "MyRun";
    public static final String DEFAULT_VARIATION_NAME = "Default Variation";
    public static final String DEFAULT_SIMULATION_TIME = "150000";
    public static final String DEFAULT_MAXIMUM_MEASUREMENT_COUNT = "10000";
    public static final String DEFAULT_PERSISTENCE_RECORDER_NAME = "";
    public static final String VERBOSE_LOGGING = "verboseLogging";
    public static final String EXPERIMENT_RUN = "experimentRun";
    public static final String SIMULATION_TIME = "simTime";
    private final boolean verboseLogging;
    private final boolean isDebug;
    private final List<ISimulationListener> listeners;
    protected String nameExperimentRun;
    protected String variationId;
    private String additionalExperimentRunDescription;
    protected long simuTime;
    protected Long maxMeasurementsCount;
    protected long[] randomSeed = null;
    protected IRandomGenerator randomNumberGenerator = null;
    protected String recorderName;
    protected IRecorderConfigurationFactory recorderConfigurationFactory;
    protected ExperimentRunDescriptor descriptor = null;
    private final String simulatorId;

    public AbstractSimulationConfig(Map<String, Object> configuration, boolean debug) {
        this(configuration, debug, null);
        this.recorderConfigurationFactory = RecorderExtensionHelper.getRecorderConfigurationFactoryForName((String)this.recorderName);
        this.recorderConfigurationFactory.initialize(configuration);
    }

    public AbstractSimulationConfig(Map<String, Object> configuration, boolean debug, IRecorderConfigurationFactory configFactory) {
        this.verboseLogging = (Boolean)configuration.get(VERBOSE_LOGGING);
        this.isDebug = debug;
        this.variationId = (String)configuration.get(VARIATION_ID);
        this.simulatorId = (String)configuration.get(SIMULATOR_ID);
        this.nameExperimentRun = (String)configuration.get(EXPERIMENT_RUN);
        this.simuTime = Long.valueOf((String)configuration.get(SIMULATION_TIME));
        this.maxMeasurementsCount = Long.valueOf((String)configuration.get(MAXIMUM_MEASUREMENT_COUNT));
        this.randomSeed = this.getSeedFromConfig(configuration);
        this.recorderName = (String)configuration.get(PERSISTENCE_RECORDER_NAME);
        this.recorderConfigurationFactory = configFactory;
        this.listeners = new ArrayList<ISimulationListener>();
    }

    public final IRecorderConfigurationFactory getRecorderConfigurationFactory() {
        return this.recorderConfigurationFactory;
    }

    public boolean getVerboseLogging() {
        return this.verboseLogging || this.isDebug;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public void addListener(ISimulationListener l) {
        this.listeners.add(l);
    }

    public List<ISimulationListener> getListeners() {
        return this.listeners;
    }

    public String getAdditionalExperimentRunDescription() {
        return this.additionalExperimentRunDescription;
    }

    public void setAdditionalExperimentRunDescription(String additionalExperimentRunDescription) {
        this.additionalExperimentRunDescription = additionalExperimentRunDescription;
    }

    protected long[] getSeedFromConfig(Map<String, Object> configuration) {
        if (((Boolean)configuration.get(USE_FIXED_SEED)).booleanValue()) {
            long[] seed = new long[6];
            int i = 0;
            while (i < 6) {
                seed[i] = Long.parseLong((String)configuration.get(FIXED_SEED_PREFIX + i));
                ++i;
            }
            return seed;
        }
        return null;
    }

    public String getNameExperimentRun() {
        String name = DEFAULT_PERSISTENCE_RECORDER_NAME;
        name = this.descriptor != null ? String.valueOf(name) + this.descriptor.getNameExperimentRun() : String.valueOf(name) + this.getNameBase();
        if (this.additionalExperimentRunDescription != null) {
            name = String.valueOf(name) + this.additionalExperimentRunDescription;
        }
        return name;
    }

    public String getNameBase() {
        return this.nameExperimentRun;
    }

    public String getVariationId() {
        return this.variationId;
    }

    public void setNameBase(String name) {
        this.nameExperimentRun = name;
    }

    public long getSimuTime() {
        return this.simuTime;
    }

    public long getMaxMeasurementsCount() {
        return this.maxMeasurementsCount;
    }

    public String getRecorderName() {
        return this.recorderName;
    }

    public String getEngine() {
        return "org.palladiosimulator.simulation.abstractsimengine.ssj.SSJSimEngineFactory";
    }

    public void disposeRandomGenerator() {
        this.randomNumberGenerator.dispose();
        this.randomNumberGenerator = null;
    }

    public void setExperimentRunDescriptor(ExperimentRunDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public ExperimentRunDescriptor getExperimentRunDescriptor() {
        return this.descriptor;
    }

    public String getSimulatorId() {
        return this.simulatorId;
    }
}

