/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.dfd;

import java.nio.file.Paths;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.DataFlowAnalysisBuilder;
import org.dataflowanalysis.analysis.core.TransposeFlowGraphFinder;
import org.dataflowanalysis.analysis.dfd.DFDConfidentialityAnalysis;
import org.dataflowanalysis.analysis.dfd.resource.DFDModelResourceProvider;
import org.dataflowanalysis.analysis.dfd.resource.DFDResourceProvider;
import org.dataflowanalysis.analysis.dfd.resource.DFDURIResourceProvider;
import org.dataflowanalysis.analysis.utils.ResourceUtils;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;

public class DFDDataFlowAnalysisBuilder
extends DataFlowAnalysisBuilder {
    private final Logger logger = Logger.getLogger(DFDDataFlowAnalysisBuilder.class);
    protected String dataFlowDiagramPath;
    protected String dataDictionaryPath;
    protected Optional<DFDResourceProvider> customResourceProvider = Optional.empty();
    protected Class<? extends TransposeFlowGraphFinder> customTransposeFlowGraphFinderClass = null;

    public DFDDataFlowAnalysisBuilder standalone() {
        super.standalone();
        return this;
    }

    public DFDDataFlowAnalysisBuilder modelProjectName(String modelProjectName) {
        super.modelProjectName(modelProjectName);
        return this;
    }

    public DFDDataFlowAnalysisBuilder usePluginActivator(Class<? extends Plugin> pluginActivator) {
        super.usePluginActivator(pluginActivator);
        return this;
    }

    public DFDDataFlowAnalysisBuilder useDataDictionary(String dataDictionaryPath) {
        this.dataDictionaryPath = dataDictionaryPath;
        return this;
    }

    public DFDDataFlowAnalysisBuilder useDataFlowDiagram(String dataFlowDiagramPath) {
        this.dataFlowDiagramPath = dataFlowDiagramPath;
        return this;
    }

    public DFDDataFlowAnalysisBuilder useCustomResourceProvider(DFDResourceProvider resourceProvider) {
        this.customResourceProvider = Optional.of(resourceProvider);
        if (resourceProvider instanceof DFDModelResourceProvider) {
            this.customResourceProviderIsLoaded = true;
        }
        return this;
    }

    public DFDDataFlowAnalysisBuilder useTransposeFlowGraphFinder(Class<? extends TransposeFlowGraphFinder> transposeFlowGraphFinderClass) {
        this.customTransposeFlowGraphFinderClass = transposeFlowGraphFinderClass;
        return this;
    }

    private DFDResourceProvider getEffectiveResourceProvider() {
        if (this.customResourceProvider.isEmpty()) {
            URI dataDictionaryUri = this.modelProjectName.isEmpty() ? URI.createFileURI((String)Paths.get(this.dataDictionaryPath, new String[0]).toAbsolutePath().toString()) : ResourceUtils.createRelativePluginURI((String)this.dataDictionaryPath, (String)this.modelProjectName);
            URI dataFlowDiagramUri = this.modelProjectName.isEmpty() ? URI.createFileURI((String)Paths.get(this.dataFlowDiagramPath, new String[0]).toAbsolutePath().toString()) : ResourceUtils.createRelativePluginURI((String)this.dataFlowDiagramPath, (String)this.modelProjectName);
            return new DFDURIResourceProvider(dataFlowDiagramUri, dataDictionaryUri);
        }
        return this.customResourceProvider.get();
    }

    protected void validate() {
        super.validate();
        if (this.customResourceProvider.isEmpty() && (this.dataDictionaryPath == null || this.dataDictionaryPath.isEmpty())) {
            this.logger.error((Object)"A data dictionary is required to run the data flow analysis", (Throwable)new IllegalStateException("The DFD analysis requires a data dictionary"));
        }
        if (this.customResourceProvider.isEmpty() && (this.dataFlowDiagramPath == null || this.dataFlowDiagramPath.isEmpty())) {
            this.logger.error((Object)"A data flow diagram is required to run the data flow analysis", (Throwable)new IllegalStateException("The DFD analysis requires a data flow diagram"));
        }
    }

    public DFDConfidentialityAnalysis build() {
        this.validate();
        DFDResourceProvider resourceProvider = this.getEffectiveResourceProvider();
        resourceProvider.validate();
        if (this.customTransposeFlowGraphFinderClass == null) {
            return new DFDConfidentialityAnalysis(resourceProvider, this.pluginActivator, this.modelProjectName);
        }
        return new DFDConfidentialityAnalysis(resourceProvider, this.pluginActivator, this.modelProjectName, this.customTransposeFlowGraphFinderClass);
    }
}

