/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.dfd.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.core.AbstractTransposeFlowGraph;
import org.dataflowanalysis.analysis.core.AbstractVertex;
import org.dataflowanalysis.analysis.core.TransposeFlowGraphFinder;
import org.dataflowanalysis.analysis.dfd.core.DFDTransposeFlowGraph;
import org.dataflowanalysis.analysis.dfd.core.DFDVertex;
import org.dataflowanalysis.analysis.dfd.resource.DFDResourceProvider;
import org.dataflowanalysis.dfd.datadictionary.AbstractAssignment;
import org.dataflowanalysis.dfd.datadictionary.Assignment;
import org.dataflowanalysis.dfd.datadictionary.Behavior;
import org.dataflowanalysis.dfd.datadictionary.DataDictionary;
import org.dataflowanalysis.dfd.datadictionary.ForwardingAssignment;
import org.dataflowanalysis.dfd.datadictionary.Pin;
import org.dataflowanalysis.dfd.dataflowdiagram.DataFlowDiagram;
import org.dataflowanalysis.dfd.dataflowdiagram.Flow;
import org.dataflowanalysis.dfd.dataflowdiagram.Node;

public class DFDTransposeFlowGraphFinder
implements TransposeFlowGraphFinder {
    private final Logger logger = Logger.getLogger(TransposeFlowGraphFinder.class);
    protected final DataFlowDiagram dataFlowDiagram;
    private boolean hasCycles = false;
    private Map<Pin, DFDVertex> mapOutPinToExistingVertex = new HashMap<Pin, DFDVertex>();

    public DFDTransposeFlowGraphFinder(DFDResourceProvider resourceProvider) {
        this.dataFlowDiagram = resourceProvider.getDataFlowDiagram();
    }

    public DFDTransposeFlowGraphFinder(DataDictionary dataDictionary, DataFlowDiagram dataFlowDiagram) {
        this.dataFlowDiagram = dataFlowDiagram;
    }

    public List<? extends AbstractTransposeFlowGraph> findTransposeFlowGraphs() {
        return this.findTransposeFlowGraphs(this.getEndNodes(this.dataFlowDiagram.getNodes()), List.of());
    }

    public List<? extends AbstractTransposeFlowGraph> findTransposeFlowGraphs(List<?> sourceNodes) {
        return this.findTransposeFlowGraphs(this.getEndNodes(this.dataFlowDiagram.getNodes()), sourceNodes);
    }

    public List<? extends AbstractTransposeFlowGraph> findTransposeFlowGraphs(List<?> sinkNodes, List<?> sourceNodes) {
        List<Node> potentialSinks = sinkNodes.stream().filter(Node.class::isInstance).map(Node.class::cast).toList();
        List<Node> sources = sourceNodes.stream().filter(Node.class::isInstance).map(Node.class::cast).toList();
        ArrayList transposeFlowGraphs = new ArrayList();
        for (Node endNode : potentialSinks) {
            List<DFDVertex> sinks = this.determineSinks(new DFDVertex(endNode, new HashMap<Pin, DFDVertex>(), new HashMap<Pin, Flow>()), endNode.getBehavior().getInPin(), sources, new ArrayList<Pin>());
            if (!sourceNodes.isEmpty()) {
                sinks = sinks.stream().filter(it -> new DFDTransposeFlowGraph((AbstractVertex<?>)it).getVertices().stream().filter(DFDVertex.class::isInstance).map(DFDVertex.class::cast).anyMatch(vertex -> sources.contains(vertex.getReferencedElement()))).toList();
            }
            sinks.parallelStream().forEach(sink -> sink.unify(new HashSet<DFDVertex>()));
            sinks.forEach(sink -> {
                boolean bl = transposeFlowGraphs.add(new DFDTransposeFlowGraph((AbstractVertex<?>)sink));
            });
        }
        return transposeFlowGraphs;
    }

    private List<DFDVertex> determineSinks(DFDVertex sink, List<Pin> pins, List<Node> sourceNodes, List<Pin> previousPinsInTransposeFlow) {
        List<DFDVertex> vertices = new ArrayList<DFDVertex>();
        vertices.add(sink);
        if (sourceNodes.contains(sink.getReferencedElement())) {
            return vertices;
        }
        ArrayList<Pin> inputPins = new ArrayList<Pin>(pins);
        HashMap incomingFlowsToPins = new HashMap();
        inputPins.forEach(it -> {
            incomingFlowsToPins.putIfAbsent(it, new ArrayList());
            ((List)incomingFlowsToPins.get(it)).addAll(this.dataFlowDiagram.getFlows().stream().filter(flow -> flow.getDestinationPin().equals(it)).toList());
        });
        HashMap inToPreviousNodeInPinsMap = new HashMap();
        for (Pin pin2 : inputPins) {
            HashSet outputPins = new HashSet();
            inToPreviousNodeInPinsMap.put(pin2, new ArrayList());
            this.dataFlowDiagram.getFlows().stream().filter(flow -> flow.getDestinationPin().equals(pin2)).forEach(flow -> {
                boolean bl = outputPins.add(flow.getSourcePin());
            });
            outputPins.stream().forEach(outPin -> {
                Behavior behaviour = (Behavior)outPin.eContainer();
                behaviour.getAssignment().stream().filter(it -> it.getOutputPin().equals(outPin)).filter(ForwardingAssignment.class::isInstance).forEach(it -> {
                    boolean bl = ((List)inToPreviousNodeInPinsMap.get(pin2)).addAll(((ForwardingAssignment)it).getInputPins());
                });
                behaviour.getAssignment().stream().filter(it -> it.getOutputPin().equals(outPin)).filter(Assignment.class::isInstance).forEach(it -> {
                    boolean bl = ((List)inToPreviousNodeInPinsMap.get(pin2)).addAll(((Assignment)it).getInputPins());
                });
            });
        }
        HashMap mapInPinToEqualInPin = new HashMap();
        List keyList = inToPreviousNodeInPinsMap.keySet().stream().toList();
        int i = 0;
        while (i < keyList.size()) {
            Pin key = (Pin)keyList.get(i);
            List inPins = (List)inToPreviousNodeInPinsMap.get(key);
            int j = i + 1;
            while (j < keyList.size()) {
                Pin key2 = (Pin)keyList.get(j);
                List inPin2 = (List)inToPreviousNodeInPinsMap.get(key2);
                if (inPins.containsAll(inPin2) && inPin2.containsAll(inPins) && ((List)incomingFlowsToPins.getOrDefault(key2, new ArrayList())).size() < 2 && ((List)incomingFlowsToPins.get(key)).stream().map(Flow::getSourceNode).toList().equals(((List)incomingFlowsToPins.get(key2)).stream().map(Flow::getSourceNode).toList())) {
                    if (mapInPinToEqualInPin.getOrDefault(key, null) == null) {
                        mapInPinToEqualInPin.put(key, new ArrayList());
                    }
                    ((List)mapInPinToEqualInPin.get(key)).add(key2);
                }
                ++j;
            }
            ++i;
        }
        mapInPinToEqualInPin.keySet().stream().map(mapInPinToEqualInPin::get).forEach(inputPins::removeAll);
        for (Pin inputPin : inputPins) {
            List incomingFlowsToPin = (List)incomingFlowsToPins.get(inputPin);
            ArrayList<DFDVertex> finalVertices = vertices;
            if (!incomingFlowsToPin.stream().filter(it -> previousPinsInTransposeFlow.contains(it.getSourcePin())).toList().isEmpty() && !this.hasCycles) {
                this.logger.warn((Object)"Resolving cycles: Stopping cyclic behavior for analysis, may cause unwanted behavior");
                this.hasCycles = true;
            }
            vertices = incomingFlowsToPin.stream().filter(it -> !previousPinsInTransposeFlow.contains(it.getSourcePin())).flatMap(flow -> this.handleIncomingFlow((Flow)flow, inputPin, (List<DFDVertex>)finalVertices, sourceNodes, mapInPinToEqualInPin.getOrDefault(inputPin, new ArrayList()), previousPinsInTransposeFlow).stream()).toList();
        }
        if (inputPins.stream().anyMatch(pin -> this.dataFlowDiagram.getFlows().stream().noneMatch(flow -> flow.getDestinationPin().equals(pin)))) {
            this.logger.warn((Object)"TFG skipped since input pin has no incoming flow");
            return vertices;
        }
        if (vertices == null || vertices.isEmpty()) {
            vertices = new ArrayList();
            vertices.add(sink);
        }
        return vertices;
    }

    public List<DFDVertex> handleIncomingFlow(Flow incomingFlow, Pin inputPin, List<DFDVertex> vertices, List<Node> sourceNodes, List<Pin> equalPins, List<Pin> previousPinsInTransposeFlow) {
        List<Pin> previousNodeInputPins;
        ArrayList<DFDVertex> result = new ArrayList<DFDVertex>();
        ArrayList<Pin> copyPreviousPinsInTransposeFlow = new ArrayList<Pin>(previousPinsInTransposeFlow);
        Pin outPin = incomingFlow.getSourcePin();
        copyPreviousPinsInTransposeFlow.add(outPin);
        if (this.mapOutPinToExistingVertex.get(outPin) != null) {
            for (DFDVertex vertex : vertices) {
                ArrayList<DFDVertex> previousNodeVertices = new ArrayList<DFDVertex>();
                DFDVertex newVertex = this.mapOutPinToExistingVertex.get(outPin).copy(new IdentityHashMap<DFDVertex, DFDVertex>());
                previousNodeVertices.add(newVertex);
                result.addAll(this.cloneVertexForMultipleFlowGraphs(vertex, inputPin, incomingFlow, previousNodeVertices, equalPins));
            }
            return result;
        }
        Node previousNode = incomingFlow.getSourceNode();
        List<DFDVertex> previousNodeVertices = this.determineSinks(new DFDVertex(previousNode, new HashMap<Pin, DFDVertex>(), new HashMap<Pin, Flow>()), previousNodeInputPins = this.getAllPreviousNodeInputPins(previousNode, incomingFlow), sourceNodes, copyPreviousPinsInTransposeFlow);
        if (!previousNodeVertices.isEmpty()) {
            this.mapOutPinToExistingVertex.put(outPin, previousNodeVertices.get(0));
        }
        if (vertices.size() == 1 && previousNodeVertices.size() == 1 && vertices.get(0).getPinDFDVertexMap().isEmpty()) {
            DFDVertex vertex = vertices.get(0);
            vertex.getPinDFDVertexMap().put(inputPin, previousNodeVertices.get(0));
            equalPins.forEach(it -> {
                DFDVertex dFDVertex2 = vertex.getPinDFDVertexMap().put((Pin)it, (DFDVertex)((Object)((Object)previousNodeVertices.get(0))));
            });
            vertex.getPinFlowMap().put(inputPin, incomingFlow);
            equalPins.forEach(it -> {
                Flow newFlow = this.dataFlowDiagram.getFlows().stream().filter(inFlow -> inFlow.getDestinationPin().equals(it) && inFlow.getSourceNode().equals(incomingFlow.getSourceNode())).findAny().orElseThrow();
                vertex.getPinFlowMap().put((Pin)it, newFlow);
            });
            result.add(vertex);
            return result;
        }
        for (DFDVertex vertex : vertices) {
            result.addAll(this.cloneVertexForMultipleFlowGraphs(vertex, inputPin, incomingFlow, previousNodeVertices, equalPins));
        }
        return result;
    }

    protected List<Pin> getAllPreviousNodeInputPins(Node previousNode, Flow flow) {
        HashSet previousNodeInputPins = new HashSet();
        for (AbstractAssignment abstractAssignment : previousNode.getBehavior().getAssignment()) {
            if (!abstractAssignment.getOutputPin().equals(flow.getSourcePin())) continue;
            if (abstractAssignment instanceof ForwardingAssignment) {
                ForwardingAssignment forwardingAssignment = (ForwardingAssignment)abstractAssignment;
                previousNodeInputPins.addAll(forwardingAssignment.getInputPins());
                continue;
            }
            if (!(abstractAssignment instanceof Assignment)) continue;
            Assignment assignment = (Assignment)abstractAssignment;
            previousNodeInputPins.addAll(assignment.getInputPins());
        }
        return new ArrayList<Pin>(previousNodeInputPins);
    }

    protected List<DFDVertex> cloneVertexForMultipleFlowGraphs(DFDVertex vertex, Pin inputPin, Flow flow, List<DFDVertex> previousNodeVertices, List<Pin> equalPins) {
        ArrayList<DFDVertex> newVertices = new ArrayList<DFDVertex>();
        for (DFDVertex previousVertex : previousNodeVertices) {
            DFDVertex newVertex = vertex.copy(new IdentityHashMap<DFDVertex, DFDVertex>());
            newVertex.getPinDFDVertexMap().put(inputPin, previousVertex);
            equalPins.forEach(it -> {
                DFDVertex dFDVertex3 = newVertex.getPinDFDVertexMap().put((Pin)it, previousVertex);
            });
            newVertex.getPinFlowMap().put(inputPin, flow);
            equalPins.forEach(it -> {
                Flow newFlow = this.dataFlowDiagram.getFlows().stream().filter(inFlow -> inFlow.getDestinationPin().equals(it) && inFlow.getSourceNode().equals(flow.getSourceNode())).findAny().orElseThrow();
                newVertex.getPinFlowMap().put((Pin)it, newFlow);
            });
            newVertices.add(newVertex);
            newVertex.unify(new HashSet<DFDVertex>());
        }
        return newVertices;
    }

    protected List<Node> getEndNodes(List<Node> nodes) {
        ArrayList<Node> endNodes = new ArrayList<Node>(nodes);
        for (Node node : nodes) {
            if (node.getBehavior().getInPin().isEmpty()) {
                endNodes.remove(node);
            }
            block1: for (Pin inputPin : node.getBehavior().getInPin()) {
                for (AbstractAssignment abstractAssignment : node.getBehavior().getAssignment()) {
                    Assignment assignment;
                    ForwardingAssignment forwardingAssignment;
                    if ((!(abstractAssignment instanceof ForwardingAssignment) || !(forwardingAssignment = (ForwardingAssignment)abstractAssignment).getInputPins().contains(inputPin)) && (!(abstractAssignment instanceof Assignment) || !(assignment = (Assignment)abstractAssignment).getInputPins().contains(inputPin))) continue;
                    endNodes.remove(node);
                    continue block1;
                }
            }
        }
        if (endNodes.isEmpty() && !nodes.isEmpty()) {
            throw new IllegalArgumentException("DFD terminates in a cycle, no sink can be identified.");
        }
        return endNodes;
    }

    public boolean hasCycles() {
        return this.hasCycles;
    }
}

