/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.dfd.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.dataflowanalysis.analysis.core.AbstractVertex;
import org.dataflowanalysis.analysis.core.CharacteristicValue;
import org.dataflowanalysis.analysis.core.DataCharacteristic;
import org.dataflowanalysis.analysis.dfd.core.DFDCharacteristicValue;
import org.dataflowanalysis.dfd.datadictionary.AND;
import org.dataflowanalysis.dfd.datadictionary.AbstractAssignment;
import org.dataflowanalysis.dfd.datadictionary.Assignment;
import org.dataflowanalysis.dfd.datadictionary.BinaryOperator;
import org.dataflowanalysis.dfd.datadictionary.ForwardingAssignment;
import org.dataflowanalysis.dfd.datadictionary.Label;
import org.dataflowanalysis.dfd.datadictionary.LabelReference;
import org.dataflowanalysis.dfd.datadictionary.LabelType;
import org.dataflowanalysis.dfd.datadictionary.NOT;
import org.dataflowanalysis.dfd.datadictionary.OR;
import org.dataflowanalysis.dfd.datadictionary.Pin;
import org.dataflowanalysis.dfd.datadictionary.SetAssignment;
import org.dataflowanalysis.dfd.datadictionary.TRUE;
import org.dataflowanalysis.dfd.datadictionary.Term;
import org.dataflowanalysis.dfd.datadictionary.UnsetAssignment;
import org.dataflowanalysis.dfd.dataflowdiagram.Flow;
import org.dataflowanalysis.dfd.dataflowdiagram.Node;

public class DFDVertex
extends AbstractVertex<Node> {
    protected final Map<Pin, DFDVertex> pinDFDVertexMap;
    protected final Map<Pin, Flow> pinFlowMap;

    public DFDVertex(Node node, Map<Pin, DFDVertex> pinDFDVertexMap, Map<Pin, Flow> pinFlowMap) {
        super((Object)node);
        this.pinDFDVertexMap = pinDFDVertexMap;
        this.pinFlowMap = pinFlowMap;
    }

    public void evaluateDataFlow() {
        if (super.isEvaluated()) {
            return;
        }
        this.evaluatePreviousVertices();
        List<CharacteristicValue> vertexCharacteristics = this.determineNodeCharacteristics();
        HashMap<Pin, List<Label>> inputPinsIncomingLabelMap = new HashMap<Pin, List<Label>>();
        this.getPinFlowMap().keySet().forEach(pin -> this.fillMapOfIncomingLabelsPerPin((Pin)pin, (Map<Pin, List<Label>>)inputPinsIncomingLabelMap));
        ArrayList<DataCharacteristic> dataCharacteristics = new ArrayList<DataCharacteristic>(this.createDataCharacteristicsFromLabels(inputPinsIncomingLabelMap));
        Map<Pin, List<Label>> outputPinsOutgoingLabelMap = this.determineOutputPinOutgoingLabelMap(inputPinsIncomingLabelMap);
        ArrayList<DataCharacteristic> outgoingDataCharacteristics = new ArrayList<DataCharacteristic>(this.createDataCharacteristicsFromLabels(outputPinsOutgoingLabelMap));
        this.setPropagationResult(dataCharacteristics, outgoingDataCharacteristics, vertexCharacteristics);
    }

    private Map<Pin, List<Label>> determineOutputPinOutgoingLabelMap(Map<Pin, List<Label>> inputPinsIncomingLabelMap) {
        LinkedHashMap<Pin, List<Label>> outputPinsOutgoingLabelMap = new LinkedHashMap<Pin, List<Label>>();
        List assignments = ((Node)this.getReferencedElement()).getBehavior().getAssignment();
        assignments.forEach(assignment -> {
            ArrayList arrayList = outputPinsOutgoingLabelMap.putIfAbsent(assignment.getOutputPin(), new ArrayList());
        });
        assignments.forEach(assignment -> this.handleOutgoingAssignments((AbstractAssignment)assignment, inputPinsIncomingLabelMap, (Map<Pin, List<Label>>)outputPinsOutgoingLabelMap));
        return outputPinsOutgoingLabelMap;
    }

    private List<CharacteristicValue> determineNodeCharacteristics() {
        ArrayList<CharacteristicValue> nodeCharacteristics = new ArrayList<CharacteristicValue>();
        ((Node)this.getReferencedElement()).getProperties().forEach(label -> {
            boolean bl = nodeCharacteristics.add(new DFDCharacteristicValue((LabelType)label.eContainer(), (Label)label));
        });
        return nodeCharacteristics;
    }

    private void evaluatePreviousVertices() {
        Map<Pin, DFDVertex> previousVertices = this.getPinDFDVertexMap();
        previousVertices.keySet().forEach(pin -> ((DFDVertex)((Object)((Object)previousVertices.get(pin)))).evaluateDataFlow());
    }

    private void fillMapOfIncomingLabelsPerPin(Pin pin, Map<Pin, List<Label>> inputPinsIncomingLabelMap) {
        for (DFDVertex previousVertex : this.getPinDFDVertexMap().values()) {
            for (DataCharacteristic dataFlowCharacteristics : previousVertex.getAllOutgoingDataCharacteristics()) {
                if (!dataFlowCharacteristics.getVariableName().equals(this.getPinFlowMap().get(pin).getSourcePin().getId())) continue;
                inputPinsIncomingLabelMap.putIfAbsent(pin, new ArrayList());
                for (CharacteristicValue characteristicValue : dataFlowCharacteristics.getAllCharacteristics()) {
                    inputPinsIncomingLabelMap.get(pin).add(((DFDCharacteristicValue)characteristicValue).getLabel());
                }
            }
        }
    }

    private void handleOutgoingAssignments(AbstractAssignment abstractAssignment, Map<Pin, List<Label>> inputPinsIncomingLabelMap, Map<Pin, List<Label>> outputPinsOutgoingLabelMap) {
        List<Label> incomingLabels = DFDVertex.combineLabelsOnAllInputPins(abstractAssignment, inputPinsIncomingLabelMap);
        if (abstractAssignment instanceof ForwardingAssignment) {
            ForwardingAssignment forwardingAssignment = (ForwardingAssignment)abstractAssignment;
            outputPinsOutgoingLabelMap.get(forwardingAssignment.getOutputPin()).addAll(incomingLabels);
            return;
        }
        if (abstractAssignment instanceof SetAssignment) {
            SetAssignment setAssignment = (SetAssignment)abstractAssignment;
            outputPinsOutgoingLabelMap.get(abstractAssignment.getOutputPin()).addAll(setAssignment.getOutputLabels());
            return;
        }
        if (abstractAssignment instanceof UnsetAssignment) {
            UnsetAssignment unsetAssignment = (UnsetAssignment)abstractAssignment;
            outputPinsOutgoingLabelMap.get(abstractAssignment.getOutputPin()).removeAll(unsetAssignment.getOutputLabels());
            return;
        }
        if (abstractAssignment instanceof Assignment) {
            Assignment assignment = (Assignment)abstractAssignment;
            if (DFDVertex.evaluateTerm(assignment.getTerm(), incomingLabels)) {
                outputPinsOutgoingLabelMap.get(assignment.getOutputPin()).addAll(assignment.getOutputLabels());
            } else {
                outputPinsOutgoingLabelMap.get(abstractAssignment.getOutputPin()).removeAll(assignment.getOutputLabels());
            }
        }
    }

    private List<DataCharacteristic> createDataCharacteristicsFromLabels(Map<Pin, List<Label>> pinToLabelMap) {
        return pinToLabelMap.keySet().stream().map(pin -> new DataCharacteristic(pin.getId(), this.getCharacteristicValuesForPin((Pin)pin, pinToLabelMap))).toList();
    }

    private List<CharacteristicValue> getCharacteristicValuesForPin(Pin pin, Map<Pin, List<Label>> pinToLabelMap) {
        return pinToLabelMap.get(pin).stream().map(label -> new DFDCharacteristicValue((LabelType)label.eContainer(), (Label)label)).filter(DFDVertex.distinctByKey(CharacteristicValue::getValueId)).collect(Collectors.toList());
    }

    private static List<Label> combineLabelsOnAllInputPins(AbstractAssignment abstractAssignment, Map<Pin, List<Label>> inputPinsIncomingLabelMap) {
        ArrayList<Label> allLabel;
        block4: {
            block3: {
                allLabel = new ArrayList<Label>();
                if (abstractAssignment instanceof SetAssignment || abstractAssignment instanceof UnsetAssignment) {
                    return allLabel;
                }
                if (!(abstractAssignment instanceof Assignment)) break block3;
                Assignment assignment = (Assignment)abstractAssignment;
                for (Pin inputPin : assignment.getInputPins()) {
                    allLabel.addAll(inputPinsIncomingLabelMap.getOrDefault(inputPin, new ArrayList()));
                }
                break block4;
            }
            if (!(abstractAssignment instanceof ForwardingAssignment)) break block4;
            ForwardingAssignment forwardingAssignment = (ForwardingAssignment)abstractAssignment;
            for (Pin inputPin : forwardingAssignment.getInputPins()) {
                allLabel.addAll(inputPinsIncomingLabelMap.getOrDefault(inputPin, new ArrayList()));
            }
        }
        return allLabel;
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    private static boolean evaluateTerm(Term term, List<Label> inputLabel) {
        if (term instanceof TRUE) {
            return true;
        }
        if (term instanceof NOT) {
            NOT notTerm = (NOT)term;
            return !DFDVertex.evaluateTerm(notTerm.getNegatedTerm(), inputLabel);
        }
        if (term instanceof LabelReference) {
            return inputLabel.contains(((LabelReference)term).getLabel());
        }
        if (term instanceof BinaryOperator) {
            BinaryOperator binaryTerm = (BinaryOperator)term;
            if (binaryTerm instanceof AND) {
                return DFDVertex.evaluateTerm((Term)binaryTerm.getTerms().get(0), inputLabel) && DFDVertex.evaluateTerm((Term)binaryTerm.getTerms().get(1), inputLabel);
            }
            if (binaryTerm instanceof OR) {
                return DFDVertex.evaluateTerm((Term)binaryTerm.getTerms().get(0), inputLabel) || DFDVertex.evaluateTerm((Term)binaryTerm.getTerms().get(1), inputLabel);
            }
        }
        return false;
    }

    public void unify(Set<DFDVertex> vertices) {
        for (Pin key : this.getPinDFDVertexMap().keySet()) {
            for (DFDVertex vertex2 : vertices) {
                if (!vertex2.equals((Object)this.getPinDFDVertexMap().get(key))) continue;
                this.getPinDFDVertexMap().put(key, vertex2);
            }
            vertices.add(this.getPinDFDVertexMap().get(key));
        }
        this.getPreviousElements().forEach(vertex -> ((DFDVertex)((Object)vertex)).unify(vertices));
    }

    public DFDVertex copy(Map<DFDVertex, DFDVertex> mapping) {
        HashMap<Pin, DFDVertex> copiedPinDFDVertexMap = new HashMap<Pin, DFDVertex>();
        this.pinDFDVertexMap.keySet().forEach(key -> {
            DFDVertex oldVertex = this.pinDFDVertexMap.get(key);
            DFDVertex newVertice = mapping.getOrDefault((Object)oldVertex, this.pinDFDVertexMap.get(key).copy(mapping));
            copiedPinDFDVertexMap.put((Pin)key, newVertice);
            mapping.putIfAbsent(oldVertex, newVertice);
        });
        return new DFDVertex((Node)this.referencedElement, copiedPinDFDVertexMap, new HashMap<Pin, Flow>(this.pinFlowMap));
    }

    public String toString() {
        return String.format("(%s, %s)", ((Node)this.referencedElement).getEntityName(), ((Node)this.referencedElement).getId());
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object other) {
        void vertex;
        if (super.equals(other)) {
            return true;
        }
        if (!(other instanceof DFDVertex)) {
            return false;
        }
        DFDVertex dFDVertex = (DFDVertex)((Object)other);
        if (!((Node)this.referencedElement).equals(vertex.getReferencedElement())) {
            return false;
        }
        for (Pin key : this.getPinDFDVertexMap().keySet()) {
            if (this.getPinDFDVertexMap().get(key).equals((Object)vertex.getPinDFDVertexMap().get(key))) continue;
            return false;
        }
        return true;
    }

    public List<AbstractVertex<?>> getPreviousElements() {
        return new HashSet<DFDVertex>(this.pinDFDVertexMap.values()).stream().toList();
    }

    public Map<Pin, DFDVertex> getPinDFDVertexMap() {
        return this.pinDFDVertexMap;
    }

    public Map<Pin, Flow> getPinFlowMap() {
        return this.pinFlowMap;
    }

    public String getName() {
        return ((Node)this.getReferencedElement()).getEntityName();
    }
}

