/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.dfd.interactive;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.core.FlowGraphCollection;
import org.dataflowanalysis.analysis.dfd.DFDConfidentialityAnalysis;
import org.dataflowanalysis.analysis.dfd.DFDDataFlowAnalysisBuilder;
import org.dataflowanalysis.analysis.dfd.core.DFDFlowGraphCollection;
import org.dataflowanalysis.analysis.dsl.AnalysisConstraint;
import org.dataflowanalysis.analysis.dsl.result.DSLResult;
import org.dataflowanalysis.analysis.utils.ParseResult;
import org.dataflowanalysis.analysis.utils.StringView;

public class DFDAnalysisCLI {
    private static final Logger logger = Logger.getLogger(DFDAnalysisCLI.class);
    private static final String INPUT_INDICATOR = "> ";

    public static void main(String[] args) {
        List<AnalysisConstraint> constraints;
        DFDConfidentialityAnalysis analysis;
        if (args.length != 0 && args.length != 3) {
            logger.error((Object)"Please provide either no arguments, or a path to a .dataflowdiagram and .datadictionary file!");
            System.exit(-1);
        }
        if (args.length == 0) {
            Scanner scanner = new Scanner(System.in);
            analysis = DFDAnalysisCLI.createAnalysisInteractive(scanner);
            constraints = DFDAnalysisCLI.createConstraintInteractive(scanner);
            scanner.close();
        } else {
            if (!args[0].endsWith(".dataflowdiagram")) {
                logger.error((Object)"The first argument should be a path to a .dataflowdiagram file");
                System.exit(-1);
            }
            if (!args[1].endsWith(".datadictionary")) {
                logger.error((Object)"The second argument should be a path to a .datadictionary file");
                System.exit(-1);
            }
            analysis = DFDAnalysisCLI.createAnalysis(args[0], args[1]);
            constraints = args[2].endsWith(".dfadsl") ? DFDAnalysisCLI.createConstraintsFromFile(args[2]) : List.of(DFDAnalysisCLI.createConstraint(args[2]));
        }
        analysis.initializeAnalysis();
        DFDFlowGraphCollection flowGraphs = analysis.findFlowGraphs();
        flowGraphs.evaluate();
        int i = 0;
        while (i < constraints.size()) {
            AnalysisConstraint constraint = constraints.get(i);
            List violations = constraint.findViolations((FlowGraphCollection)flowGraphs);
            for (DSLResult violation : violations) {
                logger.info((Object)("Violation for constraint " + i + ":"));
                logger.info((Object)violation.toString());
                logger.info((Object)"-------------------------");
            }
            ++i;
        }
        System.exit(0);
    }

    private static DFDConfidentialityAnalysis createAnalysisInteractive(Scanner scanner) {
        System.out.println("Please enter a path to a .dataflowdiagram file: ");
        System.out.print(INPUT_INDICATOR);
        String dataFlowDiagramPath = scanner.nextLine();
        System.out.println("Please enter a path to a .datadictionary file: ");
        System.out.print(INPUT_INDICATOR);
        String dataDictionaryPath = scanner.nextLine();
        return DFDAnalysisCLI.createAnalysis(dataFlowDiagramPath, dataDictionaryPath);
    }

    private static DFDConfidentialityAnalysis createAnalysis(String dataFlowDiagramPath, String dataDictionaryPath) {
        return new DFDDataFlowAnalysisBuilder().standalone().useDataFlowDiagram(dataFlowDiagramPath).useDataDictionary(dataDictionaryPath).build();
    }

    private static List<AnalysisConstraint> createConstraintInteractive(Scanner scanner) {
        ArrayList<AnalysisConstraint> constraints = new ArrayList<AnalysisConstraint>();
        System.out.println("Please enter constraints: ");
        System.out.print(INPUT_INDICATOR);
        String constraintString = scanner.nextLine();
        while (!constraintString.isEmpty()) {
            constraints.add(DFDAnalysisCLI.createConstraint(constraintString));
            System.out.println("Please enter constraints (end with empty line): ");
            System.out.print(INPUT_INDICATOR);
            constraintString = scanner.nextLine();
        }
        return constraints;
    }

    private static List<AnalysisConstraint> createConstraintsFromFile(String fileName) {
        ArrayList<AnalysisConstraint> constraints = new ArrayList<AnalysisConstraint>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(fileName));){
                List<String> lines = bufferedReader.lines().toList();
                int i = 0;
                while (i < lines.size()) {
                    ParseResult parseResult = AnalysisConstraint.fromString((StringView)new StringView(lines.get(i)));
                    if (parseResult.failed()) {
                        logger.error((Object)("Invalid constraint in line" + i + ":"));
                        logger.error((Object)parseResult.getError());
                        System.exit(-1);
                    }
                    constraints.add((AnalysisConstraint)parseResult.getResult());
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error((Object)"Could not read file!", (Throwable)e);
            System.exit(-1);
        }
        return constraints;
    }

    private static AnalysisConstraint createConstraint(String constraintString) {
        ParseResult parseResult = AnalysisConstraint.fromString((StringView)new StringView(constraintString));
        if (parseResult.failed()) {
            logger.error((Object)"Invalid constraint:");
            logger.error((Object)parseResult.getError());
            System.exit(-1);
        }
        return (AnalysisConstraint)parseResult.getResult();
    }
}

