/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.dfd.resource;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.dfd.resource.DFDResourceProvider;
import org.dataflowanalysis.dfd.datadictionary.DataDictionary;
import org.dataflowanalysis.dfd.dataflowdiagram.DataFlowDiagram;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DFDURIResourceProvider
extends DFDResourceProvider {
    private static final Logger logger = Logger.getLogger(DFDURIResourceProvider.class);
    private final URI dataFlowDiagramURI;
    private final URI dataDictionaryURI;
    private DataFlowDiagram dataFlowDiagram;
    private DataDictionary dataDictionary;

    public DFDURIResourceProvider(URI dataFlowDiagramURI, URI dataDictionaryURI) {
        this.dataFlowDiagramURI = dataFlowDiagramURI;
        this.dataDictionaryURI = dataDictionaryURI;
    }

    public void loadRequiredResources() {
        ArrayList loadedResources;
        this.dataFlowDiagram = (DataFlowDiagram)this.loadModelContent(this.dataFlowDiagramURI);
        this.dataDictionary = (DataDictionary)this.loadModelContent(this.dataDictionaryURI);
        do {
            loadedResources = new ArrayList(this.resources.getResources());
            loadedResources.forEach(EcoreUtil::resolveAll);
        } while (loadedResources.size() != this.resources.getResources().size());
        EcoreUtil.resolveAll((ResourceSet)this.resources);
        for (Resource resource : this.resources.getResources()) {
            if (resource.getErrors().isEmpty()) continue;
            logger.error((Object)"Errors occurred during loading a model:");
            logger.error(resource.getErrors().stream().map(Resource.Diagnostic::getMessage).toList());
        }
    }

    @Override
    public DataFlowDiagram getDataFlowDiagram() {
        return this.dataFlowDiagram;
    }

    @Override
    public DataDictionary getDataDictionary() {
        return this.dataDictionary;
    }
}

