/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.dfd.simple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.dataflowanalysis.analysis.core.AbstractTransposeFlowGraph;
import org.dataflowanalysis.analysis.core.TransposeFlowGraphFinder;
import org.dataflowanalysis.analysis.dfd.resource.DFDResourceProvider;
import org.dataflowanalysis.analysis.dfd.simple.DFDSimpleTransposeFlowGraph;
import org.dataflowanalysis.analysis.dfd.simple.DFDSimpleVertex;
import org.dataflowanalysis.dfd.datadictionary.AbstractAssignment;
import org.dataflowanalysis.dfd.datadictionary.Assignment;
import org.dataflowanalysis.dfd.datadictionary.DataDictionary;
import org.dataflowanalysis.dfd.datadictionary.ForwardingAssignment;
import org.dataflowanalysis.dfd.datadictionary.Pin;
import org.dataflowanalysis.dfd.dataflowdiagram.DataFlowDiagram;
import org.dataflowanalysis.dfd.dataflowdiagram.Flow;
import org.dataflowanalysis.dfd.dataflowdiagram.Node;

public class DFDSimpleTransposeFlowGraphFinder
implements TransposeFlowGraphFinder {
    protected final DataFlowDiagram dataFlowDiagram;
    private Map<Node, DFDSimpleVertex> mapNodeToExistingVertex = new HashMap<Node, DFDSimpleVertex>();

    public DFDSimpleTransposeFlowGraphFinder(DFDResourceProvider resourceProvider) {
        this.dataFlowDiagram = resourceProvider.getDataFlowDiagram();
    }

    public DFDSimpleTransposeFlowGraphFinder(DataDictionary dataDictionary, DataFlowDiagram dataFlowDiagram) {
        this.dataFlowDiagram = dataFlowDiagram;
    }

    public List<? extends AbstractTransposeFlowGraph> findTransposeFlowGraphs() {
        return this.findTransposeFlowGraphs(this.getEndNodes(this.dataFlowDiagram.getNodes()), List.of());
    }

    public List<? extends AbstractTransposeFlowGraph> findTransposeFlowGraphs(List<?> sourceNodes) {
        return this.findTransposeFlowGraphs(this.getEndNodes(this.dataFlowDiagram.getNodes()), sourceNodes);
    }

    public List<? extends AbstractTransposeFlowGraph> findTransposeFlowGraphs(List<?> sinkNodes, List<?> sourceNodes) {
        ArrayList<DFDSimpleTransposeFlowGraph> transposeFlowGraphs = new ArrayList<DFDSimpleTransposeFlowGraph>();
        System.out.println(this.dataFlowDiagram.getNodes());
        for (Node endNode : this.getEndNodes(this.dataFlowDiagram.getNodes())) {
            DFDSimpleVertex sink = this.determineSinks(endNode);
            sink.unify(new HashSet<DFDSimpleVertex>());
            transposeFlowGraphs.add(new DFDSimpleTransposeFlowGraph(sink));
        }
        return transposeFlowGraphs;
    }

    private DFDSimpleVertex determineSinks(Node node) {
        if (this.mapNodeToExistingVertex.get(node) != null) {
            return this.mapNodeToExistingVertex.get(node);
        }
        if (!this.verifySimplicity(node)) {
            throw new IllegalArgumentException("DFD not simple: outPin not requiring all InPins");
        }
        HashMap<Pin, Flow> pinToFlowMap = new HashMap<Pin, Flow>();
        HashSet<DFDSimpleVertex> previousVertices = new HashSet<DFDSimpleVertex>();
        node.getBehavior().getInPin().forEach(pin -> {
            List<Flow> incomingFlows = this.dataFlowDiagram.getFlows().stream().filter(flow -> flow.getDestinationPin().equals(pin)).toList();
            if (incomingFlows.size() != 1) {
                throw new IllegalArgumentException("DFD not simple: Number of flows to inpin not 1");
            }
            Flow incomingFlow = incomingFlows.get(0);
            pinToFlowMap.put((Pin)pin, incomingFlow);
            previousVertices.add(this.determineSinks(incomingFlow.getSourceNode()));
        });
        node.getBehavior().getOutPin().forEach(pin -> {
            List<Flow> outgoingFlows = this.dataFlowDiagram.getFlows().stream().filter(flow -> flow.getSourcePin().equals(pin)).toList();
            if (outgoingFlows.size() == 0) {
                throw new IllegalArgumentException("DFD not simple: Dead output pin");
            }
            String flowname = outgoingFlows.get(0).getEntityName();
            outgoingFlows.forEach(it -> {
                if (!it.getEntityName().equals(flowname)) {
                    throw new IllegalArgumentException("DFD not simple: All outgoing flows from one pin must have the same name");
                }
            });
            Flow outgoingFlow = outgoingFlows.get(0);
            pinToFlowMap.put((Pin)pin, outgoingFlow);
        });
        DFDSimpleVertex vertex = new DFDSimpleVertex(node, previousVertices, pinToFlowMap);
        this.mapNodeToExistingVertex.put(node, vertex);
        return vertex;
    }

    private boolean verifySimplicity(Node node) {
        if (!node.getBehavior().getAssignment().stream().filter(ForwardingAssignment.class::isInstance).anyMatch(it -> ((ForwardingAssignment)it).getInputPins().equals(node.getBehavior().getInPin()))) {
            if (!node.getBehavior().getAssignment().stream().filter(Assignment.class::isInstance).anyMatch(it -> ((Assignment)it).getInputPins().equals(node.getBehavior().getInPin())) && node.getBehavior().getOutPin().size() != 0) {
                return false;
            }
        }
        return true;
    }

    protected List<Node> getEndNodes(List<Node> nodes) {
        ArrayList<Node> endNodes = new ArrayList<Node>(nodes);
        for (Node node : nodes) {
            if (node.getBehavior().getInPin().isEmpty()) {
                endNodes.remove(node);
            }
            block1: for (Pin inputPin : node.getBehavior().getInPin()) {
                for (AbstractAssignment abstractAssignment : node.getBehavior().getAssignment()) {
                    Assignment assignment;
                    ForwardingAssignment forwardingAssignment;
                    if ((!(abstractAssignment instanceof ForwardingAssignment) || !(forwardingAssignment = (ForwardingAssignment)abstractAssignment).getInputPins().contains(inputPin)) && (!(abstractAssignment instanceof Assignment) || !(assignment = (Assignment)abstractAssignment).getInputPins().contains(inputPin))) continue;
                    endNodes.remove(node);
                    continue block1;
                }
            }
        }
        return endNodes;
    }
}

