/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.dfd.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.dataflowanalysis.analysis.core.AbstractVertex;
import org.dataflowanalysis.analysis.core.CharacteristicValue;
import org.dataflowanalysis.analysis.core.DataCharacteristic;
import org.dataflowanalysis.analysis.dfd.core.DFDCharacteristicValue;
import org.dataflowanalysis.dfd.datadictionary.AND;
import org.dataflowanalysis.dfd.datadictionary.AbstractAssignment;
import org.dataflowanalysis.dfd.datadictionary.Assignment;
import org.dataflowanalysis.dfd.datadictionary.BinaryOperator;
import org.dataflowanalysis.dfd.datadictionary.ForwardingAssignment;
import org.dataflowanalysis.dfd.datadictionary.Label;
import org.dataflowanalysis.dfd.datadictionary.LabelReference;
import org.dataflowanalysis.dfd.datadictionary.LabelType;
import org.dataflowanalysis.dfd.datadictionary.NOT;
import org.dataflowanalysis.dfd.datadictionary.OR;
import org.dataflowanalysis.dfd.datadictionary.Pin;
import org.dataflowanalysis.dfd.datadictionary.SetAssignment;
import org.dataflowanalysis.dfd.datadictionary.TRUE;
import org.dataflowanalysis.dfd.datadictionary.Term;
import org.dataflowanalysis.dfd.datadictionary.UnsetAssignment;
import org.dataflowanalysis.dfd.dataflowdiagram.Flow;
import org.dataflowanalysis.dfd.dataflowdiagram.Node;

public class DFDSimpleVertex
extends AbstractVertex<Node> {
    private final Set<DFDSimpleVertex> previousVertices;
    private final Map<Pin, Flow> mapPinToFlow;

    public DFDSimpleVertex(Node node, Set<DFDSimpleVertex> previousVertices, Map<Pin, Flow> mapPinToFlow) {
        super((Object)node);
        this.previousVertices = previousVertices;
        this.mapPinToFlow = mapPinToFlow;
    }

    public void evaluateDataFlow() {
        if (super.isEvaluated()) {
            return;
        }
        this.previousVertices.forEach(it -> it.evaluateDataFlow());
        List<CharacteristicValue> vertexCharacteristics = this.determineNodeCharacteristics();
        List incomingCharacteristics = this.previousVertices.stream().map(it -> it.getAllOutgoingDataCharacteristics()).flatMap(Collection::stream).collect(Collectors.toList());
        HashMap<Pin, Set<Label>> outgoingLabelPerPin = new HashMap<Pin, Set<Label>>();
        ((Node)this.referencedElement).getBehavior().getAssignment().forEach(it -> this.handleOutgoingAssignments((AbstractAssignment)it, incomingCharacteristics, (Map<Pin, Set<Label>>)outgoingLabelPerPin));
        ArrayList<DataCharacteristic> outgoingDataCharacteristics = new ArrayList<DataCharacteristic>(this.createDataCharacteristicsFromLabels(outgoingLabelPerPin));
        this.setPropagationResult(incomingCharacteristics, outgoingDataCharacteristics, vertexCharacteristics);
    }

    private List<CharacteristicValue> determineNodeCharacteristics() {
        ArrayList<CharacteristicValue> nodeCharacteristics = new ArrayList<CharacteristicValue>();
        ((Node)this.getReferencedElement()).getProperties().forEach(label -> {
            boolean bl = nodeCharacteristics.add(new DFDCharacteristicValue((LabelType)label.eContainer(), (Label)label));
        });
        return nodeCharacteristics;
    }

    private void handleOutgoingAssignments(AbstractAssignment abstractAssignment, List<DataCharacteristic> incomingDataCharacteristics, Map<Pin, Set<Label>> outgoingLabelPerPin) {
        Set<Label> incomingLabels = incomingDataCharacteristics.stream().filter(it -> this.mapPinToFlow.keySet().stream().filter(key -> {
            ForwardingAssignment forwardingAssignment;
            if (abstractAssignment instanceof UnsetAssignment || abstractAssignment instanceof SetAssignment) {
                return false;
            }
            if (abstractAssignment instanceof Assignment) {
                Assignment assignment = (Assignment)abstractAssignment;
                return assignment.getInputPins().contains(key);
            }
            return abstractAssignment instanceof ForwardingAssignment && (forwardingAssignment = (ForwardingAssignment)abstractAssignment).getInputPins().contains(key);
        }).map(key -> this.mapPinToFlow.get(key).getEntityName()).toList().contains(it.getVariableName())).flatMap(it -> it.getAllCharacteristics().stream().map(value -> ((DFDCharacteristicValue)value).getLabel())).collect(Collectors.toSet());
        Pin outPin = abstractAssignment.getOutputPin();
        if (outPin == null) {
            return;
        }
        if (outgoingLabelPerPin.get(outPin) == null) {
            outgoingLabelPerPin.put(outPin, new HashSet());
        }
        if (abstractAssignment instanceof ForwardingAssignment) {
            ForwardingAssignment forwardingAssignment = (ForwardingAssignment)abstractAssignment;
            outgoingLabelPerPin.get(forwardingAssignment.getOutputPin()).addAll(incomingLabels);
            return;
        }
        if (abstractAssignment instanceof SetAssignment) {
            SetAssignment setAssignment = (SetAssignment)abstractAssignment;
            outgoingLabelPerPin.get(abstractAssignment.getOutputPin()).addAll(setAssignment.getOutputLabels());
            return;
        }
        if (abstractAssignment instanceof UnsetAssignment) {
            UnsetAssignment unsetAssignment = (UnsetAssignment)abstractAssignment;
            outgoingLabelPerPin.get(abstractAssignment.getOutputPin()).removeAll(unsetAssignment.getOutputLabels());
            return;
        }
        if (abstractAssignment instanceof Assignment) {
            Assignment assignment = (Assignment)abstractAssignment;
            if (DFDSimpleVertex.evaluateTerm(assignment.getTerm(), incomingLabels)) {
                outgoingLabelPerPin.get(assignment.getOutputPin()).addAll(assignment.getOutputLabels());
            } else {
                outgoingLabelPerPin.get(assignment.getOutputPin()).removeAll(assignment.getOutputLabels());
            }
        }
    }

    private List<DataCharacteristic> createDataCharacteristicsFromLabels(Map<Pin, Set<Label>> pinToLabelMap) {
        return pinToLabelMap.keySet().stream().map(pin -> new DataCharacteristic(this.mapPinToFlow.get(pin).getEntityName(), new ArrayList<CharacteristicValue>(this.getCharacteristicValuesForPin((Pin)pin, pinToLabelMap)))).filter(it -> it.getAllCharacteristics().size() > 0).toList();
    }

    private Set<CharacteristicValue> getCharacteristicValuesForPin(Pin pin, Map<Pin, Set<Label>> pinToLabelMap) {
        return pinToLabelMap.get(pin).stream().map(label -> new DFDCharacteristicValue((LabelType)label.eContainer(), (Label)label)).filter(DFDSimpleVertex.distinctByKey(CharacteristicValue::getValueId)).collect(Collectors.toSet());
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    private static boolean evaluateTerm(Term term, Set<Label> inputLabel) {
        if (term instanceof TRUE) {
            return true;
        }
        if (term instanceof NOT) {
            NOT notTerm = (NOT)term;
            return !DFDSimpleVertex.evaluateTerm(notTerm.getNegatedTerm(), inputLabel);
        }
        if (term instanceof LabelReference) {
            return inputLabel.contains(((LabelReference)term).getLabel());
        }
        if (term instanceof BinaryOperator) {
            BinaryOperator binaryTerm = (BinaryOperator)term;
            if (binaryTerm instanceof AND) {
                return DFDSimpleVertex.evaluateTerm((Term)binaryTerm.getTerms().get(0), inputLabel) && DFDSimpleVertex.evaluateTerm((Term)binaryTerm.getTerms().get(1), inputLabel);
            }
            if (binaryTerm instanceof OR) {
                return DFDSimpleVertex.evaluateTerm((Term)binaryTerm.getTerms().get(0), inputLabel) || DFDSimpleVertex.evaluateTerm((Term)binaryTerm.getTerms().get(1), inputLabel);
            }
        }
        return false;
    }

    public void unify(Set<DFDSimpleVertex> vertices) {
        ArrayList toRemove = new ArrayList();
        ArrayList toAdd = new ArrayList();
        this.previousVertices.forEach(it -> {
            for (DFDSimpleVertex vertex : vertices) {
                if (!((Object)it).equals((Object)vertex)) continue;
                toRemove.add(it);
                toAdd.add(vertex);
            }
        });
        this.previousVertices.removeAll(toRemove);
        this.previousVertices.addAll(toAdd);
        vertices.addAll(this.previousVertices);
        this.getPreviousElements().forEach(vertex -> ((DFDSimpleVertex)((Object)vertex)).unify(vertices));
    }

    public DFDSimpleVertex copy(Map<DFDSimpleVertex, DFDSimpleVertex> mapping) {
        HashSet<DFDSimpleVertex> previousVerticesNew = new HashSet<DFDSimpleVertex>();
        this.previousVertices.forEach(it -> {
            DFDSimpleVertex newVertice = mapping.getOrDefault(it, it.copy(mapping));
            previousVerticesNew.add(newVertice);
            mapping.putIfAbsent((DFDSimpleVertex)((Object)it), newVertice);
        });
        return new DFDSimpleVertex((Node)this.referencedElement, previousVerticesNew, new HashMap<Pin, Flow>(this.mapPinToFlow));
    }

    public String toString() {
        return String.format("(%s, %s)", ((Node)this.referencedElement).getEntityName(), ((Node)this.referencedElement).getId());
    }

    public List<AbstractVertex<Node>> getPreviousElements() {
        return this.previousVertices.stream().map(it -> it).toList();
    }

    public Map<Pin, Flow> getPinFlowMap() {
        return this.mapPinToFlow;
    }

    public String getName() {
        return ((Node)this.getReferencedElement()).getEntityName();
    }
}

