/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.extractor;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.analysis.function.Gaussian;
import org.eclipse.core.runtime.Status;
import tools.descartes.dlim.Combinator;
import tools.descartes.dlim.DlimFactory;
import tools.descartes.dlim.DlimGeneratorPlugin;
import tools.descartes.dlim.DlimPackage;
import tools.descartes.dlim.NormalNoise;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.assistant.CalibrationException;
import tools.descartes.dlim.extractor.HLDlimParameterContainer;
import tools.descartes.dlim.extractor.utils.BasicBurstExtractionUtilities;
import tools.descartes.dlim.extractor.utils.BasicExtractionUtils;
import tools.descartes.dlim.extractor.utils.BasicSeasonalExtractionUtilities;
import tools.descartes.dlim.extractor.utils.BasicTrendExtractionUtilities;
import tools.descartes.dlim.extractor.utils.BinarySeasonalSplitter;
import tools.descartes.dlim.extractor.utils.ExtractionDataContainer;
import tools.descartes.dlim.extractor.utils.RegressiveTrendExtractor;
import tools.descartes.dlim.extractor.utils.TimeDistanceSplittingHeuristic;
import tools.descartes.dlim.generator.ArrivalRateTuple;
import tools.descartes.dlim.generator.ModelEvaluator;

public final class ModelExtractor {
    private static final int EXPECTEDMAXPEAKSPERSEASONAL = 8;

    private ModelExtractor() {
    }

    public static void extractArrivalRateFileIntoSequenceBinarySplits(Sequence root, List<ArrivalRateTuple> arrList, double period, int seasonalsPerTrend, String seasonalShape, String trendShape, String operatorLiteral, boolean extractNoise) throws CalibrationException {
        ExtractionDataContainer container = new ExtractionDataContainer(arrList, period, seasonalsPerTrend, seasonalShape, trendShape, operatorLiteral);
        BinarySeasonalSplitter.resetBinarySplittingCount();
        BinarySeasonalSplitter.setGlobalContainer(container);
        ModelExtractor.setupArrivalRateLists(arrList, container);
        ModelExtractor.reduceArrivalRateListNoise(container, extractNoise);
        BasicSeasonalExtractionUtilities.performMinMaxSearch(container);
        Sequence baseline = DlimPackage.eINSTANCE.getDlimFactory().createSequence();
        double duration = 0.0;
        duration = container.getArrivalRateList().get(container.getArrivalRateList().size() - 1).getTimeStamp();
        container.setDuration(duration);
        ModelExtractor.clearRootAndBaseline(root, baseline);
        BinarySeasonalSplitter splitter = new BinarySeasonalSplitter(container);
        splitter.appendSplitsToRoot(root, baseline, new TimeDistanceSplittingHeuristic());
        container.setTrendPointValues(RegressiveTrendExtractor.getTrendEndPointsUsingRegression(container));
        container.setBurstWidth(BasicBurstExtractionUtilities.calculateBurstWidth(container));
        RegressiveTrendExtractor.buildTrendPart(root, container);
        RegressiveTrendExtractor.buildTrendPart(baseline, container);
        container.setBursts(BasicBurstExtractionUtilities.getBursts(root, baseline, container));
        BasicBurstExtractionUtilities.buildBurstPart(root, container);
        ModelExtractor.buildNormalNoisePart(root, container, extractNoise);
    }

    public static void extractArrivalRateFileIntoSequenceNoSplits(Sequence root, List<ArrivalRateTuple> arrList, double period, int seasonalsPerTrend, String seasonalShape, String trendShape, String operatorLiteral, boolean extractNoise) throws CalibrationException {
        ExtractionDataContainer container = new ExtractionDataContainer(arrList, period, seasonalsPerTrend, seasonalShape, trendShape, operatorLiteral);
        ModelExtractor.setupArrivalRateLists(arrList, container);
        ModelExtractor.reduceArrivalRateListNoise(container, extractNoise);
        BasicSeasonalExtractionUtilities.performMinMaxSearch(container);
        Sequence baseline = DlimPackage.eINSTANCE.getDlimFactory().createSequence();
        double duration = 0.0;
        duration = container.getArrivalRateList().get(container.getArrivalRateList().size() - 1).getTimeStamp();
        container.setDuration(duration);
        BasicSeasonalExtractionUtilities.extractSeasonalPart(root, baseline, container);
        container.setTrendPointValues(ModelExtractor.getTrendValues(container));
        container.setBurstWidth(container.getPeriod() / (double)container.getPeakNum());
        BasicTrendExtractionUtilities.buildTrendPart(root, container, container.getMaxPeakOffset(), true);
        BasicTrendExtractionUtilities.buildTrendPart(baseline, container, container.getMaxPeakOffset(), true);
        container.setBursts(BasicBurstExtractionUtilities.getBursts(root, baseline, container));
        BasicBurstExtractionUtilities.buildBurstPart(root, container);
        ModelExtractor.buildNormalNoisePart(root, container, extractNoise);
    }

    public static void extractSequenceFromArrivalRateFilePeriodic(Sequence root, List<ArrivalRateTuple> arrList, double period, List<int[]> seasonalsPerTrendList, String seasonalShape, String trendShape, String operatorLiteral, boolean extractNoise) throws CalibrationException {
        ExtractionDataContainer container = new ExtractionDataContainer(arrList, period, 0, seasonalShape, trendShape, operatorLiteral);
        ModelExtractor.setupArrivalRateLists(arrList, container);
        ModelExtractor.reduceArrivalRateListNoise(container, extractNoise);
        BasicSeasonalExtractionUtilities.performMinMaxSearch(container);
        Sequence baseline = DlimPackage.eINSTANCE.getDlimFactory().createSequence();
        double duration = 0.0;
        duration = container.getArrivalRateList().get(container.getArrivalRateList().size() - 1).getTimeStamp();
        container.setDuration(duration);
        BasicSeasonalExtractionUtilities.extractSeasonalPart(root, baseline, container);
        root.getCombine().clear();
        for (int[] seasonalsPerTrend : seasonalsPerTrendList) {
            double[] trendPointValues = ModelExtractor.getMediandValuesForPeriodicTrend(container, seasonalsPerTrend);
            BasicTrendExtractionUtilities.buildRepeatingTrend(root, seasonalsPerTrend, trendPointValues, container);
            BasicTrendExtractionUtilities.buildRepeatingTrend(baseline, seasonalsPerTrend, trendPointValues, container);
        }
        container.setBurstWidth(container.getPeriod() / (double)container.getPeakNum());
        container.setBursts(BasicBurstExtractionUtilities.getBursts(root, baseline, container));
        BasicBurstExtractionUtilities.buildBurstPart(root, container);
        ModelExtractor.buildNormalNoisePart(root, container, extractNoise);
    }

    public static HLDlimParameterContainer extractArrivalRateFileIntoParameters(String arrivalRateFilePath, double period, double offset, int seasonalsPerTrend, String seasonalShape, String trendShape, String operatorLiteral, boolean extractNoise) throws CalibrationException {
        int i;
        ExtractionDataContainer container = new ExtractionDataContainer(new ArrayList<ArrivalRateTuple>(), period, 0, seasonalShape, trendShape, operatorLiteral);
        HLDlimParameterContainer hlcontainer = new HLDlimParameterContainer();
        hlcontainer.setSeasonalShape(seasonalShape);
        hlcontainer.setTrendShape(trendShape);
        hlcontainer.setOperatorLiteral(operatorLiteral);
        hlcontainer.setSeasonalPeriod(period);
        hlcontainer.setSeasonalsPerTrend(seasonalsPerTrend);
        container.setSeasonalShape(seasonalShape);
        container.setTrendShape(trendShape);
        container.setOperatorLiteral(operatorLiteral);
        container.setPeriod(period);
        container.setSeasonalsPerTrend(seasonalsPerTrend);
        ModelExtractor.readFile(arrivalRateFilePath, offset, container);
        ModelExtractor.reduceArrivalRateListNoise(container, extractNoise);
        BasicSeasonalExtractionUtilities.performMinMaxSearch(container);
        Sequence root = DlimPackage.eINSTANCE.getDlimFactory().createSequence();
        Sequence baseline = DlimPackage.eINSTANCE.getDlimFactory().createSequence();
        double duration = 0.0;
        duration = container.getArrivalRateList().get(container.getArrivalRateList().size() - 1).getTimeStamp();
        container.setDuration(duration);
        container.setBase(BasicSeasonalExtractionUtilities.getBaseLevel(container));
        hlcontainer.setBase(container.getBase());
        container.setPeakNum(BasicSeasonalExtractionUtilities.getPeakNum(container));
        hlcontainer.setPeakNum(container.getPeakNum());
        container.setPeaks(BasicSeasonalExtractionUtilities.getPeaks(container));
        hlcontainer.setPeakIntervalWidth(container.getPeaks()[container.getPeaks().length - 1].getTimeStamp() - container.getPeaks()[0].getTimeStamp());
        ArrivalRateTuple.setSortByTime(false);
        Arrays.sort(container.getPeaks());
        if (container.getPeaks()[container.getPeaks().length - 1].getTimeStamp() < container.getPeaks()[0].getTimeStamp()) {
            hlcontainer.setFirstPeak(container.getPeaks()[container.getPeaks().length - 1].getArrivalRate());
            hlcontainer.setLastPeak(container.getPeaks()[0].getArrivalRate());
        } else {
            hlcontainer.setLastPeak(container.getPeaks()[container.getPeaks().length - 1].getArrivalRate());
            hlcontainer.setFirstPeak(container.getPeaks()[0].getArrivalRate());
        }
        int i2 = 0;
        while (i2 < container.getPeaks().length) {
            container.getPeaks()[i2].setTimeStamp((period - hlcontainer.getPeakIntervalWidth()) / 2.0 + (double)i2 * hlcontainer.getPeakIntervalWidth() / (double)container.getPeaks().length);
            container.getPeaks()[i2].setArrivalRate(hlcontainer.getFirstPeak() - (double)i2 * (hlcontainer.getFirstPeak() - hlcontainer.getLastPeak()) / (double)container.getPeaks().length);
            ++i2;
        }
        container.setMaxPeakOffset(BasicSeasonalExtractionUtilities.getMaxPeakOffset(container.getPeaks()));
        hlcontainer.setTrendOffset(container.getMaxPeakOffset());
        Object[] innerBases = BasicSeasonalExtractionUtilities.getInnerBases(container);
        if (innerBases != null) {
            ArrivalRateTuple.setSortByTime(false);
            Arrays.sort(innerBases);
            double innerBase = ((ArrivalRateTuple)innerBases[(innerBases.length - 1) / 2]).getArrivalRate();
            hlcontainer.setInnerBase(innerBase);
            i = 0;
            while (i < innerBases.length) {
                ((ArrivalRateTuple)innerBases[i]).setArrivalRate(innerBase);
                ++i;
            }
        }
        container.setInnerBases((ArrivalRateTuple[])innerBases);
        BasicSeasonalExtractionUtilities.buildSeasonalPart(root, baseline, container);
        container.setTrendPointValues(ModelExtractor.getTrendValues(container));
        hlcontainer.setTrendPoints(container.getTrendPointValues());
        BasicTrendExtractionUtilities.buildTrendPart(root, container, container.getMaxPeakOffset(), true);
        BasicTrendExtractionUtilities.buildTrendPart(baseline, container, container.getMaxPeakOffset(), true);
        container.setBurstWidth(container.getPeriod() / (double)container.getPeakNum());
        container.setBursts(BasicBurstExtractionUtilities.getBursts(root, baseline, container));
        hlcontainer.setBurstOffset(12.0);
        hlcontainer.setBurstPeriod(48.0);
        if (container.getBursts().size() > 0) {
            ModelEvaluator evaluator = new ModelEvaluator(root, 0, "dlim:calibration");
            hlcontainer.setBurstOffset(container.getBursts().get(0).getTimeStamp());
            hlcontainer.setBurstWidth(container.getBurstWidth());
            hlcontainer.setBurstPeriod(container.getDuration());
            hlcontainer.setBurstPeak(container.getBursts().get(0).getArrivalRate() - evaluator.getArrivalRateAtTime(hlcontainer.getBurstOffset()));
            if (container.getBursts().size() > 1) {
                double[] interBurstTimes = new double[container.getBursts().size() - 1];
                i = 0;
                while (i < interBurstTimes.length) {
                    interBurstTimes[i] = container.getBursts().get(i + 1).getTimeStamp() - container.getBursts().get(i).getTimeStamp();
                    ++i;
                }
                Arrays.sort(interBurstTimes);
                hlcontainer.setBurstPeriod(BasicExtractionUtils.getMedian(interBurstTimes));
            }
        }
        ModelExtractor.setUniformNoisePart(hlcontainer, container, extractNoise);
        return hlcontainer;
    }

    private static void readFile(String arrivalRateFilePath, double offset, ExtractionDataContainer container) {
        container.getArrivalRateList().clear();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(arrivalRateFilePath));
            while ((line = br.readLine()) != null) {
                String[] numbers = (line = line.substring(0, line.length() - 1)).split(",");
                if (numbers.length < 2) continue;
                double timeStamp = Double.parseDouble(numbers[0].trim());
                double readArrivalRate = Double.parseDouble(numbers[1].trim());
                if (!(timeStamp - offset > 0.0)) continue;
                container.getArrivalRateList().add(new ArrivalRateTuple(timeStamp - offset, readArrivalRate));
            }
            br.close();
            container.getNoisyArrivalRateList().clear();
            for (ArrivalRateTuple t : container.getArrivalRateList()) {
                container.getNoisyArrivalRateList().add(new ArrivalRateTuple(t.getTimeStamp(), t.getArrivalRate()));
            }
        }
        catch (IOException e) {
            DlimGeneratorPlugin.INSTANCE.log(new Status(4, "tools.descartes.dlim.generator", "Arrival Rate File does not exist.", (Throwable)e));
        }
    }

    private static void clearRootAndBaseline(Sequence root, Sequence baseline) {
        root.getSequenceFunctionContainers().clear();
        root.getCombine().clear();
        baseline.getSequenceFunctionContainers().clear();
        baseline.getCombine().clear();
    }

    private static double[] getTrendValues(ExtractionDataContainer container) {
        if (container.getSeasonalsPerTrend() <= 0) {
            return null;
        }
        double extractionOffset = container.getLocalMins().get(0).getTimeStamp();
        int trendPointNum = (int)(container.getDuration() / container.getPeriod()) / container.getSeasonalsPerTrend();
        double[] trendValues = new double[trendPointNum];
        int i = 0;
        while (i < trendPointNum) {
            trendValues[i] = BasicExtractionUtils.getArrivalRate((double)i * container.getPeriod() * (double)container.getSeasonalsPerTrend() + container.getMaxPeakOffset() + extractionOffset, container.getLocalMaxes(), false);
            ++i;
        }
        return trendValues;
    }

    private static double[] getMediandValuesForPeriodicTrend(ExtractionDataContainer container, int[] seasonalsPerTrend) {
        if (seasonalsPerTrend.length <= 0) {
            return null;
        }
        double trendDuration = 0.0;
        int[] nArray = seasonalsPerTrend;
        int n = seasonalsPerTrend.length;
        int n2 = 0;
        while (n2 < n) {
            int seasonals = nArray[n2];
            trendDuration += (double)seasonals;
            ++n2;
        }
        trendDuration *= container.getPeriod();
        double extractionOffset = container.getLocalMins().get(0).getTimeStamp();
        double[] trendValues = new double[seasonalsPerTrend.length + 1];
        int currentSeasonalAmount = 0;
        int i = 0;
        while (i < seasonalsPerTrend.length) {
            trendValues[i] = BasicExtractionUtils.getArrivalRate(container.getPeriod() * (double)currentSeasonalAmount + container.getMaxPeakOffset() + extractionOffset, container.getLocalMaxes(), false);
            int trendPeriods = (int)((container.getDuration() - container.getMaxPeakOffset() - extractionOffset) / trendDuration);
            double[] arrivalRatesAtPoint = new double[trendPeriods];
            int j = 0;
            while (j < trendPeriods) {
                arrivalRatesAtPoint[j] = BasicExtractionUtils.getArrivalRate((double)j * trendDuration + container.getPeriod() * (double)currentSeasonalAmount + container.getMaxPeakOffset() + extractionOffset, container.getLocalMaxes(), false);
                ++j;
            }
            trendValues[i] = BasicExtractionUtils.getMedian(arrivalRatesAtPoint);
            currentSeasonalAmount += seasonalsPerTrend[i];
            ++i;
        }
        trendValues[trendValues.length - 1] = trendValues[0];
        return trendValues;
    }

    private static double[] createGaussianFilter(int width) {
        int filterWidth = width;
        if (filterWidth % 2 == 0) {
            ++filterWidth;
        }
        filterWidth = Math.max(1, filterWidth);
        double[] filter = new double[filterWidth];
        double sigma = Math.sqrt(((double)(filterWidth * filterWidth) - 1.0) / 12.0);
        int mean = filterWidth / 2;
        double filterSum = 0.0;
        Gaussian gaussian = new Gaussian((double)mean, sigma);
        int i = 0;
        while (i < filterWidth) {
            filter[i] = gaussian.value((double)i);
            filterSum += filter[i];
            ++i;
        }
        i = 0;
        while (i < filterWidth) {
            filter[i] = filter[i] / filterSum;
            ++i;
        }
        return filter;
    }

    public static void reduceArrivalRateListNoise(List<ArrivalRateTuple> arrivalRates, double period) {
        ExtractionDataContainer reductionContainer = new ExtractionDataContainer(arrivalRates, period, 0, null, null, null);
        ModelExtractor.reduceArrivalRateListNoise(reductionContainer, true);
    }

    private static void reduceArrivalRateListNoise(ExtractionDataContainer container, boolean extractNoise) {
        if (!extractNoise) {
            return;
        }
        double[] filter = ModelExtractor.createGaussianFilter((int)(container.getPeriod() / 8.0));
        double[] arrivalRates = new double[container.getArrivalRateList().size()];
        int index = 0;
        for (ArrivalRateTuple t : container.getArrivalRateList()) {
            arrivalRates[index] = t.getArrivalRate();
            ++index;
        }
        index = 0;
        for (ArrivalRateTuple t : container.getArrivalRateList()) {
            t.setArrivalRate(ModelExtractor.getFilteredValueAtIndex(arrivalRates, index, filter));
            ++index;
        }
    }

    private static double getFilteredValueAtIndex(double[] arrivalRateArray, int index, double[] filter) {
        int filterCenter = filter.length / 2;
        double filteredValue = 0.0;
        int i = 0;
        while (i < filter.length) {
            filteredValue += filter[i] * ModelExtractor.getArrivalRateFromArray(arrivalRateArray, index + (i - filterCenter));
            ++i;
        }
        return filteredValue;
    }

    private static double getArrivalRateFromArray(double[] array, int index) {
        if (index < 0 || index >= array.length) {
            return 0.0;
        }
        return array[index];
    }

    private static void buildNormalNoisePart(Sequence root, ExtractionDataContainer container, boolean extractNoise) {
        if (!extractNoise) {
            return;
        }
        DlimFactory factory = DlimPackage.eINSTANCE.getDlimFactory();
        double[] noiseDiffs = new double[container.getArrivalRateList().size()];
        int index = 0;
        double sum = 0.0;
        for (ArrivalRateTuple t : container.getArrivalRateList()) {
            noiseDiffs[index] = -t.getArrivalRate() + container.getNoisyArrivalRateList().get(index).getArrivalRate();
            sum += noiseDiffs[index];
            ++index;
        }
        double mean = sum / (double)container.getArrivalRateList().size();
        double standardDeviation = 0.0;
        int i = 0;
        while (i < noiseDiffs.length) {
            standardDeviation += (noiseDiffs[i] - mean) * (noiseDiffs[i] - mean);
            ++i;
        }
        standardDeviation = Math.sqrt(standardDeviation / (double)noiseDiffs.length);
        Combinator noiseCombinator = factory.createCombinator();
        NormalNoise noise = factory.createNormalNoise();
        noise.setMean(mean);
        noise.setStandardDeviation(standardDeviation);
        noiseCombinator.setFunction(noise);
        root.getCombine().add((Object)noiseCombinator);
    }

    private static void setUniformNoisePart(HLDlimParameterContainer hlcontainer, ExtractionDataContainer exdcontainer, boolean extractNoise) {
        if (!extractNoise) {
            return;
        }
        double[] noiseDiffs = new double[exdcontainer.getArrivalRateList().size()];
        int index = 0;
        for (ArrivalRateTuple t : exdcontainer.getArrivalRateList()) {
            noiseDiffs[index] = -t.getArrivalRate() + exdcontainer.getNoisyArrivalRateList().get(index).getArrivalRate();
            ++index;
        }
        Arrays.sort(noiseDiffs);
        hlcontainer.setNoiseMin(noiseDiffs[(int)((double)noiseDiffs.length * 0.1)]);
        hlcontainer.setNoiseMax(noiseDiffs[(int)((double)noiseDiffs.length * 0.9)]);
    }

    private static void setupArrivalRateLists(List<ArrivalRateTuple> arrList, ExtractionDataContainer container) {
        container.setArrivalRateList(arrList);
        container.getNoisyArrivalRateList().clear();
        for (ArrivalRateTuple t : container.getArrivalRateList()) {
            container.getNoisyArrivalRateList().add(new ArrivalRateTuple(t.getTimeStamp(), t.getArrivalRate()));
        }
    }
}

