/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.extractor.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import tools.descartes.dlim.Constant;
import tools.descartes.dlim.DlimFactory;
import tools.descartes.dlim.DlimPackage;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.TimeDependentFunctionContainer;
import tools.descartes.dlim.Trend;
import tools.descartes.dlim.assistant.CalibrationException;
import tools.descartes.dlim.extractor.utils.BasicExtractionUtils;
import tools.descartes.dlim.extractor.utils.BasicTrendExtractionUtilities;
import tools.descartes.dlim.extractor.utils.ExtractionDataContainer;
import tools.descartes.dlim.generator.ArrivalRateTuple;

public final class BasicSeasonalExtractionUtilities {
    private BasicSeasonalExtractionUtilities() {
    }

    public static void extractSeasonalPart(Sequence root, Sequence baseline, ExtractionDataContainer container) throws CalibrationException {
        container.setBase(BasicSeasonalExtractionUtilities.getBaseLevel(container));
        container.setPeakNum(BasicSeasonalExtractionUtilities.getPeakNum(container));
        container.setPeaks(BasicSeasonalExtractionUtilities.getPeaks(container));
        container.setMaxPeakOffset(BasicSeasonalExtractionUtilities.getMaxPeakOffset(container.getPeaks()));
        container.setInnerBases(BasicSeasonalExtractionUtilities.getInnerBases(container));
        BasicSeasonalExtractionUtilities.buildSeasonalPart(root, baseline, container);
    }

    public static void buildSeasonalPart(Sequence root, Sequence baseline, ExtractionDataContainer container) {
        DlimFactory factory = DlimPackage.eINSTANCE.getDlimFactory();
        root.getSequenceFunctionContainers().clear();
        root.getCombine().clear();
        root.setTerminateAfterTime(container.getDuration());
        root.setTerminateAfterLoops(-1);
        ArrivalRateTuple[] interpolationPoints = new ArrivalRateTuple[container.getPeaks().length * 2 + 1];
        interpolationPoints[0] = new ArrivalRateTuple(0.0, container.getBase());
        interpolationPoints[interpolationPoints.length - 1] = new ArrivalRateTuple(container.getPeriod(), container.getBase());
        int i = 0;
        while (i < container.getPeaks().length) {
            interpolationPoints[i * 2 + 1] = container.getPeaks()[i];
            ++i;
        }
        if (container.getInnerBases() != null) {
            i = 0;
            while (i < container.getInnerBases().length) {
                interpolationPoints[i * 2 + 2] = container.getInnerBases()[i];
                ++i;
            }
        }
        i = 1;
        while (i < interpolationPoints.length) {
            TimeDependentFunctionContainer currentElement = factory.createTimeDependentFunctionContainer();
            currentElement.setName("seasonal" + i);
            currentElement.setDuration(interpolationPoints[i].getTimeStamp() - interpolationPoints[i - 1].getTimeStamp());
            Trend currentTrend = BasicTrendExtractionUtilities.createTrendWithCorrectShape(container.getSeasonalShape());
            currentTrend.setFunctionOutputAtStart(interpolationPoints[i - 1].getArrivalRate());
            currentTrend.setFunctionOutputAtEnd(interpolationPoints[i].getArrivalRate());
            currentElement.setFunction(currentTrend);
            root.getSequenceFunctionContainers().add((Object)currentElement);
            ++i;
        }
        baseline.getSequenceFunctionContainers().clear();
        baseline.getCombine().clear();
        baseline.setTerminateAfterTime(container.getDuration());
        baseline.setTerminateAfterLoops(-1);
        double maxPeak = 0.0;
        int i2 = 0;
        while (i2 < container.getPeaks().length) {
            if (container.getPeaks()[i2].getArrivalRate() > maxPeak) {
                maxPeak = container.getPeaks()[i2].getArrivalRate();
            }
            ++i2;
        }
        TimeDependentFunctionContainer constantContainer = factory.createTimeDependentFunctionContainer();
        constantContainer.setName("constant");
        constantContainer.setDuration(container.getPeriod());
        baseline.getSequenceFunctionContainers().add((Object)constantContainer);
        Constant constant = factory.createConstant();
        constant.setConstant(maxPeak);
        constantContainer.setFunction(constant);
    }

    public static void performMinMaxSearch(ExtractionDataContainer container) {
        boolean descending = true;
        container.getLocalMaxes().clear();
        container.getLocalMins().clear();
        if (container.getArrivalRateList().get(1).getArrivalRate() > container.getArrivalRateList().get(0).getArrivalRate()) {
            descending = false;
            container.getLocalMins().add(container.getArrivalRateList().get(0));
        } else {
            descending = true;
            container.getLocalMaxes().add(container.getArrivalRateList().get(0));
        }
        ArrivalRateTuple lastT = container.getArrivalRateList().get(0);
        for (ArrivalRateTuple t : container.getArrivalRateList()) {
            if (descending && t.getArrivalRate() > lastT.getArrivalRate()) {
                container.getLocalMins().add(lastT);
                descending = false;
            } else if (!descending && t.getArrivalRate() < lastT.getArrivalRate()) {
                container.getLocalMaxes().add(lastT);
                descending = true;
            }
            lastT = t;
        }
    }

    public static double getMaxPeakOffset(ArrivalRateTuple[] peaks) {
        int maxPeakIndex = 0;
        double currentMax = 0.0;
        int i = 0;
        while (i < peaks.length) {
            if (peaks[i].getArrivalRate() > currentMax) {
                maxPeakIndex = i;
                currentMax = peaks[i].getArrivalRate();
            }
            ++i;
        }
        return peaks[maxPeakIndex].getTimeStamp();
    }

    public static double getBaseLevel(ExtractionDataContainer container) {
        double[] bases = new double[(int)(container.getDuration() / container.getPeriod())];
        double currentTime = container.getLocalMins().get(0).getTimeStamp();
        int i = 0;
        while (i < bases.length) {
            bases[i] = BasicExtractionUtils.getArrivalRate(currentTime, container.getLocalMins(), false);
            currentTime += container.getPeriod();
            ++i;
        }
        Arrays.sort(bases);
        return BasicExtractionUtils.getMedian(bases);
    }

    public static int getPeakNum(ExtractionDataContainer container) {
        int[] peakNums = new int[(int)(container.getDuration() / container.getPeriod())];
        double currentSeasonalBegin = container.getLocalMins().get(0).getTimeStamp();
        int index = 0;
        for (ArrivalRateTuple t : container.getLocalMaxes()) {
            while (t.getTimeStamp() > currentSeasonalBegin + container.getPeriod()) {
                ++index;
                currentSeasonalBegin += container.getPeriod();
            }
            if (index >= peakNums.length) break;
            int n = index;
            peakNums[n] = peakNums[n] + 1;
        }
        Arrays.sort(peakNums);
        return peakNums[(peakNums.length - 1) / 2];
    }

    public static ArrivalRateTuple[] getInnerBases(ExtractionDataContainer container) {
        if (container.getPeaks().length <= 1) {
            return null;
        }
        int seasonals = (int)(container.getDuration() / container.getPeriod());
        int innerBaseCount = container.getPeaks().length - 1;
        ArrivalRateTuple[][] innerBasesPerPeak = new ArrivalRateTuple[innerBaseCount][seasonals];
        int i = 0;
        while (i < innerBaseCount) {
            double currentSeasonalBegin = container.getLocalMins().get(0).getTimeStamp();
            double samplingTime = (container.getPeaks()[i].getTimeStamp() + container.getPeaks()[i + 1].getTimeStamp()) / 2.0;
            int j = 0;
            while (j < seasonals) {
                ArrivalRateTuple tmpTuple = BasicExtractionUtils.getNearestArrivalRateTuple(samplingTime + currentSeasonalBegin, container.getLocalMins());
                innerBasesPerPeak[i][j] = new ArrivalRateTuple(tmpTuple.getTimeStamp() - currentSeasonalBegin, tmpTuple.getArrivalRate());
                currentSeasonalBegin += container.getPeriod();
                ++j;
            }
            ++i;
        }
        ArrivalRateTuple[] innerBases = new ArrivalRateTuple[innerBaseCount];
        int i2 = 0;
        while (i2 < innerBaseCount) {
            ArrivalRateTuple.setSortByTime(true);
            Arrays.sort(innerBasesPerPeak[i2]);
            double timeStamp = innerBasesPerPeak[i2][(innerBasesPerPeak[i2].length - 1) / 2].getTimeStamp();
            if (!(container.getPeaks()[i2].getTimeStamp() < timeStamp) || !(timeStamp < container.getPeaks()[i2 + 1].getTimeStamp())) {
                timeStamp = (container.getPeaks()[i2].getTimeStamp() + container.getPeaks()[i2 + 1].getTimeStamp()) / 2.0;
            }
            ArrivalRateTuple.setSortByTime(false);
            Arrays.sort(innerBasesPerPeak[i2]);
            double arrivalRate = innerBasesPerPeak[i2][(innerBasesPerPeak[i2].length - 1) / 2].getArrivalRate();
            innerBases[i2] = new ArrivalRateTuple(timeStamp, arrivalRate);
            ++i2;
        }
        return innerBases;
    }

    public static ArrivalRateTuple[] getPeaks(ExtractionDataContainer container) throws CalibrationException {
        int j;
        int seasonals = (int)(container.getDuration() / container.getPeriod());
        ArrayList[] peaksPerSeasonal = new ArrayList[seasonals];
        int i = 0;
        while (i < seasonals) {
            peaksPerSeasonal[i] = new ArrayList();
            ++i;
        }
        double currentSeasonalBegin = container.getLocalMins().get(0).getTimeStamp();
        int index = 0;
        for (ArrivalRateTuple t : container.getLocalMaxes()) {
            while (t.getTimeStamp() > currentSeasonalBegin + container.getPeriod()) {
                ++index;
                currentSeasonalBegin += container.getPeriod();
            }
            if (index >= seasonals) break;
            peaksPerSeasonal[index].add(new ArrivalRateTuple(t.getTimeStamp() - currentSeasonalBegin, t.getArrivalRate()));
        }
        ArrivalRateTuple.setSortByTime(true);
        int i2 = 0;
        while (i2 < seasonals) {
            Collections.sort(peaksPerSeasonal[i2]);
            ++i2;
        }
        ArrivalRateTuple[][] arrivalRateTuplesPerPeak = new ArrivalRateTuple[container.getPeakNum()][seasonals];
        int i3 = 0;
        while (i3 <= container.getPeakNum() / 2) {
            j = 0;
            while (j < seasonals) {
                try {
                    arrivalRateTuplesPerPeak[i3][j] = (ArrivalRateTuple)peaksPerSeasonal[j].get(i3);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    try {
                        arrivalRateTuplesPerPeak[i3][j] = new ArrivalRateTuple(0.0, 0.0);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException2) {
                        throw new CalibrationException("Seasonal Period is too small.");
                    }
                }
                ++j;
            }
            ++i3;
        }
        i3 = container.getPeakNum() - 1;
        while (i3 > container.getPeakNum() / 2) {
            j = 0;
            while (j < seasonals) {
                try {
                    arrivalRateTuplesPerPeak[i3][j] = (ArrivalRateTuple)peaksPerSeasonal[j].get(peaksPerSeasonal[j].size() - (container.getPeakNum() - i3));
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    arrivalRateTuplesPerPeak[i3][j] = new ArrivalRateTuple(0.0, 0.0);
                }
                ++j;
            }
            --i3;
        }
        Object[] peaks = new ArrivalRateTuple[container.getPeakNum()];
        ArrivalRateTuple.setSortByTime(true);
        int i4 = 0;
        while (i4 < container.getPeakNum()) {
            Arrays.sort(arrivalRateTuplesPerPeak[i4]);
            peaks[i4] = new ArrivalRateTuple(BasicExtractionUtils.getMedianTimeStamp(arrivalRateTuplesPerPeak[i4]), 0.0);
            ++i4;
        }
        ArrivalRateTuple.setSortByTime(false);
        i4 = 0;
        while (i4 < container.getPeakNum()) {
            Arrays.sort(arrivalRateTuplesPerPeak[i4]);
            ((ArrivalRateTuple)peaks[i4]).setArrivalRate(BasicExtractionUtils.getMedianArrivalRate(arrivalRateTuplesPerPeak[i4]));
            ++i4;
        }
        ArrivalRateTuple.setSortByTime(true);
        Arrays.sort(peaks);
        return peaks;
    }
}

