/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.reader;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import tools.descartes.dlim.DlimGeneratorPlugin;
import tools.descartes.dlim.generator.ArrivalRateTuple;

public final class ArrivalRateReader {
    private ArrivalRateReader() {
    }

    public static double getArrivalRateAtTimeFromFile(double time, String filePath) throws IOException {
        String line;
        if (time <= 0.0) {
            return 0.0;
        }
        BufferedReader br = new BufferedReader(new FileReader(filePath));
        double lowerTimeStamp = 0.0;
        double lowerArrivalRate = 0.0;
        double upperTimeStamp = 0.0;
        double upperArrivalRate = 0.0;
        while ((line = br.readLine()) != null && upperTimeStamp < time) {
            lowerTimeStamp = upperTimeStamp;
            lowerArrivalRate = upperArrivalRate;
            String[] numbers = (line = line.substring(0, line.length() - 1)).split(",");
            if (numbers.length < 2) continue;
            try {
                upperTimeStamp = Double.parseDouble(numbers[0].trim());
            }
            catch (NumberFormatException numberFormatException) {
                upperTimeStamp = 0.0;
            }
            try {
                upperArrivalRate = Double.parseDouble(numbers[1].trim());
            }
            catch (NumberFormatException numberFormatException) {
                upperArrivalRate = 0.0;
            }
        }
        br.close();
        if (upperTimeStamp < time) {
            return 0.0;
        }
        return lowerArrivalRate + (time - lowerTimeStamp) * (upperArrivalRate - lowerArrivalRate) / (upperTimeStamp - lowerTimeStamp);
    }

    public static List<ArrivalRateTuple> readFileToList(String filePath, double offset) throws IOException {
        String line;
        ArrayList<ArrivalRateTuple> arrRates = new ArrayList<ArrivalRateTuple>();
        Path txtFilePath = new Path(filePath.trim());
        BufferedReader br = new BufferedReader(new FileReader(txtFilePath.toString()));
        while ((line = br.readLine()) != null) {
            String[] numbers = (line = line.substring(0, line.length() - 1)).split(",");
            if (numbers.length < 2) continue;
            try {
                double timeStamp = Double.parseDouble(numbers[0].trim());
                double readArrivalRate = Double.parseDouble(numbers[1].trim());
                timeStamp -= offset;
                if (!(timeStamp > 0.0)) continue;
                arrRates.add(new ArrivalRateTuple(timeStamp, readArrivalRate));
            }
            catch (NumberFormatException numberFormatException) {
                DlimGeneratorPlugin.INSTANCE.log(new Status(4, "tools.descartes.dlim.generator", "Wrong file format, number expected."));
            }
        }
        br.close();
        return arrRates;
    }
}

